/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.entity;

import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.server.ServerUtils;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.permission.PermissionAPI;

public class PermissionUtils {
    private PermissionUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static boolean isOperator(PlayerEntity player) {
        MinecraftServer server = ServerUtils.getServer();
        return server != null && server.func_184103_al() != null && server.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null;
    }

    public static boolean hasPermission(PlayerEntity player, String perm) {
        return FMLEnvironment.dist == Dist.CLIENT || PermissionAPI.hasPermission((PlayerEntity)player, (String)perm) || PermissionUtils.isOperator(player);
    }

    public static boolean hasPermission(CommandSource source, String perm) {
        boolean isPlayer = source.func_197022_f() instanceof PlayerEntity;
        return FMLEnvironment.dist == Dist.CLIENT || isPlayer && PermissionUtils.hasPermission((PlayerEntity)source.func_197022_f(), perm) || !isPlayer && source.func_197034_c(4);
    }

    public static boolean hasPermission(PlayerReference player, String perm) {
        return player.entity().map(entity -> PermissionUtils.hasPermission((PlayerEntity)entity, perm)).orElse(false);
    }

    public static boolean canUse(PlayerEntity player, String perm) {
        return PermissionUtils.hasPermission(player, perm);
    }

    public static boolean canUse(String perm, PlayerEntity player) {
        return PermissionUtils.hasPermission(player, perm);
    }

    public static boolean hasPermission(String perm, PlayerEntity player) {
        return PermissionUtils.hasPermission(player, perm);
    }

    public static boolean canUse(CommandSource source, String perm) {
        return PermissionUtils.hasPermission(source, perm);
    }

    public static boolean canUse(String perm, CommandSource source) {
        return PermissionUtils.hasPermission(source, perm);
    }

    public static boolean hasPermission(String perm, CommandSource source) {
        return PermissionUtils.hasPermission(source, perm);
    }

    public static boolean canUse(PlayerReference player, String perm) {
        return PermissionUtils.hasPermission(player, perm);
    }

    public static boolean canUse(String perm, PlayerReference player) {
        return PermissionUtils.hasPermission(player, perm);
    }

    public static boolean hasPermission(String perm, PlayerReference player) {
        return PermissionUtils.hasPermission(player, perm);
    }

    public static boolean canUseCommand(PlayerEntity sender, String domain, String command, boolean isAdmin, String ... qualifers) {
        return PermissionUtils.canUse(PermissionUtils.getPermNode(domain, command, isAdmin, qualifers), sender);
    }

    public static boolean canUseCommand(CommandSource sender, String domain, String command, boolean isAdmin, String ... qualifers) {
        return PermissionUtils.canUse(PermissionUtils.getPermNode(domain, command, isAdmin, qualifers), sender);
    }

    public static String getPermNode(String domain, String command, boolean isAdmin, String ... qualifers) {
        StringBuilder builder = new StringBuilder();
        builder.append(domain).append(".").append(isAdmin ? "admin." : "user.").append(command);
        if (qualifers != null) {
            for (String qualifer : qualifers) {
                builder.append(".").append(qualifer);
            }
        }
        return builder.toString();
    }
}

