/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.entity;

import de.waterdu.atlantis.util.concurrency.Concurrency;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.java.NumberUtils;
import de.waterdu.atlantis.util.java.RandomUtils;
import de.waterdu.atlantis.util.level.LevelPosition;
import de.waterdu.atlantis.util.level.Position;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerLookPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityUtils {
    private EntityUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static void addEffect(LivingEntity entity, Effect potion, int duration, int amplifier) {
        EntityUtils.addEffect(entity, potion, duration, amplifier, true, false);
    }

    public static void addEffect(LivingEntity entity, Effect potion, int duration, int amplifier, boolean ambient, boolean particles) {
        Concurrency.mainThread(() -> entity.func_195064_c(new EffectInstance(potion, duration, amplifier, ambient, particles)));
    }

    public static void playSound(PlayerEntity entity, SoundEvent sound) {
        EntityUtils.playSound(entity, sound, SoundCategory.MASTER);
    }

    public static void playSound(PlayerEntity entity, SoundEvent sound, float volume, float pitch) {
        EntityUtils.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public static void playSound(PlayerEntity entity, SoundEvent sound, SoundCategory category) {
        EntityUtils.playSound(entity, sound, category, 1.0f, 1.0f);
    }

    public static void playSound(PlayerEntity entity, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        entity.func_213823_a(sound, category, volume, pitch);
    }

    public static AxisAlignedBB getAreaAround(Entity entity, double radius) {
        return EntityUtils.getAreaAround(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), radius);
    }

    public static AxisAlignedBB getAreaAround(double x, double y, double z, double radius) {
        return new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
    }

    public static boolean moveToSafeLocation(Entity entity) {
        World level = entity.field_70170_p;
        double d0 = -1.0;
        int j = MathHelper.func_76128_c((double)entity.func_226277_ct_());
        int k = MathHelper.func_76128_c((double)entity.func_226278_cu_());
        int l = MathHelper.func_76128_c((double)entity.func_226281_cx_());
        int i1 = j;
        int j1 = k;
        int k1 = l;
        int i2 = RandomUtils.getRandom().nextInt(4);
        BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable(0, 0, 0);
        for (int j2 = j - 16; j2 <= j + 16; ++j2) {
            double d1 = (double)j2 + 0.5 - entity.func_226277_ct_();
            for (int l2 = l - 16; l2 <= l + 16; ++l2) {
                double d2 = (double)l2 + 0.5 - entity.func_226281_cx_();
                block2: for (int j3 = level.func_234938_ad_() - 1; j3 >= 0; --j3) {
                    if (!level.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3, l2)).func_196958_f()) continue;
                    while (j3 > 0 && level.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3 - 1, l2)).func_196958_f()) {
                        --j3;
                    }
                    for (int k3 = i2; k3 < i2 + 4; ++k3) {
                        int l3 = k3 % 2;
                        int i4 = 1 - l3;
                        if (k3 % 4 >= 2) {
                            l3 = -l3;
                            i4 = -i4;
                        }
                        for (int j4 = 0; j4 < 3; ++j4) {
                            for (int k4 = 0; k4 < 4; ++k4) {
                                for (int l4 = -1; l4 < 4; ++l4) {
                                    int i5 = j2 + (k4 - 1) * l3 + j4 * i4;
                                    int j5 = j3 + l4;
                                    int k5 = l2 + (k4 - 1) * i4 - j4 * l3;
                                    blockpos$mutableblockpos.func_181079_c(i5, j5, k5);
                                    if (l4 < 0 && !level.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() || l4 >= 0 && !level.func_180495_p((BlockPos)blockpos$mutableblockpos).func_196958_f()) continue block2;
                                }
                            }
                        }
                        double d5 = (double)j3 + 0.5 - entity.func_226278_cu_();
                        double d7 = d1 * d1 + d5 * d5 + d2 * d2;
                        if (!(d0 < 0.0) && !(d7 < d0)) continue;
                        d0 = d7;
                        i1 = j2;
                        j1 = j3;
                        k1 = l2;
                    }
                }
            }
        }
        if (d0 < 0.0) {
            for (int l5 = j - 16; l5 <= j + 16; ++l5) {
                double d3 = (double)l5 + 0.5 - entity.func_226277_ct_();
                for (int j6 = l - 16; j6 <= l + 16; ++j6) {
                    double d4 = (double)j6 + 0.5 - entity.func_226281_cx_();
                    block10: for (int i7 = level.func_234938_ad_() - 1; i7 >= 0; --i7) {
                        if (!level.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7, j6)).func_196958_f()) continue;
                        while (i7 > 0 && level.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7 - 1, j6)).func_196958_f()) {
                            --i7;
                        }
                        for (int k7 = i2; k7 < i2 + 2; ++k7) {
                            int j8 = k7 % 2;
                            int j9 = 1 - j8;
                            for (int j10 = 0; j10 < 4; ++j10) {
                                for (int j11 = -1; j11 < 4; ++j11) {
                                    int j12 = l5 + (j10 - 1) * j8;
                                    int i13 = i7 + j11;
                                    int j13 = j6 + (j10 - 1) * j9;
                                    blockpos$mutableblockpos.func_181079_c(j12, i13, j13);
                                    if (j11 < 0 && !level.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() || j11 >= 0 && !level.func_180495_p((BlockPos)blockpos$mutableblockpos).func_196958_f()) continue block10;
                                }
                            }
                            double d6 = (double)i7 + 0.5 - entity.func_226278_cu_();
                            double d8 = d3 * d3 + d6 * d6 + d4 * d4;
                            if (!(d0 < 0.0) && !(d8 < d0)) continue;
                            d0 = d8;
                            i1 = l5;
                            j1 = i7;
                            k1 = j6;
                        }
                    }
                }
            }
        }
        int i6 = i1;
        int k2 = j1 + 2;
        int k6 = k1;
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147364_a((double)i6, (double)k2, (double)k6, entity.field_70177_z, entity.field_70125_A);
        } else {
            entity.func_242281_f((double)i6, (double)k2, (double)k6);
        }
        return true;
    }

    public static float lookAt(Position target, LivingEntity entity) {
        double dx = entity.func_226277_ct_() - target.func_82615_a();
        double dy = entity.func_226278_cu_() - target.func_82617_b();
        double dz = entity.func_226281_cx_() - target.func_82616_c();
        double invSqrt = 1.0 / Math.sqrt(dx * dx + dy * dy + dz * dz);
        double pitch = Math.asin(dy *= invSqrt);
        double yaw = Math.atan2(dz *= invSqrt, dx *= invSqrt);
        pitch = pitch * 180.0 / Math.PI;
        yaw = yaw * 180.0 / Math.PI;
        entity.field_70177_z = NumberUtils.boundFloat((float)(yaw += 90.0));
        entity.field_70125_A = NumberUtils.boundFloat((float)pitch);
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            SPlayerLookPacket packet = new SPlayerLookPacket(EntityAnchorArgument.Type.EYES, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            player.field_71135_a.func_147359_a((IPacket)packet);
        }
        return (float)yaw;
    }

    public static void addVelocity(Entity entity, double x, double y, double z) {
        entity.func_213317_d(entity.func_213322_ci().func_72441_c(x, y, z));
        entity.field_70160_al = true;
    }

    public static void setVelocity(Entity entity, double x, double y, double z) {
        entity.func_213293_j((double)NumberUtils.boundFloat(x), (double)NumberUtils.boundFloat(y), (double)NumberUtils.boundFloat(z));
        entity.field_70160_al = true;
    }

    public static <E extends Entity> Optional<E> createEntity(EntityType<E> type, LevelPosition position, boolean noop, boolean spawn, Consumer<E> modifier) {
        return position.createEntity(type).map(entity -> {
            if (noop) {
                if (type.equals(EntityType.field_200789_c)) {
                    entity.func_184212_Q().func_187227_b(ArmorStandEntity.field_184801_a, (Object)NumberUtils.setBit((Byte)entity.func_184212_Q().func_187225_a(ArmorStandEntity.field_184801_a), 8, true));
                }
                entity.func_184224_h(true);
                entity.func_174810_b(true);
                entity.func_189654_d(true);
                entity.func_82142_c(true);
                entity.field_70145_X = true;
                entity.field_98038_p = true;
            }
            modifier.accept(entity);
            if (spawn) {
                Concurrency.mainThread(() -> position.level().func_217376_c(entity));
            }
            return entity;
        });
    }
}

