/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.config;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import de.waterdu.atlantis.file.storage.Redis;
import de.waterdu.atlantis.util.java.JsonUtils;
import java.lang.reflect.Type;
import java.util.Map;

public abstract class RedisSettings {
    protected static final TypeToken<Map<String, String>> STRING_STRING_MAP_TYPE = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, String.class});
    protected Map<String, String> properties;

    private RedisSettings(Map<String, String> properties) {
        this.properties = properties;
    }

    public abstract Redis getStorage(String var1);

    public static RedisSettings getDefault() {
        return new Explicit();
    }

    public static class TypeAdapter
    implements JsonSerializer<RedisSettings>,
    JsonDeserializer<RedisSettings> {
        public RedisSettings deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return new URL(json.getAsString());
            }
            JsonObject object = json.getAsJsonObject();
            Map properties = JsonUtils.getOrDefault(object, "properties", STRING_STRING_MAP_TYPE, Maps.newHashMap(), context);
            RedisSettings settings = object.has("url") ? new URL(object.get("url").getAsString(), properties) : new Explicit(object.get("ip").getAsString(), object.get("port").getAsInt(), object.get("username").getAsString(), object.get("password").getAsString(), properties);
            return settings;
        }

        public JsonElement serialize(RedisSettings src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            if (src instanceof URL) {
                object.addProperty("url", ((URL)src).url);
            } else {
                Explicit explicit = (Explicit)src;
                object.addProperty("ip", explicit.ip);
                object.addProperty("port", (Number)explicit.port);
                object.addProperty("username", explicit.username);
                object.addProperty("password", explicit.password);
            }
            if (!src.properties.isEmpty()) {
                object.add("properties", context.serialize(src.properties));
            }
            return object;
        }
    }

    public static class Explicit
    extends RedisSettings {
        private final String ip;
        private final int port;
        private final String username;
        private final String password;

        public Explicit() {
            this("127.0.0.1", 6379, "username", "password");
        }

        public Explicit(String ip, int port, String username, String password) {
            this(ip, port, username, password, Maps.newHashMap());
        }

        public Explicit(String ip, int port, String username, String password, Map<String, String> properties) {
            super(properties);
            this.ip = ip;
            this.port = port;
            this.username = username;
            this.password = password;
        }

        @Override
        public Redis getStorage(String modID) {
            return new Redis(this.ip, this.port, this.username, this.password);
        }
    }

    public static class URL
    extends RedisSettings {
        private final String url;

        public URL() {
            this("redis://username:password@ip:port/");
        }

        public URL(String url) {
            this(url, Maps.newHashMap());
        }

        public URL(String url, Map<String, String> properties) {
            super(properties);
            this.url = url;
        }

        @Override
        public Redis getStorage(String modID) {
            return new Redis(this.url);
        }
    }
}

