/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.file.AtlantisConfigProxy;
import de.waterdu.atlantis.file.datatypes.Data;
import de.waterdu.atlantis.meta.LeaderboardEvent;
import de.waterdu.atlantis.util.concurrency.Concurrency;
import de.waterdu.atlantis.util.text.TextUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Leaderboard<T extends Data, V extends Comparable<V>> {
    protected static final Map<String, Leaderboard<?, ?>> ALL_LEADERBOARDS = Maps.newConcurrentMap();
    private final String owner;
    private final String[] getterName;
    private final Method getter;
    private final Class<T> dataClass;
    private final String dataClassName;
    private final Class<V> valueClass;
    private final String valueClassName;
    private final boolean reverse;
    private Map<UUID, V> rankings;
    private final Map<UUID, V> queued;
    private final List<UUID> rankingsList = Lists.newCopyOnWriteArrayList();
    private final TypeToken<Map<UUID, V>> mapTypeToken;
    private final String stringKey;

    private Leaderboard(String owner, Class<T> dataClass, String getter, Class<V> valueClass, boolean reverse) throws NoSuchMethodException {
        this.owner = owner;
        this.dataClass = dataClass;
        this.dataClassName = dataClass.getName();
        this.getterName = getter.split("#");
        this.getter = this.getterName.length == 1 ? dataClass.getDeclaredMethod(this.getterName[0], new Class[0]) : dataClass.getDeclaredMethod(this.getterName[0], String.class);
        this.valueClass = valueClass;
        this.valueClassName = valueClass.getName();
        this.reverse = reverse;
        this.rankings = new LinkedHashMap<UUID, V>();
        this.queued = new ConcurrentHashMap<UUID, V>();
        this.mapTypeToken = Leaderboard.makeMapTypeToken(this.valueClass);
        this.stringKey = "Leaderboard{" + this.owner + "," + this.dataClass.getSimpleName() + "," + this.getterName + "," + this.valueClass.getSimpleName() + "}";
    }

    public Leaderboard<T, V> withRankings(Map<UUID, ? extends Comparable<?>> rankings) {
        this.rankings.putAll(rankings);
        return this;
    }

    public Leaderboard<T, V> withQueued(Map<UUID, ? extends Comparable<?>> queued) {
        this.queued.putAll(queued);
        return this;
    }

    public static <T extends Data, V extends Comparable<V>> Leaderboard<T, V> create(String owner, Class<T> dataClass, String getter, Class<V> valueClass, boolean reverse) throws NoSuchMethodException {
        Leaderboard<T, V> leaderboard = new Leaderboard<T, V>(owner, dataClass, getter, valueClass, reverse);
        ALL_LEADERBOARDS.put(leaderboard.toString(), leaderboard);
        return leaderboard;
    }

    public static <T extends Data, V extends Comparable<V>> Leaderboard<T, V> create(String owner, Class<T> dataClass, String getter, String arg, Class<V> valueClass, boolean reverse) throws NoSuchMethodException {
        return Leaderboard.create(owner, dataClass, getter + "#" + arg, valueClass, reverse);
    }

    private static <V extends Comparable<V>> TypeToken<Map<UUID, V>> makeMapTypeToken(Class<V> valueClass) {
        return TypeToken.getParameterized(Map.class, (Type[])new Type[]{UUID.class, valueClass});
    }

    public String getOwner() {
        return this.owner;
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    public Map<UUID, V> getRankings() {
        return ImmutableMap.copyOf(this.rankings);
    }

    public Map<UUID, V> getQueued() {
        return ImmutableMap.copyOf(this.queued);
    }

    public List<UUID> getRankingsList() {
        return this.rankingsList;
    }

    public boolean isOnLeaderboard(UUID uuid) {
        return this.rankings.containsKey(uuid) || this.queued.containsKey(uuid);
    }

    public int getPosition(UUID uuid) {
        if (this.queued.containsKey(uuid)) {
            return this.rankings.size();
        }
        return this.rankingsList.indexOf(uuid);
    }

    public CompletableFuture<List<T>> getFirstN(int n) {
        CompletableFuture<List<T>> future = new CompletableFuture<List<T>>();
        Atlantis.THREAD_POOL.submit(() -> {
            long timeout = Settings.getSettings().getLeaderboardGetDataTimeoutSeconds();
            List<UUID> rankingsCopy = this.getRankingsList();
            AtlantisConfigProxy.Impl config = AtlantisConfigProxy.of(this.getOwner());
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < Math.min(rankingsCopy.size(), n); ++i) {
                UUID uuid = rankingsCopy.get(i);
                try {
                    list.add(config.getFor(this.getDataClass(), uuid).get(timeout, TimeUnit.SECONDS));
                    continue;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    AtlantisLogger.warn("Failed to fetch data when getting for leaderboard: " + uuid, new Object[0]);
                }
            }
            future.complete(list);
        });
        return future;
    }

    public CompletableFuture<T> get(int n) {
        CompletableFuture future = new CompletableFuture();
        Atlantis.THREAD_POOL.submit(() -> {
            long timeout = Settings.getSettings().getLeaderboardGetDataTimeoutSeconds();
            List<UUID> rankingsCopy = this.getRankingsList();
            if (rankingsCopy.size() < n) {
                future.completeExceptionally(new IndexOutOfBoundsException());
            } else {
                UUID uuid = rankingsCopy.get(n - 1);
                AtlantisConfigProxy.Impl config = AtlantisConfigProxy.of(this.getOwner());
                try {
                    future.complete(config.getFor(this.getDataClass(), uuid).get(timeout, TimeUnit.SECONDS));
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    AtlantisLogger.warn("Failed to fetch data when getting for leaderboard: " + uuid, new Object[0]);
                    future.completeExceptionally(e);
                }
            }
        });
        return future;
    }

    public CompletableFuture<List<T>> getAll() {
        return this.getFirstN(this.rankingsList.size());
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public boolean update(T data) {
        try {
            UUID key = data.getUUID();
            Comparable value = this.getterName.length == 1 ? (Comparable)this.getter.invoke(data, new Object[0]) : (Comparable)this.getter.invoke(data, this.getterName[1]);
            if (!Atlantis.EVENT_BUS.post(new LeaderboardEvent.Update(this, data, key, value))) {
                if (this.rankings.containsKey(key)) {
                    this.rankings.put(key, value);
                } else {
                    this.queued.put(key, value);
                }
            }
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            AtlantisLogger.error("Failed to update leaderboard data!", new Object[0]);
            AtlantisLogger.error(this.stringKey, new Object[0]);
            AtlantisLogger.error("Data: " + data.getUUID(), new Object[0]);
            e.printStackTrace();
            return false;
        }
    }

    public CompletableFuture<Void> recalculate(boolean async) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Runnable recalculateTask = () -> {
            if (!Atlantis.EVENT_BUS.post(new LeaderboardEvent.Recalculate.Pre(this))) {
                ArrayList<Map.Entry<UUID, V>> entries = new ArrayList<Map.Entry<UUID, V>>(this.queued.entrySet());
                entries.addAll(this.rankings.entrySet());
                this.queued.clear();
                Comparator comparator = Map.Entry.comparingByValue();
                if (this.reverse) {
                    comparator = comparator.reversed();
                }
                entries.sort(comparator);
                LinkedHashMap newRanking = new LinkedHashMap();
                for (Map.Entry entry : entries) {
                    newRanking.put((UUID)entry.getKey(), entry.getValue());
                }
                this.rankings = newRanking;
                this.rankingsList.clear();
                this.rankingsList.addAll(this.rankings.keySet());
                Atlantis.EVENT_BUS.post(new LeaderboardEvent.Recalculate.Post(this));
            }
            future.complete(null);
        };
        if (async) {
            Atlantis.THREAD_POOL.submit(recalculateTask);
        } else {
            recalculateTask.run();
        }
        return future;
    }

    public static void recalculateAll(boolean multithreaded) {
        if (!Atlantis.EVENT_BUS.post(new LeaderboardEvent.Recalculate.PreAll(null))) {
            CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
            for (Leaderboard<?, ?> leaderboard : ALL_LEADERBOARDS.values()) {
                future = leaderboard.recalculate(multithreaded);
            }
            future.whenComplete((v, err) -> Concurrency.mainThread(() -> Atlantis.EVENT_BUS.post(new LeaderboardEvent.Recalculate.PostAll(null))));
        }
    }

    public int hashCode() {
        return this.stringKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Leaderboard)) {
            return false;
        }
        return this.stringKey.equals(((Leaderboard)obj).stringKey);
    }

    public String toString() {
        return this.stringKey;
    }

    public static class LeaderboardTypeAdapter
    implements JsonSerializer<Leaderboard<?, ?>>,
    JsonDeserializer<Leaderboard<?, ?>> {
        public Leaderboard<?, ?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            String owner = object.get("owner").getAsString();
            String getter = object.get("getter").getAsString();
            try {
                Class<?> dataClass = Class.forName(object.get("dataClass").getAsString());
                Class<?> valueClass = Class.forName(object.get("valueClass").getAsString());
                boolean reverse = object.get("reverse").getAsBoolean();
                TypeToken mapTypeToken = TypeToken.getParameterized(Map.class, (Type[])new Type[]{UUID.class, valueClass});
                Type mapType = mapTypeToken.getType();
                Map rankings = (Map)context.deserialize(object.get("rankings"), mapType);
                Map queued = (Map)context.deserialize(object.get("queued"), mapType);
                Leaderboard<?, ?> leaderboard = Leaderboard.create(owner, dataClass, getter, valueClass, reverse).withRankings(rankings).withQueued(queued);
                leaderboard.recalculate(false);
                return leaderboard;
            }
            catch (Exception e) {
                throw new JsonParseException("Failed to parse leaderboard with owner " + owner + " and getter " + getter);
            }
        }

        public JsonElement serialize(Leaderboard<?, ?> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("owner", ((Leaderboard)src).owner);
            object.addProperty("getter", TextUtils.concat(0, "#", ((Leaderboard)src).getterName));
            object.addProperty("dataClass", ((Leaderboard)src).dataClassName);
            object.addProperty("valueClass", ((Leaderboard)src).valueClassName);
            object.addProperty("reverse", Boolean.valueOf(((Leaderboard)src).reverse));
            object.add("rankings", context.serialize((Object)((Leaderboard)src).rankings, ((Leaderboard)src).mapTypeToken.getType()));
            object.add("queued", context.serialize((Object)((Leaderboard)src).queued, ((Leaderboard)src).mapTypeToken.getType()));
            return object;
        }
    }
}

