/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.config;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.file.storage.Database;
import de.waterdu.atlantis.util.java.JsonUtils;
import java.lang.reflect.Type;
import java.util.Map;

public abstract class DatabaseSettings {
    protected static final TypeToken<Map<String, String>> STRING_STRING_MAP_TYPE = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, String.class});
    protected static final int MIN_IDLE_DEFAULT = 5;
    protected static final int CONNECTION_TIMEOUT_DEFAULT = 10000;
    protected static final int IDLE_TIMEOUT_DEFAULT = 600000;
    protected static final int LEAK_DETECTION_DEFAULT = 600000;
    protected int connections;
    protected int minIdle = 5;
    protected int connectionTimeout = 10000;
    protected int idleTimeout = 600000;
    protected int leakDetection = 600000;
    protected Map<String, String> properties;

    private DatabaseSettings(int connections, Map<String, String> properties) {
        this.connections = connections;
        this.properties = properties;
    }

    public abstract Database getStorage(String var1);

    public int getConnections() {
        return this.connections;
    }

    public boolean areExtraSettingsDefaults() {
        return this.minIdle == 5 && this.connectionTimeout == 10000 && this.idleTimeout == 600000 && this.leakDetection == 600000 && this.properties.isEmpty();
    }

    public static DatabaseSettings getDefault() {
        return new Explicit();
    }

    public static class TypeAdapter
    implements JsonSerializer<DatabaseSettings>,
    JsonDeserializer<DatabaseSettings> {
        public DatabaseSettings deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                String url = json.getAsString();
                String[] split2 = url.split(" ");
                if (split2.length == 2) {
                    return new URL(Integer.parseInt(split2[0]), split2[1], Maps.newHashMap());
                }
                return new URL(url);
            }
            JsonObject object = json.getAsJsonObject();
            int connections = JsonUtils.getOrDefault(object, "connections", Integer.TYPE, Integer.valueOf(Settings.getSettings().getDefaultDatabaseConnections()), context);
            Map properties = JsonUtils.getOrDefault(object, "properties", STRING_STRING_MAP_TYPE, Maps.newHashMap(), context);
            DatabaseSettings settings = object.has("url") ? new URL(connections, object.get("url").getAsString(), properties) : new Explicit(connections, object.get("ip").getAsString(), object.get("port").getAsInt(), object.get("username").getAsString(), object.get("password").getAsString(), properties);
            settings.minIdle = JsonUtils.getOrDefault(object, "minIdle", Integer.TYPE, Integer.valueOf(settings.minIdle), context);
            settings.connectionTimeout = JsonUtils.getOrDefault(object, "connectionTimeout", Integer.TYPE, Integer.valueOf(settings.connectionTimeout), context);
            settings.idleTimeout = JsonUtils.getOrDefault(object, "idleTimeout", Integer.TYPE, Integer.valueOf(settings.idleTimeout), context);
            settings.leakDetection = JsonUtils.getOrDefault(object, "leakDetection", Integer.TYPE, Integer.valueOf(settings.leakDetection), context);
            return settings;
        }

        public JsonElement serialize(DatabaseSettings src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            if (src instanceof URL) {
                URL url = (URL)src;
                if (url.areExtraSettingsDefaults()) {
                    if (url.connections == Settings.getSettings().getDefaultDatabaseConnections()) {
                        return new JsonPrimitive(url.url);
                    }
                    return new JsonPrimitive(url.connections + " " + url.url);
                }
                object.addProperty("url", url.url);
            } else {
                Explicit explicit = (Explicit)src;
                object.addProperty("ip", explicit.ip);
                object.addProperty("port", (Number)explicit.port);
                object.addProperty("username", explicit.username);
                object.addProperty("password", explicit.password);
            }
            object.addProperty("connections", (Number)src.connections);
            if (src.minIdle != 5) {
                object.addProperty("minIdle", (Number)src.minIdle);
            }
            if (src.connectionTimeout != 10000) {
                object.addProperty("connectionTimeout", (Number)src.connectionTimeout);
            }
            if (src.idleTimeout != 600000) {
                object.addProperty("idleTimeout", (Number)src.idleTimeout);
            }
            if (src.leakDetection != 600000) {
                object.addProperty("leakDetection", (Number)src.leakDetection);
            }
            if (!src.properties.isEmpty()) {
                object.add("properties", context.serialize(src.properties));
            }
            return object;
        }
    }

    public static class Explicit
    extends DatabaseSettings {
        private final String ip;
        private final int port;
        private final String username;
        private final String password;

        public Explicit() {
            this("127.0.0.1", 3306, "username", "password");
        }

        public Explicit(String ip, int port, String username, String password) {
            this(Settings.getSettings().getDefaultDatabaseConnections(), ip, port, username, password, Maps.newHashMap());
        }

        public Explicit(int connections, String ip, int port, String username, String password, Map<String, String> properties) {
            super(connections, properties);
            this.ip = ip;
            this.port = port;
            this.username = username;
            this.password = password;
        }

        @Override
        public Database getStorage(String modID) {
            return new Database(modID, this.ip, this.port, this.username, this.password, this.getConnections(), new String[0]);
        }
    }

    public static class URL
    extends DatabaseSettings {
        private final String url;

        public URL() {
            this("jdbc:mysql://user:password@ip:port/");
        }

        public URL(String url) {
            this(Settings.getSettings().getDefaultDatabaseConnections(), url, Maps.newHashMap());
        }

        public URL(int connections, String url, Map<String, String> properties) {
            super(connections, properties);
            this.url = url;
        }

        @Override
        public Database getStorage(String modID) {
            return new Database(this.url, modID, this.getConnections(), new String[0]);
        }
    }
}

