/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.concurrency;

import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.ui.api.AtlantisUI;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.server.ServerUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class Concurrency {
    private Concurrency() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static void offThread(Runnable task) {
        Atlantis.THREAD_POOL.submit(task);
    }

    public static void mainThread(Runnable task) {
        ServerUtils.getServer().execute(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                AtlantisLogger.error("Caught exception in Atlantis! Continuing...", new Object[0]);
                e.printStackTrace();
            }
        });
    }

    public static void mainThread(PlayerEntity player, Page fallback, Runnable task) {
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                AtlantisLogger.error("Caught exception in Atlantis! Falling back...", new Object[0]);
                e.printStackTrace();
                player.func_145747_a((ITextComponent)Atlantis.ERROR_MESSAGE, Util.field_240973_b_);
                AtlantisUI.open(player, null);
                ServerLifecycleHooks.getCurrentServer().execute(() -> AtlantisUI.open(player, fallback));
            }
        });
    }
}

