/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.concurrency;

import com.google.common.collect.Sets;
import de.waterdu.atlantis.AtlantisLogger;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AtlantisThreadPool {
    private static final Set<AtlantisThreadPool> ALL_POOLS = Sets.newHashSet();
    private final ScheduledThreadPoolExecutor pool;
    private boolean keepAlive = true;
    private boolean catchErrors = true;

    private AtlantisThreadPool(String modid, int size, boolean daemon) {
        this.pool = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(size, new Factory(modid, daemon));
    }

    public static AtlantisThreadPool createNewThreadPool(String name, int size, boolean daemon) {
        AtlantisThreadPool pool = new AtlantisThreadPool(name, size, daemon);
        ALL_POOLS.add(pool);
        return pool;
    }

    public static void shutdownAll() {
        for (AtlantisThreadPool pool : ALL_POOLS) {
            if (pool.keepAlive) continue;
            pool.pool.shutdown();
        }
    }

    public AtlantisThreadPool keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public AtlantisThreadPool setSize(int size) {
        this.pool.setCorePoolSize(size);
        return this;
    }

    public AtlantisThreadPool shouldCatchErrors(boolean catchErrors) {
        this.catchErrors = catchErrors;
        return this;
    }

    private Runnable encapsulateRunnable(Runnable runnable) {
        if (this.catchErrors) {
            return () -> {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    AtlantisLogger.error("An internal error has occurred in Atlantis! Please inform your server administrator of this!", new Object[0]);
                    e.printStackTrace();
                }
            };
        }
        return runnable;
    }

    private <T> Callable<T> encapsulateCallable(Callable<T> callable, T fallback) {
        if (this.catchErrors) {
            return () -> {
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    AtlantisLogger.error("An internal error has occurred in Atlantis! Please inform your server administrator of this!", new Object[0]);
                    e.printStackTrace();
                    return fallback;
                }
            };
        }
        return callable;
    }

    public ScheduledFuture<?> submit(Runnable runnable) {
        return (ScheduledFuture)this.pool.submit(this.encapsulateRunnable(runnable));
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long delay) {
        return this.schedule(runnable, delay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
        return this.pool.schedule(this.encapsulateRunnable(runnable), delay, timeUnit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long delay, long period) {
        return this.scheduleAtFixedRate(runnable, delay, period, TimeUnit.SECONDS);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long delay, long period, TimeUnit timeUnit) {
        return this.pool.scheduleAtFixedRate(this.encapsulateRunnable(runnable), delay, period, timeUnit);
    }

    public ScheduledFuture<?> repeatUntilComplete(Callable<Boolean> task, long period) {
        return this.repeatUntilComplete(task, period, TimeUnit.MILLISECONDS);
    }

    public ScheduledThreadPoolExecutor getPool() {
        return this.pool;
    }

    public ScheduledFuture<?> repeatUntilComplete(Callable<Boolean> task, long period, TimeUnit timeUnit) {
        return this.schedule(() -> {
            try {
                if (!((Boolean)task.call()).booleanValue()) {
                    this.repeatUntilComplete(task, period, timeUnit);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, period, timeUnit);
    }

    private static class Factory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final boolean daemon;

        Factory(String name, boolean daemon) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = name + " Scheduled Thread Pool";
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + " (worker " + this.threadNumber.getAndIncrement() + ")", 0L);
            t.setDaemon(this.daemon);
            t.setUncaughtExceptionHandler((thread, throwable) -> {
                AtlantisLogger.error("An internal error has occurred in Atlantis! Please inform your server administrator of this!", new Object[0]);
                throwable.printStackTrace();
            });
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

