/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.ui.internal;

import com.google.common.collect.Lists;
import de.waterdu.atlantis.ui.api.Button;
import de.waterdu.atlantis.ui.api.PageOptions;
import de.waterdu.atlantis.util.entity.PlayerReference;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.NonNullList;

public class Buttons {
    private static final Button EMPTY_BUTTON = Button.emptyButton();
    private final int pages;
    private int currentPage;
    private final List<Button[]> interfaceButtons = Lists.newArrayList();
    private final List<Button[]> playerInventory = Lists.newArrayList();

    public Buttons(Map<Integer, PageOptions> options, int size, int pages, ServerPlayerEntity player) {
        this.pages = pages;
        this.currentPage = 0;
        for (int page = 0; page < pages; ++page) {
            int i;
            this.interfaceButtons.add(new Button[size]);
            for (i = 0; i < size; ++i) {
                this.interfaceButtons.get((int)page)[i] = Button.emptyButton(i);
            }
            this.playerInventory.add(new Button[36]);
            i = 0;
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                int trueIndex = i < 9 ? i + 27 : i - 9;
                this.playerInventory.get((int)page)[trueIndex] = options.get(page).isInventoryHidden() || stack.func_190926_b() ? Button.emptyButton(trueIndex) : Button.builder().setItem(stack.func_77946_l()).setIndex(trueIndex).setStackOverride(true).build();
                ++i;
            }
        }
    }

    public int getPages() {
        return this.pages;
    }

    public Button[] getInterfaceButtons() {
        return this.getInterfaceButtons(0);
    }

    public Button[] getInterfaceButtons(int page) {
        return this.interfaceButtons.get(this.resolvePage(page));
    }

    public void setInterfaceButtons(Button[] buttons) {
        this.setInterfaceButtons(buttons, 0);
    }

    public void setInterfaceButtons(Button[] buttons, int page) {
        this.interfaceButtons.set(this.resolvePage(page), buttons);
    }

    public Button[] getPlayerButtons() {
        return this.getPlayerButtons(0);
    }

    public Button[] getPlayerButtons(int page) {
        return this.playerInventory.get(this.resolvePage(page));
    }

    public void setPlayerButtons(Button[] buttons) {
        this.setPlayerButtons(buttons, 0);
    }

    public void setPlayerButtons(Button[] buttons, int page) {
        this.playerInventory.set(this.resolvePage(page), buttons);
    }

    public void forceInventoryDisplay(int windowId, int page, PlayerReference player) {
        player.entity().ifPresent(entity -> {
            int i = this.size(false);
            for (Button button : this.getPlayerButtons(this.resolvePage(page))) {
                entity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(windowId, i++, button.getDisplay(player)));
            }
        });
    }

    public Button getButton(int index) {
        return this.getButton(index, 0);
    }

    public Button getButton(int index, int page) {
        Button[] interfaceButtons = this.interfaceButtons.get(this.resolvePage(page));
        Button[] playerInventory = this.playerInventory.get(this.resolvePage(page));
        if (this.isWithinBounds(index)) {
            if (index < interfaceButtons.length) {
                return interfaceButtons[index];
            }
            if (index < interfaceButtons.length + playerInventory.length) {
                return playerInventory[index - interfaceButtons.length];
            }
        }
        return EMPTY_BUTTON;
    }

    public void setButton(int index, Button button) {
        this.setButton(index, 0, button);
    }

    public void setButton(int index, int page, Button button) {
        Button[] interfaceButtons = this.interfaceButtons.get(this.resolvePage(page));
        Button[] playerInventory = this.playerInventory.get(this.resolvePage(page));
        if (this.isWithinBounds(index)) {
            if (index < interfaceButtons.length) {
                if (!button.isLowPriority() || interfaceButtons[index].isEmpty()) {
                    interfaceButtons[index] = button;
                }
            } else if (index < interfaceButtons.length + playerInventory.length && (!button.isLowPriority() || playerInventory[index - interfaceButtons.length].isEmpty())) {
                playerInventory[index - interfaceButtons.length] = button;
            }
        }
    }

    public void clearButton(int index) {
        this.clearButton(index, 0);
    }

    public void clearButton(int index, int page) {
        Button[] interfaceButtons = this.interfaceButtons.get(this.resolvePage(page));
        Button[] playerInventory = this.playerInventory.get(this.resolvePage(page));
        if (this.isWithinBounds(index)) {
            if (index < interfaceButtons.length) {
                interfaceButtons[index] = EMPTY_BUTTON;
            } else if (index < interfaceButtons.length + playerInventory.length) {
                playerInventory[index - interfaceButtons.length] = EMPTY_BUTTON;
            }
        }
    }

    public boolean isWithinBounds(int index) {
        return index >= 0 && index < this.size();
    }

    public int size() {
        return this.size(true);
    }

    public int size(boolean all) {
        return this.interfaceButtons.get(0).length + (all ? this.playerInventory.get(0).length : 0);
    }

    public NonNullList<ItemStack> getAsStackList(boolean all) {
        return this.getAsStackList(0, all);
    }

    public NonNullList<ItemStack> getAsStackList(int page, boolean all) {
        NonNullList stacks = NonNullList.func_191197_a((int)this.size(all), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < this.size(all); ++i) {
            Button button = this.getButton(i, this.resolvePage(page));
            if (button.isEmpty() || button.getItem() == null) continue;
            stacks.set(i, (Object)button.getItem());
        }
        return stacks;
    }

    private int resolvePage(int page) {
        return Math.floorMod(page, this.pages);
    }

    protected void setCurrentPage(int page) {
        this.currentPage = page;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }
}

