/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.ui.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.file.AtlantisData;
import de.waterdu.atlantis.meta.PageEvent;
import de.waterdu.atlantis.ui.api.AtlantisUI;
import de.waterdu.atlantis.ui.api.Button;
import de.waterdu.atlantis.ui.api.Decorations;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.ui.api.PageOptions;
import de.waterdu.atlantis.ui.internal.AtlantisContainerInternal;
import de.waterdu.atlantis.ui.internal.Buttons;
import de.waterdu.atlantis.ui.internal.FontUtils;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.placeholder.AtlantisPlaceholderProxy;
import de.waterdu.atlantis.util.text.Text;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.StringUtils;

public class AtlantisInventoryInternal
extends Inventory {
    protected Page page;
    protected PlayerReference reference;
    protected Buttons buttons;
    protected int pageCount = 1;
    protected int currentPage;
    protected Map<Integer, PageOptions> options = Maps.newHashMap();
    protected boolean draggable;
    protected boolean closed = false;
    protected AtlantisContainerInternal container;

    public AtlantisInventoryInternal(Page page, ServerPlayerEntity player, int currentPage, int slots) {
        this(page, player, currentPage, slots, null);
    }

    public AtlantisInventoryInternal(Page page, ServerPlayerEntity player, int currentPage, int slots, Set<Button> buttons) {
        super(slots);
        PageEvent.Decorate event;
        PlayerReference reference = PlayerReference.get(player);
        if (buttons == null) {
            buttons = this.getButtons(page, reference);
        }
        this.currentPage = this.resolvePage(currentPage);
        for (int i = 0; i < this.pageCount; ++i) {
            this.options.put(i, page.getSpecificPageOptions(reference, i));
        }
        this.draggable = this.getOptions().isDraggable();
        Decorations def = AtlantisData.getDecorations(page);
        if (def != null && !Atlantis.EVENT_BUS.post((Event)(event = new PageEvent.Decorate(reference, page, def, def.getButtons())))) {
            buttons.addAll(event.getDecorations());
        }
        this.page = page;
        this.reference = reference;
        this.buttons = new Buttons(this.options, slots, this.pageCount, player);
        for (Button button : buttons) {
            if (button.getPage() == -1) {
                for (int i = 0; i < this.pageCount; ++i) {
                    this.buttons.setButton(button.getIndex(), i, button);
                }
                continue;
            }
            this.buttons.setButton(button.getIndex(), button.getPage(), button);
        }
    }

    public AtlantisInventoryInternal(Page page, ServerPlayerEntity player, Buttons buttons, int currentPage, int slots) {
        super(slots);
        PlayerReference reference = PlayerReference.get(player);
        this.pageCount = buttons.getPages();
        this.currentPage = currentPage;
        for (int i = 0; i < this.pageCount; ++i) {
            this.options.put(i, page.getSpecificPageOptions(reference, i));
        }
        this.draggable = this.getOptions().isDraggable();
        this.buttons = buttons;
        this.page = page;
        this.reference = reference;
    }

    public void setContainer(AtlantisContainerInternal container) {
        this.container = container;
    }

    public Set<Button> getButtons(Page page, PlayerReference player) {
        HashSet buttons = Sets.newHashSet();
        page.addButtons(player, buttons);
        for (Button button : buttons) {
            if (button.getPage() < this.pageCount) continue;
            this.pageCount = button.getPage() + 1;
        }
        return buttons;
    }

    public PageOptions getOptions() {
        return this.options.get(this.currentPage);
    }

    public int getRows() {
        return this.getOptions().getRows();
    }

    public void onUpdate(ServerPlayerEntity player, AtlantisContainerInternal container) {
        Atlantis.THREAD_POOL.submit(() -> {
            long tick = player.func_71121_q().func_82737_E();
            this.buttons.setCurrentPage(this.currentPage);
            this.buttons = this.page.onUpdate(tick, this.reference, this.buttons);
            container.updateDisplay(this.reference, false);
            container.updateDisplayEnqueued(this.reference);
        });
    }

    public int func_70302_i_() {
        PageOptions.FormFactor ff = this.getOptions().getFormFactor();
        return ff.hasRows() ? this.getOptions().getRows() * 9 : ff.getSlots();
    }

    public boolean func_191420_l() {
        if (this.draggable) {
            return super.func_191420_l();
        }
        return false;
    }

    public ItemStack func_70301_a(int index) {
        if (this.draggable) {
            return super.func_70301_a(index);
        }
        Button button = this.buttons.getButton(index, this.currentPage);
        return button == null ? ItemStack.field_190927_a : button.getDisplay(this.reference);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.draggable) {
            return super.func_70298_a(index, count);
        }
        AtlantisUI.open(this.reference, this.page, this.currentPage);
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (this.draggable) {
            return super.func_70304_b(index);
        }
        AtlantisUI.open(this.reference, this.page, this.currentPage);
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.draggable) {
            super.func_70299_a(index, stack);
            return;
        }
        AtlantisUI.open(this.reference, this.page, this.currentPage);
    }

    public int func_70297_j_() {
        if (this.draggable) {
            return super.func_70297_j_();
        }
        return Integer.MAX_VALUE;
    }

    public void func_70296_d() {
        if (this.draggable) {
            super.func_70296_d();
            if (!this.container.enqueueUpdate) {
                this.page.onChanged(this.reference, this, false);
            }
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.draggable) {
            return super.func_70300_a(player);
        }
        return false;
    }

    public void func_174889_b(PlayerEntity player) {
        if (this.draggable) {
            super.func_174889_b(player);
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (this.draggable) {
            this.page.onChanged(this.reference, this, true);
            super.func_174886_c(player);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.draggable;
    }

    public void func_174888_l() {
        if (this.draggable) {
            super.func_174888_l();
        }
    }

    private String getBuffer(String text) {
        int width = FontUtils.getStringWidth(text);
        switch (this.getOptions().getTitleAlignment()) {
            case LEFT: {
                return "";
            }
            case CENTER: {
                return StringUtils.repeat((String)" ", (int)((int)Math.round((double)Math.max(0, FontUtils.SPACES_WIDTH / 2 - width / 2) / (double)FontUtils.SPACE_WIDTH)));
            }
            case RIGHT: {
                return StringUtils.repeat((String)" ", (int)((int)Math.round((double)Math.max(0, FontUtils.SPACES_WIDTH - width) / (double)FontUtils.SPACE_WIDTH)));
            }
        }
        return text;
    }

    public int resolvePage(int page) {
        return Math.floorMod(page, this.pageCount);
    }

    public String getName() {
        return this.getOptions().getTitle().get();
    }

    public IFormattableTextComponent getDisplayName() {
        Text title = this.getOptions().getTitle();
        if (Settings.getSettings().isUsePlaceholdersInPages()) {
            title = AtlantisPlaceholderProxy.replace(this.reference, title);
        }
        IFormattableTextComponent component = title.compile();
        return new StringTextComponent(this.getBuffer(component.getString())).func_230529_a_((ITextComponent)component);
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public PlayerReference getPlayer() {
        return this.reference;
    }

    public void setPlayer(PlayerReference reference) {
        this.reference = reference;
    }

    public Buttons getButtons() {
        return this.buttons;
    }

    public void setButtons(Buttons buttons) {
        this.buttons = buttons;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public Map<Integer, PageOptions> getAllOptions() {
        return this.options;
    }

    public void setAllOptions(Map<Integer, PageOptions> options) {
        this.options = options;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }
}

