/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.ui.internal;

import com.google.common.collect.Lists;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.meta.PageEvent;
import de.waterdu.atlantis.ui.api.AtlantisUI;
import de.waterdu.atlantis.ui.api.Button;
import de.waterdu.atlantis.ui.api.ClickData;
import de.waterdu.atlantis.ui.api.ClickState;
import de.waterdu.atlantis.ui.internal.AtlantisContainer;
import de.waterdu.atlantis.ui.internal.AtlantisInventoryInternal;
import de.waterdu.atlantis.util.concurrency.Concurrency;
import de.waterdu.atlantis.util.entity.PlayerReference;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.NonNullList;
import net.minecraftforge.eventbus.api.Event;

public class AtlantisContainerInternal
extends Container
implements AtlantisContainer {
    protected List<ItemStack> inventoryItemStacks = NonNullList.func_191196_a();
    protected List<Slot> inventorySlots = Lists.newArrayList();
    protected final AtlantisInventoryInternal inventory;
    protected ClickState lastClick = null;
    protected boolean enqueueUpdate = false;
    protected final AtomicInteger updates = new AtomicInteger(0);
    protected int lastPageHash;
    protected boolean changingPage = false;
    protected boolean forceAll = false;

    public AtlantisContainerInternal(AtlantisInventoryInternal inventory, PlayerEntity player) {
        super(inventory.getOptions().getFormFactor().getType(inventory.getOptions()), 1);
        this.lastPageHash = inventory.getOptions().hashCode();
        PlayerInventory playerInventory = player.field_71071_by;
        this.inventory = inventory;
        inventory.setContainer(this);
        inventory.func_174889_b(player);
        if (inventory.getOptions().getFormFactor().hasRows()) {
            int numRows = inventory.func_70302_i_() / 9;
            int i = (numRows - 4) * 18;
            for (int j = 0; j < numRows; ++j) {
                for (int k = 0; k < 9; ++k) {
                    this.func_75146_a(new Slot((IInventory)inventory, k + j * 9, 8 + k * 18, 18 + j * 18));
                }
            }
            for (int l = 0; l < 3; ++l) {
                for (int j1 = 0; j1 < 9; ++j1) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, j1 + l * 9 + 9, 8 + j1 * 18, 103 + l * 18 + i));
                }
            }
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, i1, 8 + i1 * 18, 161 + i));
            }
        } else {
            for (int j = 0; j < this.inventory.func_70302_i_(); ++j) {
                this.func_75146_a(new Slot((IInventory)this.inventory, j, 0, 0));
            }
            for (int l = 0; l < 3; ++l) {
                for (int k = 0; k < 9; ++k) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, k + l * 9 + 9, 8 + k * 18, l * 18 + 51));
                }
            }
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, i1, 8 + i1 * 18, 109));
            }
        }
    }

    protected Slot func_75146_a(Slot slotIn) {
        if (this.inventory.isDraggable()) {
            Slot slot = super.func_75146_a(slotIn);
            this.inventorySlots.add(slot);
            this.inventoryItemStacks.add(ItemStack.field_190927_a);
            return slot;
        }
        slotIn.field_75222_d = this.inventorySlots.size();
        this.inventorySlots.add(slotIn);
        this.inventoryItemStacks.add(ItemStack.field_190927_a);
        this.field_75151_b.add(slotIn);
        return slotIn;
    }

    @Override
    public AtlantisInventoryInternal getAquaUIInventory() {
        return this.inventory;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        if (this.inventory.isDraggable()) {
            ItemStack itemstack = ItemStack.field_190927_a;
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemstack1 = slot.func_75211_c();
                itemstack = itemstack1.func_77946_l();
                if (index < this.inventory.func_70302_i_() ? !this.func_75135_a(itemstack1, this.inventory.func_70302_i_(), this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.inventory.func_70302_i_(), false)) {
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_190926_b()) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
            }
            return itemstack;
        }
        AtlantisUI.open(this.inventory.getPlayer(), this.inventory.getPage(), this.inventory.getButtons());
        return ItemStack.field_190927_a;
    }

    public boolean func_75129_b(PlayerEntity player) {
        return true;
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        ClickState state = new ClickState(ClickState.MouseButton.get(dragType), ClickState.ClickStyle.get(clickTypeIn), this.inventory.getCurrentPage());
        state.tryDoubleClick(this.lastClick);
        this.lastClick = state;
        if (this.inventory.isDraggable()) {
            this.doButtonClick(slot, state);
            return super.func_184996_a(slot, dragType, clickTypeIn, player);
        }
        PlayerInventory inventoryplayer = player.field_71071_by;
        inventoryplayer.func_70437_b(ItemStack.field_190927_a);
        this.resetDisplay();
        this.doButtonClick(slot, state);
        return ItemStack.field_190927_a;
    }

    private void doButtonClick(int slot, ClickState state) {
        Atlantis.THREAD_POOL.submit(() -> {
            Button button = this.inventory.getButtons().getButton(slot, this.inventory.getCurrentPage());
            if (button.getPresses() == Integer.MIN_VALUE || button.getPresses() > 0) {
                if (button.getPresses() > 0) {
                    button.changePresses(-1);
                }
                if (!AtlantisUI.LOCKED.contains(this.inventory.getPlayer().uuid())) {
                    ClickData data = new ClickData(this.inventory.getPlayer(), slot, state);
                    if (!Atlantis.EVENT_BUS.post((Event)new PageEvent.Press(this.inventory.getPlayer(), this.inventory.getPage(), button, data))) {
                        Concurrency.mainThread(() -> this.inventory.getPage().onButtonClick(this.inventory.getPlayer(), slot, state));
                        if (button.getClickAction() != null) {
                            if (button.isAsync()) {
                                Concurrency.offThread(() -> button.getClickAction().ifLeft(action -> action.accept(data)).ifRight(action -> action.accept(this.inventory.page, data)));
                            } else {
                                button.getClickAction().ifLeft(action -> action.accept(data)).ifRight(action -> action.accept(this.inventory.page, data));
                            }
                        }
                    }
                    AtlantisUI.LOCKED.add(this.inventory.getPlayer().uuid());
                }
            }
        });
    }

    protected boolean func_75135_a(ItemStack stack, int start, int end, boolean backwards) {
        if (this.inventory.isDraggable()) {
            return super.func_75135_a(stack, start, end, backwards);
        }
        return false;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        if (this.inventory.isDraggable()) {
            return super.func_94530_a(stack, slotIn);
        }
        return false;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        if (playerIn instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)playerIn;
            PlayerReference reference = PlayerReference.get(player);
            super.func_75134_a(playerIn);
            this.inventory.func_174886_c(playerIn);
            player.func_71120_a((Container)player.field_71069_bz);
            if (this.inventory.isDraggable()) {
                if (!this.inventory.isClosed()) {
                    this.inventory.getPage().afterClose(reference);
                    this.inventory.setClosed(true);
                }
                return;
            }
            if (this.changingPage) {
                this.changingPage = false;
            } else if (!this.inventory.getPage().onClose(reference) || Atlantis.EVENT_BUS.post((Event)new PageEvent.Destruct(reference, this.inventory.getPage()))) {
                AtlantisUI.open((PlayerEntity)player, this.inventory.getPage(), this.inventory.getButtons(), true);
            } else if (!this.inventory.isClosed()) {
                this.inventory.getPage().afterClose(reference);
                this.inventory.setClosed(true);
            }
        }
    }

    public void func_75141_a(int slot, ItemStack stack) {
        if (this.inventory.isDraggable()) {
            super.func_75141_a(slot, stack);
        }
    }

    public boolean func_94531_b(Slot slot) {
        if (this.inventory.isDraggable()) {
            return super.func_94531_b(slot);
        }
        return false;
    }

    public void resetDisplay() {
        this.updateDisplay(true);
    }

    public void updateDisplay(boolean forceAll) {
        this.updateDisplay(this.inventory.getPlayer(), forceAll);
    }

    @Override
    public void updateDisplay(PlayerReference player, boolean forceAll) {
        this.enqueueUpdate = true;
        this.forceAll = this.forceAll || forceAll;
    }

    public void updateDisplayEnqueued(PlayerReference player) {
        ServerPlayerEntity entity = player.entityDirect();
        if (this.inventory.isDraggable()) {
            if (this.updates.getAndIncrement() == 0) {
                for (int i = 0; i < this.inventory.getButtons().size(true); ++i) {
                    Button button = this.inventory.getButtons().getButton(i, this.inventory.getCurrentPage());
                    ItemStack display = button == null || button.isEmpty() ? ItemStack.field_190927_a : button.getDisplay(player);
                    this.inventory.getButtons().setButton(i, this.inventory.getCurrentPage(), button);
                    this.func_75141_a(i, display);
                }
                entity.func_71110_a((Container)this, this.inventory.getButtons().getAsStackList(this.inventory.getCurrentPage(), true));
                this.forceAll = false;
            }
            this.enqueueUpdate = false;
            AtlantisUI.LOCKED.remove(player.uuid());
        } else {
            Atlantis.THREAD_POOL.submit(() -> {
                if (this.enqueueUpdate) {
                    int pageHash = this.inventory.getOptions().hashCode();
                    if (this.lastPageHash == pageHash) {
                        for (int i = 0; i < this.inventory.getButtons().size(true); ++i) {
                            Button button = this.inventory.getButtons().getButton(i, this.inventory.getCurrentPage());
                            if (!this.forceAll && (button == null || !button.isChanged())) continue;
                            ItemStack display = button == null || button.isEmpty() ? ItemStack.field_190927_a : button.getDisplay(player);
                            this.inventory.getButtons().setButton(i, this.inventory.getCurrentPage(), button);
                            if (button != null) {
                                button.markClean();
                                if (button.isEmpty()) {
                                    this.inventory.getButtons().clearButton(i, this.inventory.getCurrentPage());
                                }
                            }
                            if (this.forceAll) continue;
                            entity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, i, display));
                        }
                        if (this.forceAll) {
                            entity.func_71110_a((Container)this, this.inventory.getButtons().getAsStackList(this.inventory.getCurrentPage(), true));
                            this.forceAll = false;
                        }
                    } else {
                        this.changingPage = true;
                        this.lastPageHash = pageHash;
                        AtlantisUI.open(player, this.inventory.getPage(), this.inventory.getCurrentPage());
                    }
                    this.enqueueUpdate = false;
                    AtlantisUI.LOCKED.remove(player.uuid());
                }
            });
        }
    }

    public Slot func_75139_a(int slotId) {
        return this.inventorySlots.get(Math.min(this.inventorySlots.size() - 1, slotId));
    }

    public void func_75142_b() {
        if (this.inventory.isDraggable()) {
            super.func_75142_b();
        }
    }

    public List<ItemStack> getInventoryItemStacks() {
        return this.inventoryItemStacks;
    }

    public void setInventoryItemStacks(List<ItemStack> inventoryItemStacks) {
        this.inventoryItemStacks = inventoryItemStacks;
    }

    public List<Slot> getInventorySlots() {
        return this.inventorySlots;
    }

    public void setInventorySlots(List<Slot> inventorySlots) {
        this.inventorySlots = inventorySlots;
    }
}

