/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.ui.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.waterdu.atlantis.file.typeadapters.NumberListTypeAdapter;
import de.waterdu.atlantis.ui.api.Button;
import de.waterdu.atlantis.ui.api.ClickData;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.ui.api.PageOptions;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.item.ParsedItemStack;
import de.waterdu.atlantis.util.java.CompactJsonArrayList;
import de.waterdu.atlantis.util.java.JsonUtils;
import de.waterdu.atlantis.util.java.NumberUtils;
import de.waterdu.atlantis.util.text.Text;
import de.waterdu.atlantis.util.text.TextUtils;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.item.Items;
import net.minecraft.util.text.ITextComponent;

public class UIDef<P extends Page> {
    private int rows;
    private Text title;
    private List<Data> data;
    private List<List<Integer>> slotRanges;
    private List<ParsedItemStack> items;
    private final Map<String, Action<P>> actions = Maps.newHashMap();
    private static final Set<Action<Page>> DEFAULT_ACTIONS = Sets.newHashSet();

    public static void addDefaultAction(String key, BiConsumer<Page, ClickData> action, boolean sync) {
        DEFAULT_ACTIONS.add(Action.of(key, action, sync));
    }

    public UIDef() {
        this.rows = 3;
        this.title = Text.empty();
        this.data = Lists.newArrayList();
        this.slotRanges = Lists.newArrayList();
        this.items = Lists.newArrayList();
    }

    protected UIDef(int rows, Text title, List<Data> data) {
        this.rows = rows;
        this.title = title;
        this.data = data;
        this.slotRanges = Lists.newArrayList();
        this.items = Lists.newArrayList();
    }

    public static <P extends Page> UIDef<P> of(int rows, Text title, Data ... data) {
        return new UIDef<P>(rows, title, Lists.newArrayList((Object[])data));
    }

    public static <P extends Page> UIDef<P> of(int rows, String title, Data ... data) {
        return new UIDef<P>(rows, Text.of(title), Lists.newArrayList((Object[])data));
    }

    public UIDef<P> withSlotRange(int min, int max) {
        return this.withSlotRange(NumberUtils.arrayOfRange(min, max));
    }

    public UIDef<P> withSlotRange(int ... values) {
        CompactJsonArrayList<Integer> list = new CompactJsonArrayList<Integer>(values.length);
        for (int value : values) {
            list.add(value);
        }
        return this.withSlotRange(list);
    }

    public UIDef<P> withSlotRange(List<Integer> values) {
        this.slotRanges.add(values);
        return this;
    }

    public UIDef<P> withItems(ParsedItemStack ... items) {
        return this.withItems(Lists.newArrayList((Object[])items));
    }

    public UIDef<P> withItems(Collection<ParsedItemStack> items) {
        this.items.addAll(items);
        return this;
    }

    @SafeVarargs
    public final UIDef<P> withActions(Action<P> ... actions) {
        if (this.actions.isEmpty()) {
            for (Action<P> action : actions) {
                this.actions.put(((Action)action).key, action);
            }
            for (Action action : DEFAULT_ACTIONS) {
                this.actions.put(action.key, Action.of(action.key, action.action::accept, action.sync));
            }
        }
        return this;
    }

    public UIDef<P> resetActions() {
        this.actions.clear();
        return this;
    }

    public ITextComponent getTitle(Object ... args) {
        return TextUtils.format(this.title, args).compile();
    }

    public PageOptions.Builder getOptions() {
        return PageOptions.builder().setInventoryHidden(true).setRows(this.rows).setTitle(this.title).setTitleAlignment(PageOptions.TextAlignment.CENTER);
    }

    public Data getDataForOrdinal(int ordinal) {
        return this.data.get(ordinal);
    }

    public Button.Builder getButton(int ordinal, Object ... args) {
        Action action;
        Data data = this.getDataForOrdinal(ordinal);
        Button.Builder builder = Button.builder().setIndex(data.getIndex()).setItem(data.getItem(), 1).setName(data.getName().format(args));
        for (Text lore : data.getLore()) {
            builder.addLoreLine(lore.format(args));
        }
        if (data.hasAction() && (action = (Action)this.actions.getOrDefault(data.getAction(), null)) != null) {
            if (action.sync) {
                builder.sync().setSinglePress();
            }
            builder.setBiClickAction(action.action);
        }
        return builder;
    }

    public int getButtonCount() {
        return this.data.size();
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public Text getTitle() {
        return this.title;
    }

    public void setTitle(Text title) {
        this.title = title;
    }

    public List<Data> getData() {
        return this.data;
    }

    public void setData(List<Data> data) {
        this.data = data;
    }

    public List<List<Integer>> getSlotRanges() {
        return this.slotRanges;
    }

    public void setSlotRanges(List<List<Integer>> slotRanges) {
        this.slotRanges = slotRanges;
    }

    public List<Integer> getSlotRange(int index) {
        if (index < 0 || index >= this.slotRanges.size()) {
            return Lists.newArrayList();
        }
        return this.slotRanges.get(index);
    }

    public List<ParsedItemStack> getItems() {
        return this.items;
    }

    public void setItems(List<ParsedItemStack> items) {
        this.items = items;
    }

    public ParsedItemStack getItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ParsedItemStack.empty();
        }
        return this.items.get(index);
    }

    public Page makeSimplePage(final Object ... args) {
        return new Page(){

            @Override
            public PageOptions getPageOptions(PlayerReference player) {
                return UIDef.this.getOptions().setTitle(UIDef.this.getTitle().copy().format(args)).build();
            }

            @Override
            public void addButtons(PlayerReference player, Set<Button> buttons) {
                for (int i = 0; i < UIDef.this.getButtonCount(); ++i) {
                    buttons.add(UIDef.this.getButton(i, args).build());
                }
            }
        };
    }

    public void openSimplePage(Object playerLike, Object ... args) {
        PlayerReference.getSafely(playerLike).ifPresent(reference -> reference.open(this.makeSimplePage(args)));
    }

    static {
        UIDef.addDefaultAction("prev", (page, clickData) -> clickData.prevPage(), false);
        UIDef.addDefaultAction("next", (page, clickData) -> clickData.nextPage(), false);
        UIDef.addDefaultAction("close", (page, clickData) -> clickData.closePage(), false);
    }

    public static class Data {
        private int index;
        private int page;
        private String action;
        private ParsedItemStack item;
        private Text name;
        private Text[] lore;

        public Data() {
        }

        protected Data(int index, int page, String action, ParsedItemStack item, Text name, Text ... lore) {
            this.index = index;
            this.page = page;
            this.action = action;
            this.item = item;
            this.name = name;
            this.lore = lore;
        }

        public static Data of(int index, int page, String action, ParsedItemStack item, Text name, Text ... lore) {
            return new Data(index, page, action, item, name, lore);
        }

        public static Data of(int index, int page, String action, String item, String name, String ... lore) {
            return new Data(index, page, action, ParsedItemStack.of(item), Text.of(name), TextUtils.toArray(lore));
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getPage() {
            return this.page;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public boolean hasAction() {
            return !this.action.isEmpty();
        }

        public ParsedItemStack getItem() {
            return this.item;
        }

        public void setItem(ParsedItemStack item) {
            this.item = item;
        }

        public Text getName() {
            return this.name;
        }

        public void setName(Text name) {
            this.name = name;
        }

        public Text[] getLore() {
            return this.lore;
        }

        public void setLore(Text[] lore) {
            this.lore = lore;
        }

        public static class TypeAdapter
        implements JsonSerializer<Data>,
        JsonDeserializer<Data> {
            public Data deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                int index = JsonUtils.getOrDefault(object, "index", Integer.TYPE, Integer.valueOf(0), context);
                int page = JsonUtils.getOrDefault(object, "page", Integer.TYPE, Integer.valueOf(-1), context);
                String action = JsonUtils.getOrDefault(object, "action", String.class, "", context);
                ParsedItemStack item = JsonUtils.getOrDefault(object, "item", ParsedItemStack.class, ParsedItemStack.of(Items.field_190931_a), context);
                Text name = JsonUtils.getOrDefault(object, "name", Text.class, Text.empty(), context);
                List<Object> lore = object.has("lore") ? JsonUtils.deserializeList(object.getAsJsonArray("lore"), e -> (Text)context.deserialize(e, Text.class)) : Lists.newArrayList();
                return Data.of(index, page, action, item, name, lore.toArray(new Text[0]));
            }

            public JsonElement serialize(Data src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject object = new JsonObject();
                object.addProperty("index", (Number)src.getIndex());
                object.addProperty("page", (Number)src.getPage());
                object.addProperty("action", src.getAction());
                object.add("item", context.serialize((Object)src.getItem()));
                object.add("name", context.serialize((Object)src.getName()));
                JsonArray lore = new JsonArray();
                for (Text line : src.getLore()) {
                    lore.add(context.serialize((Object)line));
                }
                object.add("lore", (JsonElement)lore);
                return object;
            }
        }
    }

    public static class TypeAdapter
    implements JsonSerializer<UIDef<? extends Page>>,
    JsonDeserializer<UIDef<? extends Page>> {
        public UIDef<? extends Page> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            int rows = object.getAsJsonPrimitive("rows").getAsInt();
            Text title = (Text)context.deserialize(object.get("title"), Text.class);
            JsonArray data = object.getAsJsonArray("data");
            Data[] dataArray = new Data[data.size()];
            int i = 0;
            for (JsonElement e2 : data) {
                dataArray[i++] = (Data)context.deserialize(e2, Data.class);
            }
            UIDef def = UIDef.of(rows, title, dataArray);
            if (object.has("lists")) {
                List<List> lists = JsonUtils.deserializeList(object.getAsJsonArray("lists"), e -> (List)context.deserialize(e, NumberListTypeAdapter.INTEGER.getType()));
                for (List list : lists) {
                    def.withSlotRange(new CompactJsonArrayList<Integer>(list));
                }
            }
            return def;
        }

        public JsonElement serialize(UIDef<? extends Page> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("rows", (Number)src.getRows());
            object.add("title", context.serialize((Object)src.getTitle()));
            JsonArray array = new JsonArray();
            for (Data data : src.getData()) {
                array.add(context.serialize((Object)data));
            }
            object.add("data", (JsonElement)array);
            object.add("lists", (JsonElement)JsonUtils.serializeList(src.getSlotRanges(), list -> context.serialize(list, NumberListTypeAdapter.INTEGER.getType())));
            return object;
        }
    }

    public static class Action<P extends Page> {
        private final String key;
        private final BiConsumer<P, ClickData> action;
        private final boolean sync;

        private Action(String key, BiConsumer<P, ClickData> action, boolean sync) {
            this.key = key;
            this.action = action;
            this.sync = sync;
        }

        public static <P extends Page> Action<P> of(String key, BiConsumer<P, ClickData> action) {
            return Action.of(key, action, false);
        }

        public static <P extends Page> Action<P> of(String key, BiConsumer<P, ClickData> action, boolean sync) {
            return new Action<P>(key, action, sync);
        }
    }
}

