/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.ui.api;

import de.waterdu.atlantis.util.text.Text;
import de.waterdu.atlantis.util.text.TextUtils;
import java.util.function.Function;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class PageOptions {
    private static final PageOptions DEFAULTS = new PageOptions();
    private FormFactor formFactor = FormFactor.CHEST;
    private Text title = Text.empty();
    private int rows = 3;
    private boolean draggable = false;
    private TextAlignment titleAlignment = TextAlignment.LEFT;
    private long refreshRate = 1L;
    private boolean inventoryHidden = false;
    private transient int hashCode = -1;

    public FormFactor getFormFactor() {
        return this.formFactor;
    }

    public int getRows() {
        return this.rows;
    }

    public Text getTitle() {
        return this.title;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public TextAlignment getTitleAlignment() {
        return this.titleAlignment;
    }

    public long getRefreshRate() {
        return this.refreshRate;
    }

    public boolean isInventoryHidden() {
        return this.inventoryHidden && !this.draggable;
    }

    public static PageOptions defaults() {
        return DEFAULTS;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = Long.hashCode(Long.parseLong(this.rows + "" + this.title.get().length() + this.formFactor.slots + "" + (this.draggable ? "1" : "0") + "" + this.titleAlignment.ordinal() + "" + this.refreshRate + "" + (this.inventoryHidden ? "1" : "0")) + (long)this.title.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageOptions)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static class FormFactor {
        public static FormFactor CHEST;
        public static FormFactor FURNACE;
        public static FormFactor ENCHANTING_TABLE;
        public static FormFactor VILLAGER_TRADE;
        public static FormFactor ANVIL;
        public static FormFactor CRAFTING_TABLE;
        public static FormFactor DISPENSER;
        public static FormFactor BREWING_STAND;
        public static FormFactor HOPPER;
        public static FormFactor BEACON;
        public static FormFactor BLAST_FURNACE;
        public static FormFactor GRINDSTONE;
        public static FormFactor LECTERN;
        public static FormFactor LOOM;
        public static FormFactor SHULKER_BOX;
        public static FormFactor SMITHING_TABLE;
        public static FormFactor SMOKER;
        public static FormFactor CARTOGRAPHY_TABLE;
        public static FormFactor STONECUTTER;
        public static FormFactor COOKING_POT;
        public static FormFactor INFUSER;
        public static FormFactor WASHING_MACHINE;
        public static FormFactor POKE_BAG;
        public static FormFactor DAY_CARE;
        private final int slots;
        private final boolean hasRows;
        private final Function<PageOptions, ContainerType<? extends Container>> containerTypeFunction;

        FormFactor(int slots, boolean hasRows, Function<PageOptions, ContainerType<? extends Container>> containerTypeFunction) {
            this.slots = slots;
            this.hasRows = hasRows;
            this.containerTypeFunction = containerTypeFunction;
        }

        public static FormFactor create(int slots, boolean hasRows, Function<PageOptions, ContainerType<? extends Container>> containerTypeFunction) {
            return new FormFactor(slots, hasRows, containerTypeFunction);
        }

        public static void createDefaults() {
            CHEST = FormFactor.create(54, true, options -> {
                switch (((PageOptions)options).rows) {
                    case 1: {
                        return ContainerType.field_221507_a;
                    }
                    case 2: {
                        return ContainerType.field_221508_b;
                    }
                    case 4: {
                        return ContainerType.field_221510_d;
                    }
                    case 5: {
                        return ContainerType.field_221511_e;
                    }
                    case 6: {
                        return ContainerType.field_221512_f;
                    }
                }
                return ContainerType.field_221509_c;
            });
            FURNACE = FormFactor.create(3, false, options -> ContainerType.field_221520_n);
            ENCHANTING_TABLE = FormFactor.create(2, false, options -> ContainerType.field_221519_m);
            VILLAGER_TRADE = FormFactor.create(3, false, options -> ContainerType.field_221525_s);
            ANVIL = FormFactor.create(3, false, options -> ContainerType.field_221514_h);
            CRAFTING_TABLE = FormFactor.create(10, false, options -> ContainerType.field_221518_l);
            DISPENSER = FormFactor.create(9, false, options -> ContainerType.field_221513_g);
            BREWING_STAND = FormFactor.create(5, false, options -> ContainerType.field_221517_k);
            HOPPER = FormFactor.create(5, false, options -> ContainerType.field_221522_p);
            BEACON = FormFactor.create(1, false, options -> ContainerType.field_221515_i);
            BLAST_FURNACE = FormFactor.create(3, false, options -> ContainerType.field_221516_j);
            GRINDSTONE = FormFactor.create(3, false, options -> ContainerType.field_221521_o);
            LECTERN = FormFactor.create(0, false, options -> ContainerType.field_221523_q);
            LOOM = FormFactor.create(4, false, options -> ContainerType.field_221524_r);
            SHULKER_BOX = FormFactor.create(27, false, options -> ContainerType.field_221526_t);
            SMITHING_TABLE = FormFactor.create(3, false, options -> ContainerType.field_234650_u_);
            SMOKER = FormFactor.create(3, false, options -> ContainerType.field_221527_u);
            CARTOGRAPHY_TABLE = FormFactor.create(3, false, options -> ContainerType.field_226625_v_);
            STONECUTTER = FormFactor.create(2, false, options -> ContainerType.field_221529_w);
            COOKING_POT = FormFactor.create(11, false, options -> (ContainerType)ForgeRegistries.CONTAINERS.getValue(new ResourceLocation("pixelmon:cooking_pot")));
            INFUSER = FormFactor.create(4, false, options -> (ContainerType)ForgeRegistries.CONTAINERS.getValue(new ResourceLocation("pixelmon:infuser")));
            WASHING_MACHINE = FormFactor.create(2, false, options -> (ContainerType)ForgeRegistries.CONTAINERS.getValue(new ResourceLocation("pixelmon:washing_machine")));
            POKE_BAG = FormFactor.create(27, false, options -> (ContainerType)ForgeRegistries.CONTAINERS.getValue(new ResourceLocation("pixelmon:poke_bag")));
            DAY_CARE = FormFactor.create(0, false, options -> (ContainerType)ForgeRegistries.CONTAINERS.getValue(new ResourceLocation("pixelmon:day_care")));
        }

        public ContainerType<? extends Container> getType(PageOptions options) {
            return this.containerTypeFunction.apply(options);
        }

        public boolean hasRows() {
            return this.hasRows;
        }

        public int getSlots() {
            return this.slots;
        }
    }

    public static class Builder {
        private final PageOptions options = new PageOptions();

        public Builder setFormFactor(FormFactor formFactor) {
            this.options.formFactor = formFactor;
            return this;
        }

        public Builder setRows(int rows) {
            this.options.rows = rows;
            return this;
        }

        public <T> Builder setTitle(T title) {
            this.options.title = TextUtils.asText(title);
            return this;
        }

        public Builder setDraggable(boolean draggable) {
            this.options.draggable = draggable;
            return this;
        }

        public Builder setTitleAlignment(TextAlignment alignment) {
            this.options.titleAlignment = alignment;
            return this;
        }

        public Builder setRefreshRate(long rate) {
            this.options.refreshRate = rate;
            return this;
        }

        public Builder setInventoryHidden(boolean hidden) {
            this.options.inventoryHidden = hidden;
            return this;
        }

        public PageOptions build() {
            return this.options;
        }
    }
}

