/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.ui.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.file.auto.AtlantisConfig;
import de.waterdu.atlantis.file.datatypes.NamedData;
import de.waterdu.atlantis.ui.api.Button;
import de.waterdu.atlantis.ui.api.Decoration;
import de.waterdu.atlantis.ui.api.Page;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;

@AtlantisConfig(modID="atlantis", path="ui")
public class Decorations
implements NamedData {
    private String classpath;
    private boolean nbt = false;
    private Map<Integer, String> decorations;
    private transient Set<Button> createdDecorations = null;
    private transient Class<? extends Page> clazz = null;
    private final transient UUID uuid = UUID.randomUUID();

    public Decorations() {
    }

    public Decorations(String classpath) {
        this(classpath, Maps.newHashMap());
    }

    public Decorations(String classpath, Map<Integer, String> decorations) {
        this.classpath = classpath;
        this.decorations = decorations;
    }

    public void setChanged() {
        this.createdDecorations = null;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public Map<Integer, String> getDecorations() {
        return this.decorations;
    }

    public boolean isNbt() {
        return this.nbt;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setDecorations(Map<Integer, String> decorations) {
        this.decorations = decorations;
    }

    public void setNbt(boolean nbt) {
        this.nbt = nbt;
    }

    public Class<? extends Page> getClassDef() {
        if (this.clazz == null) {
            try {
                this.clazz = Class.forName(this.classpath);
            }
            catch (Exception e) {
                AtlantisLogger.error("Failed to read UIDef for classpath " + this.classpath, new Object[0]);
                e.printStackTrace();
            }
        }
        return this.clazz;
    }

    public Set<Button> getButtons() {
        if (this.createdDecorations == null) {
            this.createdDecorations = Sets.newHashSet();
            for (Map.Entry<Integer, String> decoration : this.decorations.entrySet()) {
                if (this.nbt) {
                    try {
                        String[] split2 = decoration.getValue().split(" ");
                        StringBuilder builder = new StringBuilder();
                        for (int i = 0; i < split2.length; ++i) {
                            if (builder.length() > 0) {
                                builder.append(" ");
                            }
                            builder.append(split2[i]);
                        }
                        CompoundNBT nbt = JsonToNBT.func_180713_a((String)builder.toString());
                        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt);
                        this.createdDecorations.add(Button.builder().setItem(stack).setIndex(decoration.getKey()).setStackOverride(true).build());
                    }
                    catch (Exception e) {
                        AtlantisLogger.error("Failed to read decoration in UI def file! " + this.classpath + " - " + decoration, new Object[0]);
                        e.printStackTrace();
                    }
                    continue;
                }
                this.createdDecorations.add(Decoration.from(decoration));
            }
        }
        return this.createdDecorations;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
    }

    @Override
    public String getUniqueName() {
        return this.classpath;
    }

    @Override
    public String getName() {
        return this.classpath;
    }

    @Override
    public void setName(String name) {
        this.classpath = name;
    }

    public int hashCode() {
        return this.defaultHashCode();
    }

    public boolean equals(Object obj) {
        return this.defaultEquals(obj);
    }

    public String toString() {
        return "Decorations(" + this.classpath + ")";
    }
}

