/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.ui.api;

import com.google.common.collect.Lists;
import de.waterdu.atlantis.ui.api.Button;
import de.waterdu.atlantis.util.item.ParsedItemStack;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class Decoration
extends Button {
    public Decoration(ItemStack item, int index) {
        super(item, index);
        this.setStackOverride(false);
        this.setLowPriority(true);
    }

    public Decoration(Block block, int index) {
        super(new ItemStack((IItemProvider)block), index);
        this.setStackOverride(false);
        this.setLowPriority(true);
    }

    public Decoration(Item item, int index) {
        super(new ItemStack((IItemProvider)item), index);
        this.setStackOverride(false);
        this.setLowPriority(true);
    }

    private Decoration(String decoration) {
        this.setStackOverride(false);
        this.setFlags(null);
        this.setHasEffect(false);
        this.setName("");
        this.setLore(Lists.newArrayList());
        this.setEmpty(false);
        String[] split2 = decoration.split(" ");
        if (split2.length == 2) {
            this.setItem(ParsedItemStack.of(split2[0]).stack());
            this.setIndex(Integer.parseInt(split2[1]));
        }
        this.setLowPriority(true);
    }

    private Decoration(Map.Entry<Integer, String> decoration) {
        this.setStackOverride(false);
        this.setFlags(null);
        this.setHasEffect(false);
        this.setName("");
        this.setLore(Lists.newArrayList());
        this.setEmpty(false);
        this.setItem(ParsedItemStack.of(decoration.getValue()).stack());
        this.setIndex(decoration.getKey());
        this.setLowPriority(true);
    }

    public static Decoration from(String decoration) {
        return new Decoration(decoration);
    }

    public static Decoration from(Map.Entry<Integer, String> decoration) {
        return new Decoration(decoration);
    }
}

