/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.ui.api;

import de.waterdu.atlantis.Settings;
import net.minecraft.inventory.container.ClickType;

public class ClickState {
    private final MouseButton button;
    private final ClickStyle style;
    private ClickRate rate = ClickRate.SINGLE;
    private final int page;
    private final long time = System.currentTimeMillis();

    public ClickState(MouseButton button, ClickStyle style, int page) {
        this.button = button;
        this.style = style;
        this.page = page;
    }

    public boolean isSameButton(ClickState state) {
        return state != null && this.button == state.button && this.style == state.style && this.rate == state.rate;
    }

    public void tryDoubleClick(ClickState previous) {
        if (this.isSameButton(previous) && this.time - previous.time <= Settings.getSettings().getDoubleClickDelay()) {
            this.rate = ClickRate.DOUBLE;
        }
    }

    public MouseButton getButton() {
        return this.button;
    }

    public ClickStyle getStyle() {
        return this.style;
    }

    public ClickRate getRate() {
        return this.rate;
    }

    public int getPage() {
        return this.page;
    }

    public static enum ClickRate {
        SINGLE,
        DOUBLE;

    }

    public static enum ClickStyle {
        NORMAL,
        SHIFT,
        DRAG,
        UNKNOWN;


        public static ClickStyle get(ClickType type) {
            if (type == ClickType.CLONE || type == ClickType.PICKUP) {
                return NORMAL;
            }
            if (type == ClickType.QUICK_MOVE) {
                return SHIFT;
            }
            if (type == ClickType.QUICK_CRAFT) {
                return DRAG;
            }
            return UNKNOWN;
        }
    }

    public static enum MouseButton {
        LEFT,
        RIGHT,
        MIDDLE,
        UNKNOWN;


        public static MouseButton get(int button) {
            if (button >= 0 && button <= 2) {
                return MouseButton.values()[button];
            }
            return UNKNOWN;
        }
    }
}

