/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.ui.api;

import de.waterdu.atlantis.ui.api.AtlantisUI;
import de.waterdu.atlantis.ui.api.ClickState;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.util.entity.PlayerReference;
import net.minecraft.entity.player.ServerPlayerEntity;

public class ClickData {
    private final PlayerReference player;
    private final int index;
    private final ClickState clickState;

    public ClickData(PlayerReference player, int index, ClickState clickState) {
        this.player = player;
        this.index = index;
        this.clickState = clickState;
    }

    public void openPage(Page page) {
        this.openPage(page, false);
    }

    public void openPage(Page page, boolean waitForScreen) {
        this.openPage(page, waitForScreen, 0);
    }

    public void openPage(Page page, int currentPage) {
        this.openPage(page, false, currentPage);
    }

    public void openPage(Page page, boolean waitForScreen, int currentPage) {
        AtlantisUI.open(this.player, page, waitForScreen, currentPage);
    }

    public void closePage() {
        AtlantisUI.close(this.player);
    }

    public void nextPage() {
        this.nextPage(true);
    }

    public void nextPage(boolean looped) {
        AtlantisUI.nextPage(this.player, looped);
    }

    public void prevPage() {
        this.prevPage(true);
    }

    public void prevPage(boolean looped) {
        AtlantisUI.prevPage(this.player, looped);
    }

    public void setPage(int page) {
        AtlantisUI.setPage(this.player, page);
    }

    public void changePage(int change) {
        this.changePage(change, true);
    }

    public void changePage(int change, boolean looped) {
        AtlantisUI.changePage(this.player, change, looped);
    }

    public void setProperty(int property, int value) {
        AtlantisUI.setProperty(this.player, property, value);
    }

    public PlayerReference getPlayer() {
        return this.player;
    }

    public ServerPlayerEntity getEntity() {
        return this.player.entityDirect();
    }

    public int getIndex() {
        return this.index;
    }

    public ClickState getClickState() {
        return this.clickState;
    }

    public boolean matches(int index) {
        return this.index == index;
    }

    public boolean matches(int index, ClickState.MouseButton button) {
        return this.matches(index) && this.clickState.getButton() == button;
    }

    public boolean matches(int index, ClickState.MouseButton button, ClickState.ClickStyle style) {
        return this.matches(index, button) && this.clickState.getStyle() == style;
    }
}

