/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.ui.api;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.ui.api.ClickData;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.item.ItemUtils;
import de.waterdu.atlantis.util.item.ParsedItemStack;
import de.waterdu.atlantis.util.text.Text;
import de.waterdu.atlantis.util.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class Button {
    private Text name;
    private List<Text> lore;
    private ItemStack item;
    private Integer flags;
    private boolean stackOverride;
    private boolean hasEffect;
    private int index;
    private int page = -1;
    private int presses = Integer.MIN_VALUE;
    private Either<Consumer<ClickData>, BiConsumer<Page, ClickData>> clickAction = null;
    private boolean async = true;
    private boolean changed = true;
    private boolean empty = false;
    private boolean lowPriority = false;

    protected Button(Text name, List<Text> lore, ItemStack item, int index) {
        this(name, lore, item, index, 127, false);
    }

    protected Button(String name, String lore, ItemStack item, int index) {
        this.name = Text.of(name);
        this.lore = Lists.newArrayList();
        if (lore != null) {
            for (String line : lore.split("\\n")) {
                this.lore.add(Text.of(line));
            }
        }
        this.item = item;
        this.index = index;
        this.stackOverride = false;
        this.flags = 127;
        this.hasEffect = false;
    }

    protected Button(Text name, List<Text> lore, ItemStack item, int index, boolean hasEffect) {
        this(name, lore, item, index, 127, hasEffect);
    }

    protected Button(Text name, List<Text> lore, ItemStack item, int index, Integer flags) {
        this(name, lore, item, index, flags, false);
    }

    protected Button(Text name, List<Text> lore, ItemStack item, int index, Integer flags, boolean hasEffect) {
        this.name = name;
        this.lore = lore;
        this.item = item;
        this.index = index;
        this.stackOverride = false;
        this.flags = flags;
        this.hasEffect = hasEffect;
    }

    protected Button(ItemStack item, int index) {
        this.name = Text.empty();
        this.lore = Lists.newArrayList();
        this.item = item;
        this.index = index;
        this.stackOverride = true;
        this.flags = null;
        this.hasEffect = false;
    }

    protected Button() {
        this.name = Text.empty();
        this.lore = Lists.newArrayList();
        this.index = 0;
        this.stackOverride = false;
        this.flags = null;
        this.hasEffect = false;
        this.empty = true;
    }

    public ItemStack getDisplay(PlayerReference player) {
        if (this.item == null) {
            return ItemStack.field_190927_a;
        }
        if (this.stackOverride) {
            return this.item;
        }
        boolean placeholders = Settings.getSettings().isUsePlaceholdersInPages();
        if (placeholders) {
            ItemUtils.setDisplayNameWithPlaceholders((PlayerEntity)player.entityDirect(), this.item, this.name);
        } else {
            ItemUtils.setDisplayName(this.item, this.name);
        }
        if (!this.lore.isEmpty()) {
            if (placeholders) {
                ItemUtils.setDisplayLoreWithPlaceholders((PlayerEntity)player.entityDirect(), this.item, this.lore);
            } else {
                ItemUtils.setDisplayLore(this.item, this.lore);
            }
        }
        ItemUtils.setPixelmonTooltip(this.item, "");
        if (this.hasEffect) {
            ItemUtils.setEffect(this.item, true);
            ItemUtils.addDummyEnchantment(this.item);
        }
        if (this.flags != null) {
            ItemUtils.addFlags(this.item, this.flags);
        }
        return this.item;
    }

    public int getIndex() {
        return this.index;
    }

    public void markDirty() {
        this.changed = true;
    }

    public void setIndex(int index) {
        this.index = index;
        this.markDirty();
    }

    public void setPage(int page) {
        this.page = page;
        this.markDirty();
    }

    public void setPresses(int presses) {
        this.presses = presses;
        this.markDirty();
    }

    public <T> void setName(T name) {
        this.name = TextUtils.asText(name);
        this.markDirty();
    }

    public void setFlags(Integer flags) {
        this.flags = flags;
        this.markDirty();
    }

    public <T> void setLore(List<T> lore) {
        ArrayList components = Lists.newArrayList();
        for (T line : lore) {
            components.add(TextUtils.asText(line));
        }
        this.lore = components;
        this.markDirty();
    }

    public void setHasEffect(boolean hasEffect) {
        this.hasEffect = hasEffect;
        this.markDirty();
    }

    public void setItem(ItemStack item) {
        this.item = item;
        this.markDirty();
    }

    public void setStackOverride(boolean stackOverride) {
        this.stackOverride = stackOverride;
        this.markDirty();
    }

    public void setClickAction(Consumer<ClickData> clickAction) {
        this.clickAction = Either.left(clickAction);
        this.markDirty();
    }

    public void setClickAction(BiConsumer<Page, ClickData> clickAction) {
        this.clickAction = Either.right(clickAction);
        this.markDirty();
    }

    public void sync() {
        this.async = false;
    }

    public void async() {
        this.async = true;
    }

    public void clearClickAction() {
        this.clickAction = null;
        this.markDirty();
    }

    public void markClean() {
        this.changed = false;
    }

    public void setLowPriority() {
        this.lowPriority = true;
    }

    public void setStandardPriority() {
        this.lowPriority = false;
    }

    public Text getName() {
        return this.name;
    }

    public List<Text> getLore() {
        return this.lore;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public boolean isStackOverride() {
        return this.stackOverride;
    }

    public boolean isHasEffect() {
        return this.hasEffect;
    }

    public int getPage() {
        return this.page;
    }

    public int getPresses() {
        return this.presses;
    }

    public void changePresses(int presses) {
        this.presses += presses;
    }

    public Either<Consumer<ClickData>, BiConsumer<Page, ClickData>> getClickAction() {
        return this.clickAction;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public boolean isLowPriority() {
        return this.lowPriority;
    }

    public void setLowPriority(boolean lowPriority) {
        this.lowPriority = lowPriority;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder of(Object name, Object item, int index) {
        Builder builder = Button.builder().setName(name).setIndex(index);
        if (item instanceof Item) {
            builder.setItem((Item)item);
        } else if (item instanceof ItemStack) {
            builder.setItem((ItemStack)item);
        } else if (item instanceof Block) {
            builder.setItem((Block)item);
        } else if (item instanceof ParsedItemStack) {
            builder.setItem((ParsedItemStack)item);
        } else {
            builder.setItem(String.valueOf(item));
        }
        return builder;
    }

    public static Builder of(Object name, Object lore, Object item, int index) {
        return Button.of(name, item, index).setLore(lore);
    }

    public static Button emptyButton() {
        return new Button();
    }

    public static Button emptyButton(int index) {
        Button button = new Button();
        button.setIndex(index);
        return button;
    }

    public static class Builder {
        private final Button button = new Button();

        public Builder() {
            this.button.empty = false;
            this.button.flags = 127;
        }

        public <T> Builder setName(T name) {
            this.button.name = TextUtils.asText(name);
            return this;
        }

        public <T> Builder setNameRaw(T name) {
            this.button.name = TextUtils.asText(name).raw();
            return this;
        }

        public Builder clearLore() {
            this.button.lore.clear();
            return this;
        }

        public <T> Builder setLore(T lore) {
            this.clearLore();
            if (lore != null) {
                for (String line : TextUtils.asString(lore).split("\\n")) {
                    this.button.lore.add(Text.of(line));
                }
            }
            return this;
        }

        public <T> Builder setLore(List<T> lore) {
            this.clearLore();
            if (lore != null) {
                for (T line : lore) {
                    this.button.lore.add(TextUtils.asText(line));
                }
            }
            return this;
        }

        @SafeVarargs
        public final <T> Builder addLore(T ... lore) {
            if (lore != null) {
                for (T line : lore) {
                    this.button.lore.add(TextUtils.asText(line));
                }
            }
            return this;
        }

        public <T> Builder addLoreLine(T line) {
            this.button.lore.add(TextUtils.asText(line));
            return this;
        }

        public <T> Builder addLoreLineRaw(T line) {
            this.button.lore.add(TextUtils.asText(line).raw());
            return this;
        }

        public Builder setItem(Item item) {
            return this.setItem(item, 1);
        }

        public Builder setItem(Item item, int count) {
            return this.setItem(new ItemStack((IItemProvider)item, count));
        }

        public Builder setItem(Block block) {
            return this.setItem((Item)Item.field_179220_a.get(block));
        }

        public Builder setItem(Block block, int count) {
            return this.setItem((Item)Item.field_179220_a.get(block), count);
        }

        public Builder setItem(String id) {
            return this.setItem((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_195828_a((String)id, (char)':')));
        }

        public Builder setItem(String id, int count) {
            return this.setItem((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_195828_a((String)id, (char)':')), count);
        }

        public Builder setItem(ParsedItemStack item) {
            return this.setItem(item.newStack());
        }

        public Builder setItem(ParsedItemStack item, int count) {
            return this.setItem(item.newStack(count));
        }

        public Builder setItem(ItemStack stack) {
            this.button.item = stack;
            return this;
        }

        public Builder hasStackOverride(boolean stackOverride) {
            this.button.stackOverride = stackOverride;
            return this;
        }

        public Builder hasEffect(boolean hasEffect) {
            this.button.hasEffect = hasEffect;
            return this;
        }

        public Builder setIndex(int index) {
            this.button.index = index;
            return this;
        }

        public Builder setPage(int page) {
            this.button.page = page;
            return this;
        }

        public Builder setPresses(int presses) {
            this.button.presses = presses;
            return this;
        }

        public Builder setSinglePress() {
            return this.setPresses(1);
        }

        public Builder setFlags(int flags) {
            this.button.flags = flags;
            return this;
        }

        public Builder setEffect(boolean hasEffect) {
            this.button.hasEffect = hasEffect;
            return this;
        }

        public Builder setStackOverride(boolean stackOverride) {
            this.button.stackOverride = stackOverride;
            return this;
        }

        public Builder setClickAction(Consumer<ClickData> clickAction) {
            this.button.clickAction = Either.left(clickAction);
            return this;
        }

        public Builder setBiClickAction(BiConsumer<Page, ClickData> clickAction) {
            this.button.clickAction = Either.right(clickAction);
            return this;
        }

        public Builder sync() {
            this.button.sync();
            return this;
        }

        public Builder async() {
            this.button.async();
            return this;
        }

        public Builder lowPriority() {
            this.button.setLowPriority();
            return this;
        }

        public Builder standardPriority() {
            this.button.setStandardPriority();
            return this;
        }

        public Button build() {
            return this.button;
        }
    }
}

