/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.ui.api;

import com.google.common.collect.Lists;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.meta.PageEvent;
import de.waterdu.atlantis.ui.api.Button;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.ui.api.PageOptions;
import de.waterdu.atlantis.ui.internal.AtlantisContainerInternal;
import de.waterdu.atlantis.ui.internal.AtlantisInventoryInternal;
import de.waterdu.atlantis.ui.internal.Buttons;
import de.waterdu.atlantis.ui.internal.InventoryListener;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SOpenWindowPacket;
import net.minecraft.network.play.server.SWindowPropertyPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class AtlantisUI {
    public static final Map<UUID, Page> FUTURE_OPEN = new HashMap<UUID, Page>();
    public static final Set<UUID> LOCKED = new HashSet<UUID>();
    private static final AtomicBoolean REGISTERED = new AtomicBoolean(false);

    private AtlantisUI() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static void register() {
        if (!REGISTERED.getAndSet(true)) {
            MinecraftForge.EVENT_BUS.register((Object)new InventoryListener());
        }
    }

    public static boolean open(PlayerReference player, @Nullable Page page) {
        return AtlantisUI.open(player, page, null);
    }

    public static boolean open(PlayerEntity player, @Nullable Page page) {
        return AtlantisUI.open(player, page, null);
    }

    public static boolean open(PlayerReference player, @Nullable Page page, int currentPage) {
        return AtlantisUI.open(player, page, null, currentPage);
    }

    public static boolean open(PlayerEntity player, @Nullable Page page, int currentPage) {
        return AtlantisUI.open(player, page, null, currentPage);
    }

    public static boolean open(PlayerReference player, @Nullable Page page, @Nullable Buttons buttons) {
        return AtlantisUI.open(player, page, buttons, false);
    }

    public static boolean open(PlayerEntity player, @Nullable Page page, @Nullable Buttons buttons) {
        return AtlantisUI.open(player, page, buttons, false);
    }

    public static boolean open(PlayerReference player, @Nullable Page page, boolean waitForScreen) {
        return AtlantisUI.open(player, page, null, waitForScreen);
    }

    public static boolean open(PlayerEntity player, @Nullable Page page, boolean waitForScreen) {
        return AtlantisUI.open(player, page, null, waitForScreen);
    }

    public static boolean open(PlayerReference player, @Nullable Page page, @Nullable Buttons buttons, int currentPage) {
        return AtlantisUI.open(player, page, buttons, false, currentPage);
    }

    public static boolean open(PlayerEntity player, @Nullable Page page, @Nullable Buttons buttons, int currentPage) {
        return AtlantisUI.open(player, page, buttons, false, currentPage);
    }

    public static boolean open(PlayerReference player, @Nullable Page page, boolean waitForScreen, int currentPage) {
        return AtlantisUI.open(player, page, null, waitForScreen, currentPage);
    }

    public static boolean open(PlayerEntity player, @Nullable Page page, boolean waitForScreen, int currentPage) {
        return AtlantisUI.open(player, page, null, waitForScreen, currentPage);
    }

    public static boolean open(PlayerReference player, @Nullable Page page, @Nullable Buttons buttons, boolean waitForScreen) {
        return AtlantisUI.open(player, page, buttons, waitForScreen, 0);
    }

    public static boolean open(PlayerEntity player, @Nullable Page page, @Nullable Buttons buttons, boolean waitForScreen) {
        return AtlantisUI.open(player, page, buttons, waitForScreen, 0);
    }

    public static boolean open(PlayerReference player, @Nullable Page page, @Nullable Buttons buttons, boolean waitForScreen, int currentPage) {
        return AtlantisUI.open((PlayerEntity)player.entityDirect(), page, buttons, waitForScreen, currentPage);
    }

    public static boolean open(PlayerEntity player, @Nullable Page page, @Nullable Buttons buttons, boolean waitForScreen, int currentPage) {
        boolean result = false;
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            PlayerReference reference = PlayerReference.get(serverPlayer);
            result = true;
            if (waitForScreen) {
                FUTURE_OPEN.put(serverPlayer.func_110124_au(), page);
            } else if (page != null) {
                Atlantis.THREAD_POOL.submit(() -> {
                    PageOptions options = page.getPageOptions(reference);
                    PageOptions.FormFactor ff = options.getFormFactor();
                    int slots = ff.hasRows() ? options.getRows() * 9 : ff.getSlots();
                    AtlantisInventoryInternal i = buttons != null ? new AtlantisInventoryInternal(page, serverPlayer, buttons, currentPage, slots) : new AtlantisInventoryInternal(page, serverPlayer, currentPage, slots);
                    PageEvent.Construct event = new PageEvent.Construct(reference, page, i.getButtons(), options);
                    if (!Atlantis.EVENT_BUS.post((Event)event)) {
                        i.setButtons(event.getButtons());
                        i.setCurrentPage(i.resolvePage(currentPage));
                        AtlantisContainerInternal c = new AtlantisContainerInternal(i, (PlayerEntity)serverPlayer);
                        serverPlayer.field_71070_bA = c;
                        serverPlayer.field_71139_cq = 1;
                        serverPlayer.field_71135_a.func_147359_a((IPacket)new SOpenWindowPacket(serverPlayer.field_71139_cq, ff.getType(options), (ITextComponent)i.getDisplayName()));
                        c.func_75132_a((IContainerListener)serverPlayer);
                        c.func_75142_b();
                        i.func_70296_d();
                        c.updateDisplay(reference, true);
                    }
                    LOCKED.remove(serverPlayer.func_110124_au());
                });
            } else {
                FUTURE_OPEN.put(serverPlayer.func_110124_au(), null);
            }
        }
        return result;
    }

    public static boolean close(PlayerReference player) {
        return AtlantisUI.open(player, null);
    }

    public static boolean close(PlayerEntity player) {
        return AtlantisUI.open(player, null);
    }

    public static boolean nextPage(PlayerReference player) {
        return AtlantisUI.changePage(player, 1, true);
    }

    public static boolean nextPage(PlayerEntity player) {
        return AtlantisUI.changePage(player, 1, true);
    }

    public static boolean prevPage(PlayerReference player) {
        return AtlantisUI.changePage(player, -1, true);
    }

    public static boolean prevPage(PlayerEntity player) {
        return AtlantisUI.changePage(player, -1, true);
    }

    public static boolean nextPage(PlayerReference player, boolean looped) {
        return AtlantisUI.nextPage((PlayerEntity)player.entityDirect(), looped);
    }

    public static boolean nextPage(PlayerEntity player, boolean looped) {
        return AtlantisUI.changePage(player, 1, looped);
    }

    public static boolean prevPage(PlayerReference player, boolean looped) {
        return AtlantisUI.prevPage((PlayerEntity)player.entityDirect(), looped);
    }

    public static boolean prevPage(PlayerEntity player, boolean looped) {
        return AtlantisUI.changePage(player, -1, looped);
    }

    public static boolean changePage(PlayerReference player, int change, boolean looped) {
        return AtlantisUI.changePage((PlayerEntity)player.entityDirect(), change, looped);
    }

    public static boolean changePage(PlayerEntity player, int change, boolean looped) {
        Optional<AtlantisContainerInternal> optional = AtlantisUI.currentContainer(player);
        if (optional.isPresent()) {
            int nextPage;
            AtlantisContainerInternal container = optional.get();
            AtlantisInventoryInternal inventory = container.getAquaUIInventory();
            int n = nextPage = looped ? inventory.resolvePage(inventory.getCurrentPage() + change) : inventory.getCurrentPage() + change;
            if (nextPage >= 0 && nextPage < inventory.getPageCount()) {
                inventory.setCurrentPage(nextPage);
                container.updateDisplay(true);
                return true;
            }
        }
        return false;
    }

    public static boolean setPage(PlayerReference player, int page) {
        return AtlantisUI.setPage((PlayerEntity)player.entityDirect(), page);
    }

    public static boolean setPage(PlayerEntity player, int page) {
        AtlantisContainerInternal container;
        AtlantisInventoryInternal inventory;
        int nextPage;
        Optional<AtlantisContainerInternal> optional = AtlantisUI.currentContainer(player);
        if (optional.isPresent() && (nextPage = (inventory = (container = optional.get()).getAquaUIInventory()).resolvePage(page)) >= 0 && nextPage < inventory.getPageCount()) {
            inventory.setCurrentPage(nextPage);
            container.updateDisplay(true);
            return true;
        }
        return false;
    }

    public static boolean hasNextPage(PlayerReference player) {
        return AtlantisUI.hasNextPage((PlayerEntity)player.entityDirect());
    }

    public static boolean hasNextPage(PlayerEntity player) {
        Optional<AtlantisContainerInternal> optional = AtlantisUI.currentContainer(player);
        if (optional.isPresent()) {
            AtlantisContainerInternal container = optional.get();
            AtlantisInventoryInternal inventory = container.getAquaUIInventory();
            int nextPage = inventory.getCurrentPage() + 1;
            return nextPage < inventory.getPageCount();
        }
        return false;
    }

    public static boolean hasPrevPage(PlayerReference player) {
        return AtlantisUI.hasPrevPage((PlayerEntity)player.entityDirect());
    }

    public static boolean hasPrevPage(PlayerEntity player) {
        Optional<AtlantisContainerInternal> optional = AtlantisUI.currentContainer(player);
        if (optional.isPresent()) {
            AtlantisContainerInternal container = optional.get();
            AtlantisInventoryInternal inventory = container.getAquaUIInventory();
            int nextPage = inventory.getCurrentPage() - 1;
            return nextPage > 0;
        }
        return false;
    }

    public static int currentPage(PlayerReference player) {
        return AtlantisUI.currentPage((PlayerEntity)player.entityDirect());
    }

    public static int currentPage(PlayerEntity player) {
        Optional<AtlantisContainerInternal> optional = AtlantisUI.currentContainer(player);
        if (optional.isPresent()) {
            AtlantisContainerInternal container = optional.get();
            AtlantisInventoryInternal inventory = container.getAquaUIInventory();
            return inventory.getCurrentPage();
        }
        return -1;
    }

    public static Optional<AtlantisContainerInternal> currentContainer(PlayerReference player) {
        return AtlantisUI.currentContainer((PlayerEntity)player.entityDirect());
    }

    public static Optional<AtlantisContainerInternal> currentContainer(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity && player.field_71070_bA instanceof AtlantisContainerInternal) {
            return Optional.of((AtlantisContainerInternal)player.field_71070_bA);
        }
        return Optional.empty();
    }

    public static void setProperty(PlayerReference player, int element, int value) {
        AtlantisUI.setProperty((PlayerEntity)player.entityDirect(), element, value);
    }

    public static void setProperty(PlayerEntity player, int element, int value) {
        if (player instanceof ServerPlayerEntity && player.field_71070_bA instanceof AtlantisContainerInternal) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            serverPlayer.field_71135_a.func_147359_a((IPacket)new SWindowPropertyPacket(serverPlayer.field_71139_cq, element, value));
        }
    }

    public static Page createPage(final PageOptions options, final Button ... buttons) {
        return new Page(){

            @Override
            public PageOptions getPageOptions(PlayerReference player) {
                return options;
            }

            @Override
            public void addButtons(PlayerReference player, Set<Button> buttonsOut) {
                buttonsOut.addAll(Lists.newArrayList((Object[])buttons));
            }
        };
    }
}

