/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.trident.level.implementation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import de.waterdu.atlantis.trident.level.TridentLevel;
import de.waterdu.atlantis.trident.level.implementation.TridentChunkGenerator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class VoidStructureGridChunkGenerator
extends TridentChunkGenerator {
    private final int chunkOffset;
    private final Lazy<Structure<NoFeatureConfig>> structureLazy;

    public VoidStructureGridChunkGenerator(int chunkOffset, String structure) {
        super(new FlatGenerationSettings(TridentLevel.getBiomeRegistry(), new DimensionStructuresSettings(Optional.empty(), (Map)ImmutableMap.of()), (List)Lists.newArrayList(), false, false, Optional.of(() -> (Biome)TridentLevel.getBiomeRegistry().func_230516_a_(Biomes.field_185440_P))));
        this.chunkOffset = chunkOffset;
        this.structureLazy = Lazy.of(() -> (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(new ResourceLocation(structure)));
    }

    @Override
    public void func_242707_a(DynamicRegistries registries, StructureManager structureManager, IChunk chunk, TemplateManager templateManager, long seed) {
        ChunkPos pos = chunk.func_76632_l();
        if (pos.field_77276_a % this.chunkOffset == 0 && pos.field_77275_b % this.chunkOffset == 0) {
            Structure structure = (Structure)this.structureLazy.get();
            StructureStart start = structure.func_214557_a().create(structure, pos.field_77276_a, pos.field_77275_b, MutableBoundingBox.func_78887_a(), 0, seed);
            start.func_230364_a_(registries, (ChunkGenerator)this, templateManager, pos.field_77276_a, pos.field_77275_b, this.func_236073_g_().func_82648_a(), (IFeatureConfig)NoFeatureConfig.field_236559_b_);
        }
    }
}

