/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.trident.level;

import com.google.common.collect.Maps;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.file.auto.AtlantisConfig;
import de.waterdu.atlantis.file.datatypes.Configuration;
import de.waterdu.atlantis.trident.level.TridentLevel;
import de.waterdu.atlantis.trident.level.TridentLevelRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

@AtlantisConfig(modID="atlantis", path="levels.json")
public class TridentLevels
implements Configuration {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private Map<String, TridentLevel> levels = Maps.newHashMap();

    public void addDefaults() {
        if (Settings.getSettings().isCreateDefaultTridentLevel() && this.levels.isEmpty()) {
            this.addLevel(TridentLevel.builder("atlantis", "example").chunkGenerator(TridentLevelRegistry.SUPERFLAT_CHUNK_GENERATOR, new String[0]).dimensionType(TridentLevelRegistry.UNIQUE_OVERWORLD_DIMENSION_TYPE, new String[0]).structureSettings(TridentLevelRegistry.NO_STRUCTURES_STRUCTURE_SETTINGS, new String[0]).build());
        }
    }

    public void addLevel(TridentLevel level) {
        this.levels.put(level.toString(), level);
        if (TridentLevels.isInitialized()) {
            level.loadImmediate();
        }
        this.save();
    }

    public Optional<TridentLevel> getLevel(String id) {
        return Optional.ofNullable(this.levels.get(id));
    }

    public Map<String, TridentLevel> getLevels() {
        return this.levels;
    }

    public void setLevels(Map<String, TridentLevel> worlds) {
        this.levels = worlds;
    }

    public static boolean isInitialized() {
        return INITIALIZED.get();
    }

    public static void setInitialized() {
        INITIALIZED.set(true);
    }

    @Deprecated
    public static TridentLevels getInstance() {
        return Atlantis.CONFIG.get(TridentLevels.class);
    }

    public static TridentLevels instance() {
        return Atlantis.CONFIG.get(TridentLevels.class);
    }
}

