/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.trident.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Lifecycle;
import de.waterdu.atlantis.trident.level.InvalidTridentLevelException;
import de.waterdu.atlantis.trident.level.TridentLevel;
import de.waterdu.atlantis.trident.level.implementation.TridentChunkGenerator;
import de.waterdu.atlantis.trident.level.implementation.VoidStructureGridChunkGenerator;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.level.TridentLevelFunction;
import de.waterdu.atlantis.util.server.ServerUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.ColumnFuzzedBiomeMagnifier;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraftforge.registries.ForgeRegistries;

public class TridentLevelRegistry {
    private static final TridentLevelFunction<ChunkGenerator> NULL_CHUNK_GENERATOR_FUNCTION = (level, args) -> null;
    private static final TridentLevelFunction<DimensionStructuresSettings> NULL_STRUCTURE_SETTINGS_FUNCTION = (level, args) -> null;
    private static final TridentLevelFunction<DimensionType> NULL_DIMENSION_TYPE_FUNCTION = (level, args) -> null;
    private static final DimensionType DEFAULT_DIMENSION_TYPE_IMPL;
    private static final Map<ResourceLocation, TridentLevelFunction<ChunkGenerator>> CHUNK_GENERATORS;
    private static final Map<ResourceLocation, TridentLevelFunction<DimensionStructuresSettings>> STRUCTURE_SETTINGS;
    private static final Map<ResourceLocation, TridentLevelFunction<DimensionType>> DIMENSION_TYPES;
    public static final ResourceLocation SUPERFLAT_CHUNK_GENERATOR;
    public static final ResourceLocation VOID_STRUCTURE_GRID_CHUNK_GENERATOR;
    public static final ResourceLocation NO_STRUCTURES_STRUCTURE_SETTINGS;
    public static final ResourceLocation OVERWORLD_DIMENSION_TYPE;
    public static final ResourceLocation UNIQUE_OVERWORLD_DIMENSION_TYPE;

    public static void bootstrap() {
    }

    private TridentLevelRegistry() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    private static ResourceLocation makeKey(String namespace, String path) {
        return new ResourceLocation(namespace.toLowerCase(Locale.ROOT), path.toLowerCase(Locale.ROOT));
    }

    public static ResourceLocation registerChunkGenerator(String namespace, String path, TridentLevelFunction<ChunkGenerator> chunkGenerator) {
        ResourceLocation key = TridentLevelRegistry.makeKey(namespace, path);
        CHUNK_GENERATORS.put(key, chunkGenerator);
        return key;
    }

    public static Optional<ChunkGenerator> getChunkGenerator(ResourceLocation key, TridentLevel level, String ... args) throws InvalidTridentLevelException {
        try {
            return Optional.ofNullable(CHUNK_GENERATORS.getOrDefault(key, NULL_CHUNK_GENERATOR_FUNCTION).apply(level, args));
        }
        catch (Exception e) {
            throw new InvalidTridentLevelException("ChunkGenerator", key, e);
        }
    }

    public static ResourceLocation registerStructureSettings(String namespace, String path, TridentLevelFunction<DimensionStructuresSettings> structureSettings) {
        ResourceLocation key = TridentLevelRegistry.makeKey(namespace, path);
        STRUCTURE_SETTINGS.put(key, structureSettings);
        return key;
    }

    public static Optional<DimensionStructuresSettings> getStructureSettings(ResourceLocation key, TridentLevel level, String ... args) throws InvalidTridentLevelException {
        try {
            return Optional.ofNullable(STRUCTURE_SETTINGS.getOrDefault(key, NULL_STRUCTURE_SETTINGS_FUNCTION).apply(level, args));
        }
        catch (Exception e) {
            throw new InvalidTridentLevelException("DimensionStructureSettings", key, e);
        }
    }

    public static ResourceLocation registerDimensionType(String namespace, String path, TridentLevelFunction<DimensionType> dimensionType) {
        ResourceLocation key = TridentLevelRegistry.makeKey(namespace, path);
        DIMENSION_TYPES.put(key, dimensionType);
        return key;
    }

    public static Optional<DimensionType> getDimensionType(ResourceLocation key, TridentLevel level, String ... args) throws InvalidTridentLevelException {
        try {
            return Optional.ofNullable(DIMENSION_TYPES.getOrDefault(key, NULL_DIMENSION_TYPE_FUNCTION).apply(level, args));
        }
        catch (Exception e) {
            throw new InvalidTridentLevelException("DimensionType", key, e);
        }
    }

    static {
        try {
            Constructor dimensionTypeConstructor = DimensionType.class.getDeclaredConstructor(OptionalLong.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, IBiomeMagnifier.class, ResourceLocation.class, ResourceLocation.class, Float.TYPE);
            dimensionTypeConstructor.setAccessible(true);
            DEFAULT_DIMENSION_TYPE_IMPL = (DimensionType)dimensionTypeConstructor.newInstance(OptionalLong.empty(), true, false, false, true, 1.0, false, false, true, false, true, 256, ColumnFuzzedBiomeMagnifier.INSTANCE, BlockTags.field_241277_aC_.func_230234_a_(), DimensionType.field_242710_a, Float.valueOf(0.0f));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        CHUNK_GENERATORS = Maps.newHashMap();
        STRUCTURE_SETTINGS = Maps.newHashMap();
        DIMENSION_TYPES = Maps.newHashMap();
        NO_STRUCTURES_STRUCTURE_SETTINGS = TridentLevelRegistry.registerStructureSettings("atlantis", "empty", (level, args) -> new DimensionStructuresSettings(Optional.empty(), (Map)ImmutableMap.of()));
        SUPERFLAT_CHUNK_GENERATOR = TridentLevelRegistry.registerChunkGenerator("atlantis", "superflat", (level, args) -> {
            Block block;
            Registry<Biome> biomes = TridentLevel.getBiomeRegistry();
            try {
                block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(args[0]));
            }
            catch (Exception e) {
                block = Blocks.field_150348_b;
            }
            if (block == null) {
                block = Blocks.field_150348_b;
            }
            FlatGenerationSettings settings = new FlatGenerationSettings(biomes, TridentLevelRegistry.getStructureSettings(NO_STRUCTURES_STRUCTURE_SETTINGS, level, new String[0]).get(), (List)Lists.newArrayList((Object[])new FlatLayerInfo[]{new FlatLayerInfo(5, block)}), false, false, Optional.of(() -> (Biome)biomes.func_230516_a_(Biomes.field_185440_P)));
            return new TridentChunkGenerator(settings);
        });
        VOID_STRUCTURE_GRID_CHUNK_GENERATOR = TridentLevelRegistry.registerChunkGenerator("atlantis", "structure_grid", (level, args) -> new VoidStructureGridChunkGenerator(Integer.parseInt(args[0]), args[1]));
        OVERWORLD_DIMENSION_TYPE = TridentLevelRegistry.registerDimensionType("minecraft", "overworld", (level, args) -> (DimensionType)ServerUtils.registry(Registry.field_239698_ad_).func_243576_d(DimensionType.field_235999_c_));
        UNIQUE_OVERWORLD_DIMENSION_TYPE = TridentLevelRegistry.registerDimensionType("atlantis", "unique", (level, args) -> (DimensionType)ServerUtils.registry(Registry.field_239698_ad_).func_218381_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)level.getRegistryKey().func_240901_a_()), (Object)DEFAULT_DIMENSION_TYPE_IMPL, Lifecycle.stable()));
    }
}

