/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.trident.level;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.trident.level.InvalidTridentLevelException;
import de.waterdu.atlantis.trident.level.TridentLevelRegistry;
import de.waterdu.atlantis.trident.level.TridentLevels;
import de.waterdu.atlantis.util.level.LazyLevel;
import de.waterdu.atlantis.util.server.ServerUtils;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TridentLevel {
    private static final ResourceLocation UNKNOWN = new ResourceLocation("unknown", "unknown");
    private LazyLevel level;
    private ResourceLocation chunkGenerator = UNKNOWN;
    private String[] chunkGeneratorArgs = new String[0];
    private ResourceLocation structureSettings = UNKNOWN;
    private String[] structureSettingsArgs = new String[0];
    private ResourceLocation dimensionType = UNKNOWN;
    private String[] dimensionTypeArgs = new String[0];
    private String levelName;
    private GameType gameType = GameType.SURVIVAL;
    private boolean hardcore = false;
    private Difficulty difficulty = Difficulty.NORMAL;
    private boolean allowCommands = true;

    public TridentLevel() {
        this("example");
    }

    public TridentLevel(String key) {
        this("atlantis", key);
    }

    public TridentLevel(String namespace, String key) {
        this.level = LazyLevel.of(namespace, key);
        this.levelName = this.level.toString();
    }

    protected Dimension initialize() throws InvalidTridentLevelException {
        ResourceLocation location = this.level.getKey().func_240901_a_();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)location);
        Optional<ChunkGenerator> oChunkGenerator = this.getChunkGenerator();
        Optional<DimensionStructuresSettings> oStructureSettings = this.getStructureSettings();
        Optional<DimensionType> oDimensionType = this.getDimensionType();
        if (!oChunkGenerator.isPresent()) {
            throw new InvalidTridentLevelException(this, "ChunkGenerator", this.chunkGenerator.toString());
        }
        if (!oStructureSettings.isPresent()) {
            throw new InvalidTridentLevelException(this, "DimensionStructuresSettings", this.structureSettings.toString());
        }
        if (!oDimensionType.isPresent()) {
            throw new InvalidTridentLevelException(this, "DimensionType", this.dimensionType.toString());
        }
        return (Dimension)server.func_240793_aU_().func_230418_z_().func_236224_e_().func_218381_a(key, (Object)new Dimension(oDimensionType::get, oChunkGenerator.get()), Lifecycle.stable());
    }

    protected void loadImmediate() {
        try {
            Dimension dimension = this.initialize();
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            DimensionGeneratorSettings dimensiongeneratorsettings = server.func_240793_aU_().func_230418_z_();
            WorldBorder worldborder = new WorldBorder();
            IChunkStatusListener ichunkstatuslistener = server.field_213220_d.create(11);
            boolean flag = dimensiongeneratorsettings.func_236227_h_();
            long seed = dimensiongeneratorsettings.func_236221_b_();
            long j = BiomeManager.func_235200_a_((long)seed);
            RegistryKey<World> key = this.getRegistryKey();
            DimensionType dimensiontype1 = dimension.func_236063_b_();
            ChunkGenerator chunkgenerator1 = dimension.func_236064_c_();
            WorldSettings worldSettings = new WorldSettings(this.levelName, this.gameType, this.hardcore, this.difficulty, this.allowCommands, server.func_240793_aU_().func_82574_x(), server.func_240793_aU_().func_230403_C_());
            ServerWorldInfo serverWorldInfo = new ServerWorldInfo(worldSettings, dimensiongeneratorsettings, Lifecycle.stable());
            ServerWorld serverworld1 = new ServerWorld(server, server.field_213217_au, server.field_71310_m, (IServerWorldInfo)serverWorldInfo, key, dimensiontype1, ichunkstatuslistener, chunkgenerator1, flag, j, (List)ImmutableList.of(), false);
            worldborder.func_177737_a((IBorderListener)new IBorderListener.Impl(serverworld1.func_175723_af()));
            server.field_71305_c.put(key, serverworld1);
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)serverworld1));
            ForcedChunksSaveData forcedchunkssavedata = (ForcedChunksSaveData)serverworld1.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
            if (forcedchunkssavedata != null) {
                LongIterator longiterator = forcedchunkssavedata.func_212438_a().iterator();
                while (longiterator.hasNext()) {
                    long i = longiterator.nextLong();
                    ChunkPos chunkpos = new ChunkPos(i);
                    serverworld1.func_72863_F().func_217206_a(chunkpos, true);
                }
                ForgeChunkManager.reinstatePersistentChunks((ServerWorld)serverworld1, (ForcedChunksSaveData)forcedchunkssavedata);
            }
        }
        catch (InvalidTridentLevelException e) {
            AtlantisLogger.error("Failed to initialize TridentLevel!", new Object[0]);
            e.printStackTrace();
        }
    }

    public LazyLevel getLevel() {
        return this.level;
    }

    public void setLevel(LazyLevel level) {
        this.level = level;
    }

    public RegistryKey<World> getRegistryKey() {
        return this.level.getKey();
    }

    public ServerWorld getActualWorld() {
        return this.level.getLevel();
    }

    public Optional<DimensionType> getDimensionType() throws InvalidTridentLevelException {
        return TridentLevelRegistry.getDimensionType(this.dimensionType, this, this.dimensionTypeArgs);
    }

    public Optional<ChunkGenerator> getChunkGenerator() throws InvalidTridentLevelException {
        return TridentLevelRegistry.getChunkGenerator(this.chunkGenerator, this, this.chunkGeneratorArgs);
    }

    public Optional<DimensionStructuresSettings> getStructureSettings() throws InvalidTridentLevelException {
        return TridentLevelRegistry.getStructureSettings(this.structureSettings, this, this.structureSettingsArgs);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TridentLevel) {
            return ((TridentLevel)obj).getRegistryKey().compareTo(this.getRegistryKey()) == 0;
        }
        if (obj instanceof World) {
            return ((World)obj).func_234923_W_().compareTo(this.getRegistryKey()) == 0;
        }
        if (obj instanceof RegistryKey) {
            return ((RegistryKey)obj).compareTo(this.getRegistryKey()) == 0;
        }
        return false;
    }

    public String toString() {
        return this.getRegistryKey().func_240901_a_().toString();
    }

    public static Builder builder(String namespace, String key) {
        return new Builder(namespace, key);
    }

    public static Registry<Biome> getBiomeRegistry() {
        return ServerUtils.registries().func_243612_b(Registry.field_239720_u_);
    }

    static /* synthetic */ String[] access$202(TridentLevel x0, String[] x1) {
        x0.chunkGeneratorArgs = x1;
        return x1;
    }

    static /* synthetic */ String[] access$402(TridentLevel x0, String[] x1) {
        x0.structureSettingsArgs = x1;
        return x1;
    }

    static /* synthetic */ String[] access$602(TridentLevel x0, String[] x1) {
        x0.dimensionTypeArgs = x1;
        return x1;
    }

    public static class Builder {
        private final TridentLevel level;

        private Builder(String namespace, String key) {
            this.level = new TridentLevel(namespace, key);
        }

        public Builder chunkGenerator(ResourceLocation chunkGenerator, String ... args) {
            this.level.chunkGenerator = chunkGenerator;
            TridentLevel.access$202(this.level, args);
            return this;
        }

        public Builder structureSettings(ResourceLocation structureSettings, String ... args) {
            this.level.structureSettings = structureSettings;
            TridentLevel.access$402(this.level, args);
            return this;
        }

        public Builder dimensionType(ResourceLocation dimensionType, String ... args) {
            this.level.dimensionType = dimensionType;
            TridentLevel.access$602(this.level, args);
            return this;
        }

        public Builder chunkGenerator(String chunkGenerator, String ... args) {
            this.level.chunkGenerator = new ResourceLocation(chunkGenerator);
            TridentLevel.access$202(this.level, args);
            return this;
        }

        public Builder structureSettings(String structureSettings, String ... args) {
            this.level.structureSettings = new ResourceLocation(structureSettings);
            TridentLevel.access$402(this.level, args);
            return this;
        }

        public Builder dimensionType(String dimensionType, String ... args) {
            this.level.dimensionType = new ResourceLocation(dimensionType);
            TridentLevel.access$602(this.level, args);
            return this;
        }

        public Builder levelName(String levelName) {
            this.level.levelName = levelName;
            return this;
        }

        public Builder gameType(GameType gameType) {
            this.level.gameType = gameType;
            return this;
        }

        public Builder hardcore(boolean hardcore) {
            this.level.hardcore = hardcore;
            return this;
        }

        public Builder difficulty(Difficulty difficulty) {
            this.level.difficulty = difficulty;
            return this;
        }

        public Builder allowCommands(boolean allowCommands) {
            this.level.allowCommands = allowCommands;
            return this;
        }

        public TridentLevel build() {
            return this.build(true);
        }

        public TridentLevel build(boolean instantiate) {
            if (instantiate) {
                TridentLevels.instance().addLevel(this.level);
            }
            return this.level;
        }
    }
}

