/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.trident.chunk;

import de.waterdu.atlantis.trident.chunk.TridentChunk;
import de.waterdu.atlantis.trident.chunk.TridentChunks;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class TridentChunkLoader {
    private TridentChunkLoader() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ForgeChunkManager.setForcedChunkLoadingCallback((String)"atlantis", (world, tickets) -> {
            TridentChunks chunks = TridentChunks.getInstance();
            for (TridentChunk chunk : chunks.getTransientChunks()) {
                tickets.removeTicket(chunk.getOwner(), chunk.getPos().func_201841_a(), chunk.isTicking());
            }
            chunks.getTransientChunks().clear();
            for (TridentChunk chunk : chunks.getPermanentChunks()) {
                chunk.load();
            }
            chunks.save();
        }));
    }

    public static TridentChunk load(TridentChunk chunk) {
        return TridentChunkLoader.load(chunk, false);
    }

    public static TridentChunk load(TridentChunk chunk, boolean permanent) {
        chunk.load();
        TridentChunks.getInstance().addChunk(chunk, permanent);
        return chunk;
    }

    public static void unload(TridentChunk chunk) {
        chunk.unload();
    }
}

