/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.trident.chunk;

import de.waterdu.atlantis.trident.chunk.TridentChunks;
import de.waterdu.atlantis.util.java.UUIDUtils;
import de.waterdu.atlantis.util.level.LazyLevel;
import java.util.UUID;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;

public class TridentChunk {
    private String modid;
    private UUID owner;
    private LazyLevel level;
    private int x;
    private int z;
    private boolean ticking;
    private transient String toString = null;
    private transient int hashCode = -1;

    public TridentChunk() {
        this("atlantis", UUIDUtils.fromHashCode("atlantis"), LazyLevel.of("minecraft:overworld"), 0, 0, false);
    }

    public TridentChunk(String modid, LazyLevel level, int x, int z) {
        this(modid, UUIDUtils.fromHashCode(modid), level, x, z, false);
    }

    public TridentChunk(String modid, LazyLevel level, int x, int z, boolean ticking) {
        this(modid, UUIDUtils.fromHashCode(modid), level, x, z, ticking);
    }

    public TridentChunk(String modid, Object owner, LazyLevel level, int x, int z, boolean ticking) {
        this(modid, UUIDUtils.fromHashCode(owner), level, x, z, ticking);
    }

    public TridentChunk(String modid, UUID owner, LazyLevel level, int x, int z, boolean ticking) {
        this.modid = modid;
        this.owner = owner;
        this.level = level;
        this.x = x;
        this.z = z;
        this.ticking = ticking;
    }

    public boolean load() {
        return ForgeChunkManager.forceChunk((ServerWorld)this.level.getLevel(), (String)this.modid, (UUID)this.owner, (int)this.x, (int)this.z, (boolean)true, (boolean)this.ticking);
    }

    public boolean unload() {
        boolean result = ForgeChunkManager.forceChunk((ServerWorld)this.level.getLevel(), (String)this.modid, (UUID)this.owner, (int)this.x, (int)this.z, (boolean)false, (boolean)this.ticking);
        TridentChunks chunks = TridentChunks.getInstance();
        boolean changed = chunks.getTransientChunks().remove(this);
        if (changed |= chunks.getPermanentChunks().remove(this)) {
            chunks.save();
        }
        return result;
    }

    public void update(Runnable task) {
        this.unload();
        task.run();
        this.invalidate();
        this.load();
    }

    public String getModID() {
        return this.modid;
    }

    public void setModID(String modid) {
        this.update(() -> {
            this.modid = modid;
        });
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.update(() -> {
            this.owner = owner;
        });
    }

    public LazyLevel getLevel() {
        return this.level;
    }

    public void setLevel(LazyLevel level) {
        this.update(() -> {
            this.level = level;
        });
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.update(() -> {
            this.x = x;
        });
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.update(() -> {
            this.z = z;
        });
    }

    public ChunkPos getPos() {
        return new ChunkPos(this.x, this.z);
    }

    public void setTicking(boolean ticking) {
        this.update(() -> {
            this.ticking = ticking;
        });
    }

    public boolean isTicking() {
        return this.ticking;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TridentChunk)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "TridentChunk{" + this.modid + "," + this.owner + "," + this.level.getKey().func_240901_a_() + "@(" + this.x + "," + this.z + ")" + (this.ticking ? "T" : "") + "}";
        }
        return this.toString;
    }

    private void invalidate() {
        this.toString = null;
        this.hashCode = -1;
    }
}

