/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.trident;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.meta.PageEvent;
import de.waterdu.atlantis.trident.Trident;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.ui.api.PageOptions;
import de.waterdu.atlantis.util.java.Pair;
import de.waterdu.atlantis.util.text.MessageUtils;
import de.waterdu.atlantis.util.text.Text;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TridentListener {
    private static final Pair<Integer, PageOptions.FormFactor> DEFAULT_FORM_FACTOR = Pair.of(6, PageOptions.FormFactor.CHEST);
    private static final Text COPY = Text.of(TextFormatting.BLACK + "[" + TextFormatting.YELLOW + "Copy" + TextFormatting.BLACK + "]");
    private static final Text COPY_LORE = Text.of(TextFormatting.YELLOW + "Click to copy to clipboard");
    private static final Text DECORATE = Text.of(TextFormatting.BLACK + "[" + TextFormatting.GOLD + "Decorate" + TextFormatting.BLACK + "]");
    private static final Text DECORATE_LORE = Text.of(TextFormatting.GOLD + "Click to open decoration editor");
    private final Set<UUID> pageClasspathTracking = Sets.newHashSet();
    private final BiMap<String, Class<? extends Page>> pages = HashBiMap.create();
    private final Map<Class<? extends Page>, Pair<Integer, PageOptions.FormFactor>> formFactors = Maps.newHashMap();
    private String[] pageNames = new String[0];

    public TridentListener() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Atlantis.EVENT_BUS.register((Object)this);
    }

    public boolean toggleClasspathTracking(Entity player) {
        if (this.pageClasspathTracking.contains(player.func_110124_au())) {
            this.pageClasspathTracking.remove(player.func_110124_au());
            return false;
        }
        this.pageClasspathTracking.add(player.func_110124_au());
        return true;
    }

    public Pair<Integer, PageOptions.FormFactor> getFormFactor(Class<? extends Page> clazz) {
        return this.formFactors.getOrDefault(clazz, DEFAULT_FORM_FACTOR);
    }

    public String[] getPageNames() {
        if (this.pageNames.length != this.pages.size()) {
            this.pageNames = this.pages.keySet().toArray(new String[0]);
        }
        return this.pageNames;
    }

    public Class<? extends Page> getPage(String name) {
        return (Class)this.pages.get((Object)name);
    }

    @SubscribeEvent
    public void onPageOpen(PageEvent.Construct event) {
        Atlantis.THREAD_POOL.submit(() -> {
            PageOptions options = event.getPage().getPageOptions(event.getPlayer());
            this.formFactors.put(event.getPage().getClass(), Pair.of(options.getRows(), options.getFormFactor()));
            this.pages.put((Object)event.getPage().getClass().getName(), event.getPage().getClass());
        });
        if (this.pageClasspathTracking.contains(event.getPlayer().uuid())) {
            String name = event.getPage().getClass().getName();
            MessageUtils.send(Trident.PREFIX.compile().func_230529_a_((ITextComponent)COPY.compile().func_240700_a_(style -> style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)COPY_LORE.compile())).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, name)))).func_240702_b_(" ").func_230529_a_((ITextComponent)DECORATE.compile().func_240700_a_(style -> style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)DECORATE_LORE.compile())).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/trident decorate " + name)))).func_240702_b_(" " + TextFormatting.GRAY + "Just opened: " + TextFormatting.WHITE + name), event.getPlayer());
            AtlantisLogger.infoForced("Just opened: " + name, new Object[0]);
        }
    }
}

