/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.trident;

import com.google.common.collect.Lists;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.command.AtlantisCommand;
import de.waterdu.atlantis.command.CommandBuilder;
import de.waterdu.atlantis.trident.DecorationEditor;
import de.waterdu.atlantis.trident.TridentListener;
import de.waterdu.atlantis.trident.chunk.TridentChunkLoader;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.util.entity.PermissionUtils;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.level.LazyLevel;
import de.waterdu.atlantis.util.server.ServerUtils;
import de.waterdu.atlantis.util.text.MessageUtils;
import de.waterdu.atlantis.util.text.Text;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;

public class Trident {
    private static final AtomicBoolean READY = new AtomicBoolean(false);
    private static final AtomicBoolean OUTDATED = new AtomicBoolean(false);
    public static final List<String> AQUA_MODS = Lists.newArrayList();
    public static final String ID = "trident";
    private static final String PIXELMON_ID = "pixelmon";
    private static final String PIXELMON_NAME = "Pixelmon Mod";
    private static final String AUTHORS = "authors";
    private static final String ISSUE_TRACKER = "issueTrackerURL";
    public static final String COMMAND_NAME = "atlantis";
    public static final List<String> COMMAND_ALIAS = Lists.newArrayList((Object[])new String[]{"trident", "poseidon"});
    public static final String PERMISSION = "trident.use";
    public static final Text PREFIX = Text.Immutable.of("&0[&#@3079FF-1ABEDCTrident&0]&7 ");
    public static final String GRADIENT = "&#@55FFFF-00AAAA";
    public static final String PIXELMON_GRADIENT = "&#@AE2500-FFB400";
    public static final String BLUE = "&#73DCFF";
    public static final IFormattableTextComponent MODLIST = PREFIX.compile().func_240702_b_(TextFormatting.GRAY + "Mods: ");
    public static IFormattableTextComponent MESSAGE_A = null;
    public static IFormattableTextComponent MESSAGE_B = null;
    public static final IFormattableTextComponent UPDATE = PREFIX.compile().func_240702_b_(TextFormatting.DARK_RED + "Out of date mods: ");
    public static TridentListener LISTENER;
    public static AtlantisCommand COMMAND;

    private Trident() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static void init(FMLCommonSetupEvent event) {
        AtlantisLogger.info("Trident is readying.", new Object[0]);
        TridentChunkLoader.setup(event);
        LISTENER = new TridentListener();
        COMMAND = CommandBuilder.create(() -> COMMAND_NAME, () -> COMMAND_ALIAS, () -> MESSAGE_B, () -> MESSAGE_B).condition((context, args) -> {
            if (!Trident.isReady()) {
                MessageUtils.send(PREFIX.compile().func_240702_b_(TextFormatting.RED + "Trident is loading..."), (CommandSource)context.getSource());
                return false;
            }
            return true;
        }).execute((context, args) -> MessageUtils.send(MESSAGE_B, (CommandSource)context.getSource())).child().permission(PERMISSION).test(CommandBuilder.Test.matchesAndHasPermission("mods", "modlist")).completion(CommandBuilder.Completion.of("mods", "modlist")).execute((context, args) -> MessageUtils.send(MODLIST, (CommandSource)context.getSource())).parent().child().permission(PERMISSION).test(CommandBuilder.Test.matchesAndHasPermission("reload")).completion(CommandBuilder.Completion.of("reload")).execute((context, args) -> {
            Atlantis.CONFIG.load(Settings.class);
            MessageUtils.send(PREFIX.compile().func_240702_b_(TextFormatting.GREEN + "Reloaded Atlantis configuration."), (CommandSource)context.getSource());
        }).parent().child().permission(PERMISSION).test(CommandBuilder.Test.matchesAndHasPermission("logpagenames")).completion(CommandBuilder.Completion.of("logpagenames")).execute((context, args) -> {
            if (((CommandSource)context.getSource()).func_197022_f() instanceof ServerPlayerEntity) {
                if (LISTENER.toggleClasspathTracking(((CommandSource)context.getSource()).func_197022_f())) {
                    MessageUtils.send(PREFIX.compile().func_240702_b_(TextFormatting.GREEN + "Now logging opened page names to chat and console."), (CommandSource)context.getSource());
                } else {
                    MessageUtils.send(PREFIX.compile().func_240702_b_(TextFormatting.GRAY + "No longer logging opened page names to chat and console."), (CommandSource)context.getSource());
                }
            }
        }).parent().child().permission(PERMISSION).test(CommandBuilder.Test.matchesAndHasPermission("decorate", "decorations")).completion(CommandBuilder.Completion.of("decorate", "decorations")).child().test(CommandBuilder.Test.matches(() -> LISTENER.getPageNames())).completion(CommandBuilder.Completion.of(() -> LISTENER.getPageNames())).execute((context, args) -> {
            if (((CommandSource)context.getSource()).func_197022_f() instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)((CommandSource)context.getSource()).func_197022_f();
                Class<? extends Page> page = LISTENER.getPage(args[1]);
                if (page != null) {
                    new DecorationEditor(page).open((PlayerEntity)player);
                }
            }
        }).parent().parent().child().permission(PERMISSION).test(CommandBuilder.Test.matchesAndHasPermission("levelinfo")).completion(CommandBuilder.Completion.of("levelinfo")).execute((context, args) -> {
            if (((CommandSource)context.getSource()).func_197022_f() != null) {
                Entity entity = ((CommandSource)context.getSource()).func_197022_f();
                if (entity.field_70170_p instanceof ServerWorld) {
                    ServerWorld level = (ServerWorld)entity.field_70170_p;
                    MessageUtils.send(PREFIX.append(String.valueOf(TextFormatting.AQUA) + TextFormatting.BOLD + "Level/Dimension Info"), (CommandSource)context.getSource());
                    MessageUtils.send(TextFormatting.GRAY + "Dimension Key: " + TextFormatting.WHITE + level.func_234923_W_().func_240901_a_(), (CommandSource)context.getSource());
                    MessageUtils.send(TextFormatting.GRAY + "Chunk Generator: " + TextFormatting.WHITE + level.func_72863_F().field_186029_c.getClass().getSimpleName(), (CommandSource)context.getSource());
                    MessageUtils.send(TextFormatting.GRAY + "Dimension Type: " + TextFormatting.WHITE + ServerUtils.key(Registry.field_239698_ad_, level.func_230315_m_()), (CommandSource)context.getSource());
                    MessageUtils.send(TextFormatting.GRAY + "Level Seed: " + TextFormatting.WHITE + level.func_72905_C(), (CommandSource)context.getSource());
                }
            } else {
                MessageUtils.send(PREFIX.append(TextFormatting.RED + "Not in a level!"), (CommandSource)context.getSource());
            }
        }).parent().child().permission(PERMISSION).test(CommandBuilder.Test.matchesAndHasPermission("goto")).completion(CommandBuilder.Completion.of("goto")).child().test(CommandBuilder.Test.TRUE).completion(CommandBuilder.Completion.of(() -> {
            ArrayList names = Lists.newArrayList();
            for (ServerWorld level : ServerLifecycleHooks.getCurrentServer().func_212370_w()) {
                names.add(level.func_234923_W_().func_240901_a_().toString());
            }
            return names.toArray(new String[0]);
        })).execute((context, args) -> {
            if (((CommandSource)context.getSource()).func_197022_f() instanceof ServerPlayerEntity) {
                Entity entity = ((CommandSource)context.getSource()).func_197022_f();
                LazyLevel level = LazyLevel.of(args[args.length - 1]);
                if (level.getLevel() != null) {
                    ((ServerPlayerEntity)entity).func_200619_a(level.getLevel(), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
                } else {
                    MessageUtils.send(PREFIX.append(TextFormatting.RED + "Invalid level!"), (CommandSource)context.getSource());
                }
            }
        }).parent().parent().done();
        event.enqueueWork(() -> Atlantis.THREAD_POOL.schedule(() -> {
            StringBuilder messageA = new StringBuilder();
            StringBuilder messageB = new StringBuilder();
            String aquaMod = "";
            boolean first = true;
            for (ModInfo mod : FMLLoader.getLoadingModList().getMods()) {
                boolean isPixelmon = mod.getModId().equalsIgnoreCase(PIXELMON_ID);
                IFormattableTextComponent component = Text.of(mod.getDisplayName()).compile();
                VersionChecker.CheckResult version = VersionChecker.getResult((IModInfo)mod);
                VersionChecker.Status status = version == null ? VersionChecker.Status.FAILED : version.status;
                String latest = version == null || version.target == null ? "?" : version.target.toString();
                URL tracker = mod.getOwningFile().getIssueURL();
                Style style = Style.field_240709_b_;
                String hover = "";
                if (tracker != null) {
                    style = style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, tracker.toString()));
                    hover = "\n\n" + TextFormatting.AQUA + "Click to open issue tracker";
                }
                boolean outdated = false;
                if (status == VersionChecker.Status.UP_TO_DATE || status == VersionChecker.Status.BETA) {
                    latest = mod.getVersion().toString();
                    String beta = status == VersionChecker.Status.BETA ? TextFormatting.LIGHT_PURPLE + "" + TextFormatting.BOLD + "\u03b2" + TextFormatting.RESET + TextFormatting.LIGHT_PURPLE + " Up to date (beta)" : TextFormatting.GREEN + "" + TextFormatting.BOLD + "\u2713" + TextFormatting.RESET + TextFormatting.GREEN + " Up to date";
                    style = style.func_240712_a_(TextFormatting.GREEN);
                    hover = TextFormatting.GRAY + "Name: " + TextFormatting.WHITE + mod.getDisplayName() + "\n" + TextFormatting.GRAY + "ID: " + TextFormatting.WHITE + mod.getModId() + "\n\n" + TextFormatting.GRAY + "Version: " + TextFormatting.GREEN + mod.getVersion().toString() + "\n" + TextFormatting.GRAY + "Latest: " + TextFormatting.WHITE + latest + "\n\n" + beta + hover;
                } else if (status == VersionChecker.Status.OUTDATED || status == VersionChecker.Status.BETA_OUTDATED) {
                    style = style.func_240712_a_(TextFormatting.RED);
                    hover = TextFormatting.GRAY + "Name: " + TextFormatting.WHITE + mod.getDisplayName() + "\n" + TextFormatting.GRAY + "ID: " + TextFormatting.WHITE + mod.getModId() + "\n\n" + TextFormatting.GRAY + "Version: " + TextFormatting.RED + mod.getVersion().toString() + "\n" + TextFormatting.GRAY + "Latest: " + TextFormatting.WHITE + latest + "\n\n" + TextFormatting.RED + TextFormatting.BOLD + "\u2717" + TextFormatting.RESET + TextFormatting.RED + " Outdated" + (status == VersionChecker.Status.BETA_OUTDATED ? " (beta)" : "") + hover;
                    outdated = true;
                } else if (status == VersionChecker.Status.AHEAD) {
                    style = style.func_240712_a_(TextFormatting.GOLD);
                    hover = TextFormatting.GRAY + "Name: " + TextFormatting.WHITE + mod.getDisplayName() + "\n" + TextFormatting.GRAY + "ID: " + TextFormatting.WHITE + mod.getModId() + "\n\n" + TextFormatting.GRAY + "Version: " + TextFormatting.GOLD + mod.getVersion().toString() + "\n" + TextFormatting.GRAY + "Latest: " + TextFormatting.WHITE + latest + "\n\n" + TextFormatting.GOLD + "\u2605" + TextFormatting.RESET + TextFormatting.GOLD + " Ahead of latest" + hover;
                } else {
                    style = style.func_240712_a_(TextFormatting.YELLOW);
                    hover = TextFormatting.GRAY + "Name: " + TextFormatting.WHITE + mod.getDisplayName() + "\n" + TextFormatting.GRAY + "ID: " + TextFormatting.WHITE + mod.getModId() + "\n\n" + TextFormatting.GRAY + "Version: " + TextFormatting.YELLOW + mod.getVersion().toString() + "\n" + TextFormatting.GRAY + "Latest: " + TextFormatting.WHITE + latest + "\n\n" + TextFormatting.RED + TextFormatting.BOLD + "\u25b2" + TextFormatting.RESET + TextFormatting.RED + " Failed to fetch info" + hover;
                }
                style = style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(hover)));
                component.func_230530_a_(style);
                if (outdated) {
                    if (OUTDATED.get()) {
                        UPDATE.func_240702_b_(TextFormatting.DARK_RED + ", ");
                    }
                    UPDATE.func_230529_a_((ITextComponent)component);
                    OUTDATED.set(true);
                }
                if (!first) {
                    MODLIST.func_240702_b_(TextFormatting.GRAY + ", ");
                }
                MODLIST.func_230529_a_((ITextComponent)component);
                first = false;
                String authors = mod.getConfigElement(new String[]{AUTHORS}).orElse("");
                if (!isPixelmon && (!(authors instanceof String) || !authors.contains("Waterdude"))) continue;
                if (!aquaMod.isEmpty()) {
                    String gradient;
                    String string = gradient = aquaMod.equalsIgnoreCase(PIXELMON_NAME) ? PIXELMON_GRADIENT : GRADIENT;
                    if (messageA.length() == 0) {
                        messageA.append(PREFIX.get()).append(BLUE).append("Waterdude, the developer of ").append(gradient).append(aquaMod);
                        messageB.append(PREFIX.get()).append(BLUE).append("By Waterdude, powered by Atlantis: ").append(gradient).append(aquaMod);
                    } else {
                        messageA.append(BLUE).append(", ").append(gradient).append(aquaMod);
                        messageB.append(BLUE).append(", ").append(gradient).append(aquaMod);
                    }
                }
                aquaMod = TextFormatting.func_110646_a((String)mod.getDisplayName());
                AQUA_MODS.add(mod.getModId());
            }
            if (!aquaMod.isEmpty()) {
                String gradient;
                String string = gradient = aquaMod.equalsIgnoreCase(PIXELMON_NAME) ? PIXELMON_GRADIENT : GRADIENT;
                if (messageA.length() == 0) {
                    messageA.append(PREFIX.get()).append(BLUE).append("Waterdude, the developer of ").append(gradient).append(aquaMod);
                    messageB.append(PREFIX.get()).append(BLUE).append("By Waterdude, powered by Atlantis: ").append(gradient).append(aquaMod);
                } else {
                    messageA.append(BLUE).append(" and ").append(gradient).append(aquaMod);
                    messageB.append(BLUE).append(" and ").append(gradient).append(aquaMod);
                }
            }
            messageA.append(BLUE).append(", has joined!");
            MESSAGE_A = Text.of(messageA.toString()).compile();
            messageB.append(BLUE).append(".").append(BLUE).append("[L]").append(" Click for more information!");
            MESSAGE_B = Text.of(messageB.toString()).compile();
            MESSAGE_B.func_230530_a_(MESSAGE_B.func_150256_b().func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)Text.of("&#73DCFFClick to visit Atlantis Development!").compile())).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.discord.gg/Ff3bEwb")));
            AtlantisLogger.info("Trident is ready.", new Object[0]);
            READY.set(true);
        }, 30L, TimeUnit.SECONDS));
    }

    public static void login(ServerPlayerEntity player) {
        if (READY.get()) {
            if (OUTDATED.get() && PermissionUtils.hasPermission((PlayerEntity)player, PERMISSION)) {
                MessageUtils.send(UPDATE, new ICommandSource[]{player});
            }
            if (Settings.getSettings().isTridentPublicMessage() && Atlantis.isWaterdude((PlayerEntity)player)) {
                MessageUtils.sendToAll(MESSAGE_A);
            }
        }
    }

    public static boolean isReady() {
        return READY.get();
    }

    public static int countAquaMods() {
        int count = 0;
        for (ModInfo mod : FMLLoader.getLoadingModList().getMods()) {
            String authors = mod.getConfigElement(new String[]{AUTHORS}).orElse("");
            if (!(authors instanceof String) || !authors.contains("Waterdude")) continue;
            ++count;
        }
        return count;
    }

    public static void registerModLoadingContext() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }
}

