/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.trident;

import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.trident.DecorationEditor;
import de.waterdu.atlantis.ui.api.Button;
import de.waterdu.atlantis.ui.api.ClickData;
import de.waterdu.atlantis.ui.api.ClickState;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.ui.api.PageOptions;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.text.Text;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;

public class DecorationPalette
implements Page {
    private static final Text LORE_A = Text.of(TextFormatting.GRAY + "Left click to select brush");
    private static final Text LORE_B = Text.of(TextFormatting.GRAY + "Right click to pin brush");
    private static final Text LORE_C = Text.of(TextFormatting.RED + "Right click to unpin brush");
    private final DecorationEditor parent;

    public DecorationPalette(DecorationEditor parent) {
        this.parent = parent;
    }

    @Override
    public PageOptions getPageOptions(PlayerReference player) {
        return PageOptions.builder().setTitle("Choose a brush").setRows(6).setInventoryHidden(true).build();
    }

    @Override
    public void addButtons(PlayerReference player, Set<Button> buttons) {
        buttons.add(Button.builder().setIndex(64).setItem(Items.field_151032_g).setName(TextFormatting.YELLOW + "<-").setClickAction(ClickData::prevPage).build());
        buttons.add(Button.builder().setIndex(70).setItem(Items.field_151032_g).setName(TextFormatting.YELLOW + "->").setClickAction(ClickData::nextPage).build());
        buttons.add(Button.builder().setIndex(67).setItem(Items.field_221803_eL).setName(TextFormatting.WHITE + "Clear").addLoreLine(LORE_A).setClickAction(clickData -> clickData.openPage(new DecorationEditor(this.parent.clazz, this.parent.name, ItemStack.field_190927_a, 0, this.parent.decorations, 0))).build());
        List<Item> pins = Settings.getSettings().getParsedPinnedDecorations();
        int page = 0;
        int slot = 0;
        for (Item item : pins) {
            this.addItemButton(buttons, item, true, page, slot++);
            if (slot < 54) continue;
            slot = 0;
            ++page;
        }
        for (Item item : ForgeRegistries.ITEMS) {
            this.addItemButton(buttons, item, false, page, slot++);
            if (slot < 54) continue;
            slot = 0;
            ++page;
        }
    }

    private void addItemButton(Set<Button> buttons, Item item, boolean pinned, int page, int slot) {
        ItemStack stack = new ItemStack((IItemProvider)item);
        Text name = Text.of(TextFormatting.RESET + "" + TextFormatting.WHITE + item.func_200295_i(stack).getString());
        buttons.add(Button.builder().setItem(stack).setName(name).setIndex(slot).setPage(page).setSinglePress().addLoreLine(LORE_A).addLoreLine(pinned ? LORE_C : LORE_B).setClickAction(clickData -> {
            if (clickData.getClickState().getButton() == ClickState.MouseButton.LEFT) {
                clickData.openPage(new DecorationEditor(this.parent.clazz, this.parent.name, stack, 0, this.parent.decorations, 0));
            } else if (clickData.getClickState().getButton() == ClickState.MouseButton.RIGHT) {
                Settings settings = Settings.getSettings();
                if (pinned) {
                    settings.getPinnedDecorations().remove(item.getRegistryName());
                } else {
                    settings.getPinnedDecorations().add(item.getRegistryName());
                }
                settings.save();
                clickData.openPage(this);
            }
        }).build());
    }
}

