/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.trident;

import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.file.AtlantisData;
import de.waterdu.atlantis.trident.DecorationPalette;
import de.waterdu.atlantis.trident.Trident;
import de.waterdu.atlantis.ui.api.AtlantisUI;
import de.waterdu.atlantis.ui.api.Button;
import de.waterdu.atlantis.ui.api.ClickState;
import de.waterdu.atlantis.ui.api.Decorations;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.ui.api.PageOptions;
import de.waterdu.atlantis.ui.internal.Buttons;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.java.Pair;
import de.waterdu.atlantis.util.text.Text;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class DecorationEditor
implements Page {
    protected final Class<? extends Page> clazz;
    protected final String name;
    protected final ItemStack brush;
    protected final int title;
    protected final Decorations decorations;
    protected int ticker;

    public DecorationEditor(Class<? extends Page> clazz) {
        this.clazz = clazz;
        this.name = clazz.getSimpleName();
        this.brush = ItemStack.field_190927_a;
        this.title = 0;
        Decorations decorations = AtlantisData.getDecorations(clazz);
        if (decorations == null) {
            decorations = new Decorations(clazz.getName());
            Atlantis.CONFIG.put(Decorations.class, decorations);
            decorations.save();
        }
        this.decorations = decorations;
        this.ticker = 0;
    }

    public DecorationEditor(Class<? extends Page> clazz, String name, ItemStack brush, int title, Decorations decorations, int ticker) {
        this.clazz = clazz;
        this.name = name;
        this.brush = brush;
        this.title = title > 3 ? 0 : title;
        this.decorations = decorations;
        this.ticker = ticker;
    }

    @Override
    public void addButtons(PlayerReference player, Set<Button> buttons) {
        buttons.addAll(this.decorations.getButtons());
    }

    @Override
    public PageOptions getPageOptions(PlayerReference player) {
        Pair<Integer, PageOptions.FormFactor> formFactor = Trident.LISTENER.getFormFactor(this.clazz);
        return PageOptions.builder().setInventoryHidden(true).setRows(formFactor.getA()).setFormFactor(formFactor.getB()).setTitle(this.getTitle()).build();
    }

    @Override
    public void onButtonClick(PlayerReference player, int index, ClickState clickState) {
        if (clickState.getButton() == ClickState.MouseButton.RIGHT) {
            new DecorationPalette(this).open(player);
        } else if (index >= 0) {
            if (this.brush.func_190926_b() || clickState.getButton() == ClickState.MouseButton.MIDDLE) {
                this.decorations.getDecorations().remove(index);
            } else {
                this.decorations.getDecorations().put(index, this.brush.func_77973_b().getRegistryName().toString());
            }
            this.decorations.setChanged();
            this.open(player);
        }
    }

    @Override
    public Buttons onUpdate(long tick, PlayerReference player, Buttons buttons) {
        ++this.ticker;
        if (this.ticker > 45) {
            AtlantisUI.open(player, (Page)new DecorationEditor(this.clazz, this.name, this.brush, this.title + 1, this.decorations, 0));
        }
        return buttons;
    }

    @Override
    public void afterClose(PlayerReference player) {
        this.decorations.save();
        this.decorations.setChanged();
        AtlantisData.mapDecorations();
    }

    private Text getTitle() {
        if (this.title == 0) {
            return Text.of("Editing: " + this.name);
        }
        if (this.title == 1) {
            return Text.of("Brush: " + (this.brush.func_190926_b() ? "Clear" : this.brush.func_77973_b().func_200295_i(this.brush).getString()));
        }
        if (this.title == 2) {
            return Text.of("Right click to change brush");
        }
        return Text.of("Middle click to clear");
    }
}

