/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.playerdata;

import com.google.common.collect.Maps;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.file.auto.AtlantisConfig;
import de.waterdu.atlantis.file.datatypes.Configuration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;

@AtlantisConfig(modID="atlantis", path="uuids.json")
public class UUIDNameCache
implements Configuration {
    private Map<String, UUID> map = Maps.newHashMap();
    private transient Map<UUID, String> inverse = Maps.newHashMap();

    private static void invert() {
        UUIDNameCache instance = UUIDNameCache.get();
        if (instance.map.size() != instance.inverse.size()) {
            HashMap<UUID, String> inverse = new HashMap<UUID, String>(instance.map.size());
            for (Map.Entry<String, UUID> entry : instance.map.entrySet()) {
                inverse.put(entry.getValue(), entry.getKey());
            }
            instance.inverse = inverse;
        }
    }

    private static UUIDNameCache get() {
        return Atlantis.CONFIG.get(UUIDNameCache.class);
    }

    private static void write() {
        Atlantis.CONFIG.save(UUIDNameCache.class);
    }

    public static void add(PlayerEntity player) {
        UUIDNameCache.add(player.func_200200_C_().getString(), player.func_110124_au());
    }

    public static void add(String name, UUID uuid) {
        if (name.isEmpty() || name.equalsIgnoreCase(uuid.toString())) {
            return;
        }
        if (!uuid.equals(UUIDNameCache.get(name))) {
            UUIDNameCache.get().map.put(name, uuid);
            UUIDNameCache.write();
            UUIDNameCache.invert();
        }
    }

    public static UUID get(String name) {
        UUIDNameCache.invert();
        return UUIDNameCache.get().map.getOrDefault(name, Util.field_240973_b_);
    }

    public static String get(UUID uuid) {
        UUIDNameCache.invert();
        return UUIDNameCache.get().inverse.getOrDefault(uuid, "");
    }
}

