/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.playerdata;

import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.comm.Skin;
import de.waterdu.atlantis.comm.SkinQuery;
import de.waterdu.atlantis.comm.UUIDQuery;
import de.waterdu.atlantis.comm.UsernameQuery;
import de.waterdu.atlantis.file.auto.AtlantisConfig;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@AtlantisConfig(modID="atlantis", path="players", forceLoad=true)
public class PlayerData
implements de.waterdu.atlantis.file.datatypes.PlayerData {
    private static final UUID NULL_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    private UUID uuid = NULL_UUID;
    private String name = "";
    private Skin skinObject = new Skin();
    private long lastLogin = -1L;
    private long lastSkinFetch = -1L;

    public PlayerData() {
    }

    public PlayerData(ServerPlayerEntity player) {
        this(player.func_110124_au(), player.func_200200_C_().getString());
    }

    public PlayerData(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        SkinQuery.from(uuid).to(this).query();
    }

    public PlayerData(String name) {
        this.name = name;
        UUIDQuery.from(name).to(this).query();
    }

    public PlayerData(UUID uuid) {
        this.uuid = uuid;
        UsernameQuery.from(uuid).to(this).query();
        SkinQuery.from(uuid).to(this).query();
    }

    @Override
    public void onLogin(ServerPlayerEntity player) {
        this.uuid = player.func_110124_au();
        this.name = player.func_200200_C_().getString();
        if (this.setLastLogin() > 10800000L) {
            SkinQuery.from(this.uuid).to(this).query();
        }
        this.save();
    }

    @Override
    public void onLogout(ServerPlayerEntity player) {
    }

    public ItemStack getSkullItemStack() {
        ItemStack stack = new ItemStack((IItemProvider)Blocks.field_196710_eS, 1);
        Skin skin = this.getSkin();
        if (skin.hasSkin()) {
            try {
                CompoundNBT tag = new CompoundNBT();
                CompoundNBT skullOwner = new CompoundNBT();
                skullOwner.func_186854_a("Id", this.getUUID());
                skullOwner.func_74778_a("Name", this.getName());
                CompoundNBT properties = new CompoundNBT();
                ListNBT textures = new ListNBT();
                CompoundNBT texture = new CompoundNBT();
                texture.func_74778_a("Value", skin.getSkin());
                if (skin.hasSignature()) {
                    texture.func_74778_a("Signature", skin.getSignature());
                }
                textures.add((Object)texture);
                properties.func_218657_a("textures", (INBT)textures);
                skullOwner.func_218657_a("Properties", (INBT)properties);
                tag.func_218657_a("SkullOwner", (INBT)skullOwner);
                stack.func_77982_d(tag);
            }
            catch (Exception e) {
                AtlantisLogger.error(e.toString(), new Object[0]);
                e.printStackTrace();
            }
        }
        return stack;
    }

    @Override
    public synchronized void save() {
        Atlantis.CONFIG.save(this);
    }

    @Override
    public String getName() {
        if (this.name.isEmpty() && this.uuid != null && !this.uuid.equals(NULL_UUID)) {
            UsernameQuery.from(this.uuid).to(this).query();
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ServerPlayerEntity getPlayerEntity() {
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(this.uuid);
    }

    @Override
    public UUID getUUID() {
        if (this.uuid == null || this.uuid.equals(NULL_UUID)) {
            UUIDQuery.from(this.name).to(this).query();
            return null;
        }
        return this.uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUniqueName() {
        return this.uuid.toString();
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public Skin getSkin() {
        long time = System.currentTimeMillis();
        if (this.lastSkinFetch == -1L) {
            this.lastSkinFetch = time;
        }
        if (!(this.skinObject.hasSkin() && time - this.lastSkinFetch < Settings.getSettings().getSkinRefetchGapSeconds() || this.getUUID() == null)) {
            this.lastSkinFetch = time;
            SkinQuery.from(this.uuid).to(this).query();
        }
        return this.skinObject;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setLastLogin(long lastLogin) {
        this.lastLogin = lastLogin;
    }

    public long setLastLogin() {
        long lastLogin = this.lastLogin;
        this.setLastLogin(System.currentTimeMillis());
        return this.lastLogin - lastLogin;
    }

    public void setSkinObject(Skin skinObject) {
        this.skinObject = skinObject;
    }

    public int hashCode() {
        return this.defaultHashCode();
    }

    public boolean equals(Object obj) {
        return this.defaultEquals(obj);
    }

    public String toString() {
        return this.defaultToString();
    }
}

