/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.pixelmon.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import de.waterdu.atlantis.AtlantisLogger;
import java.lang.reflect.Type;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;

public class PokemonTypeAdapter
implements JsonDeserializer<Pokemon>,
JsonSerializer<Pokemon> {
    public Pokemon deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String nbt = json.getAsString();
        try {
            return PokemonFactory.create((CompoundNBT)JsonToNBT.func_180713_a((String)nbt));
        }
        catch (CommandSyntaxException e) {
            AtlantisLogger.error("Failed to read Pok\u00e9mon data! json = {}", nbt);
            e.printStackTrace();
            return PokemonFactory.create((Species)((Species)PixelmonSpecies.MISSINGNO.getValueUnsafe()));
        }
    }

    public JsonElement serialize(Pokemon src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(src.writeToNBT(new CompoundNBT()).toString());
    }
}

