/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.pixelmon.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.api.AbstractSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import de.waterdu.atlantis.util.text.TextUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.item.ItemStack;

public class LazyPokemonSpecification {
    private static final Field REQUIREMENTS_FIELD;
    private final String specString;
    private PokemonSpecification spec = null;
    private Pokemon instance = null;
    private ItemStack sprite = null;
    private int requirementCount = -1;

    @Deprecated
    public LazyPokemonSpecification(String specString) {
        this.specString = specString;
    }

    public static LazyPokemonSpecification of(String ... specs) {
        return new LazyPokemonSpecification(TextUtils.concat(specs));
    }

    public PokemonSpecification getSpec() {
        if (this.spec == null) {
            this.spec = PokemonSpecificationProxy.create((String[])this.specString.split(" "));
        }
        return this.spec;
    }

    public int getRequirementCount() {
        if (this.requirementCount == -1) {
            try {
                List requirements = (List)REQUIREMENTS_FIELD.get(this.getSpec());
                this.requirementCount = requirements.size();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return this.requirementCount;
    }

    public Pokemon getInstance() {
        if (this.instance == null) {
            this.instance = this.getNewInstance();
        }
        return this.instance;
    }

    public Pokemon getNewInstance() {
        return PokemonFactory.create((PokemonSpecification)this.getSpec());
    }

    public ItemStack getSprite() {
        if (this.sprite == null) {
            this.sprite = SpriteItemHelper.getPhoto((Pokemon)this.getInstance());
        }
        return this.sprite.func_77946_l();
    }

    public boolean isValid() {
        return !this.specString.isEmpty() && this.getRequirementCount() > 0;
    }

    public String getSpecString() {
        return this.specString;
    }

    public int hashCode() {
        return this.specString.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LazyPokemonSpecification) {
            return this.specString.equalsIgnoreCase(((LazyPokemonSpecification)obj).specString);
        }
        if (obj instanceof PokemonSpecification) {
            return this.specString.equalsIgnoreCase(obj.toString());
        }
        return false;
    }

    public String toString() {
        return "LazyPokemonSpecification{" + this.specString + "}";
    }

    static {
        try {
            REQUIREMENTS_FIELD = AbstractSpecification.class.getDeclaredField("requirements");
            REQUIREMENTS_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TypeAdapter
    implements JsonSerializer<LazyPokemonSpecification>,
    JsonDeserializer<LazyPokemonSpecification> {
        public LazyPokemonSpecification deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return LazyPokemonSpecification.of(json.getAsString());
        }

        public JsonElement serialize(LazyPokemonSpecification src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getSpecString());
        }
    }
}

