/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.pixelmon.util;

import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.UUID;

public class EconomyUtils {
    private EconomyUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    private static <T> Optional<? extends BankAccount> getAccount(T player) {
        return PlayerReference.getSafely(player).flatMap(p -> BankAccountProxy.getBankAccount((UUID)p.uuid()));
    }

    public static <T> BigDecimal getBalance(T player) {
        return EconomyUtils.getAccount(player).map(BankAccount::getBalance).orElseGet(() -> {
            EconomyUtils.throwBankAccountError(player);
            return BigDecimal.ZERO;
        });
    }

    public static <T> boolean hasBalance(T player, long amount) {
        return EconomyUtils.getAccount(player).map(account -> account.hasBalance((float)amount)).orElseGet(() -> {
            EconomyUtils.throwBankAccountError(player);
            return false;
        });
    }

    public static <T> boolean hasBalance(T player, int amount) {
        return EconomyUtils.hasBalance(player, (long)amount);
    }

    public static <T> boolean addBalance(T player, long amount) {
        if (amount > 0L) {
            return EconomyUtils.getAccount(player).map(account -> account.add((float)amount)).orElseGet(() -> {
                EconomyUtils.throwBankAccountError(player);
                return false;
            });
        }
        return EconomyUtils.deductBalance(player, amount);
    }

    public static <T> boolean addBalance(T player, int amount) {
        return EconomyUtils.addBalance(player, (long)amount);
    }

    public static <T> boolean deductBalance(T player, long amount) {
        return EconomyUtils.getAccount(player).map(account -> account.hasBalance((float)amount) && account.take((float)amount)).orElseGet(() -> {
            EconomyUtils.throwBankAccountError(player);
            return false;
        });
    }

    public static <T> boolean deductBalance(T player, int amount) {
        return EconomyUtils.deductBalance(player, (long)amount);
    }

    public static <T> boolean setBalance(T player, long amount) {
        return EconomyUtils.getAccount(player).map(account -> {
            account.setBalance((float)amount);
            return true;
        }).orElseGet(() -> {
            EconomyUtils.throwBankAccountError(player);
            return false;
        });
    }

    public static <T> boolean setBalance(T player, int amount) {
        return EconomyUtils.setBalance(player, (long)amount);
    }

    private static <T> void throwBankAccountError(T player) {
        PlayerReference reference = PlayerReference.get(player);
        if (reference != null) {
            AtlantisLogger.error("Failed to fetch bank account for player {} ({})!", reference.uuid(), reference.name());
        } else {
            AtlantisLogger.error("Failed to fetch bank account for unknown player {}!", player.toString());
        }
    }
}

