/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.pixelmon.battle;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.BattleResults;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEndEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleStartedEvent;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelectionRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import de.waterdu.atlantis.pixelmon.battle.BattleListener;
import de.waterdu.atlantis.util.java.Pair;
import de.waterdu.atlantis.util.level.LazyLevel;
import de.waterdu.atlantis.util.level.Position;
import de.waterdu.atlantis.util.server.ServerUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Battle<A extends BattleParticipant, B extends BattleParticipant> {
    private final Class<A> aType;
    private final Class<B> bType;
    private final Predicate<A> aTest;
    private final Predicate<B> bTest;
    private final List<BattleListener<A, B>> listeners = Lists.newArrayList();
    private Either<Entity, PartyStorage> a = null;
    private Either<Entity, PartyStorage> b = null;
    private Position aPosition = null;
    private Position bPosition = null;
    private LazyLevel level = null;
    private boolean battleBuilderCreated = false;

    protected Battle(Class<A> aType, Class<B> bType, Predicate<A> aTest, Predicate<B> bTest) {
        this.aType = aType;
        this.bType = bType;
        this.aTest = aTest;
        this.bTest = bTest;
    }

    public Battle<A, B> listener(BattleListener<A, B> listener) {
        this.listeners.add(listener);
        return this;
    }

    public Battle<A, B> level(LazyLevel level) {
        this.level = level;
        return this;
    }

    public Battle<A, B> level(String key) {
        return this.level(LazyLevel.of(key));
    }

    public Battle<A, B> level(String mod, String key) {
        return this.level(LazyLevel.of(mod, key));
    }

    public Battle<A, B> level(ResourceLocation location) {
        return this.level(LazyLevel.of(location));
    }

    public Battle<A, B> level(RegistryKey<World> level) {
        return this.level(LazyLevel.of(level));
    }

    public Battle<A, B> level(World level) {
        return this.level(LazyLevel.of(level));
    }

    public Battle<A, B> participants(Entity a, Entity b) {
        return this.a(a).b(b);
    }

    public Battle<A, B> participants(PartyStorage a, Entity b) {
        return this.a(a).b(b);
    }

    public Battle<A, B> participants(Entity a, PartyStorage b) {
        return this.a(a).b(b);
    }

    public Battle<A, B> participants(PartyStorage a, PartyStorage b) {
        return this.a(a).b(b);
    }

    protected Battle<A, B> a(Entity a) {
        this.a = Either.left((Object)a);
        return this;
    }

    protected Battle<A, B> b(Entity b) {
        this.b = Either.left((Object)b);
        return this;
    }

    protected Battle<A, B> a(PartyStorage a) {
        this.a = Either.right((Object)a);
        return this;
    }

    protected Battle<A, B> b(PartyStorage b) {
        this.b = Either.right((Object)b);
        return this;
    }

    public Battle<A, B> positions(Position a, Position b) {
        this.aPosition = a;
        this.bPosition = b;
        return this;
    }

    public Battle<A, B> teleport() {
        if (this.aPosition != null && this.bPosition != null) {
            Entity a = null;
            Entity b = null;
            if (this.a.left().isPresent()) {
                a = (Entity)this.a.left().get();
            } else if (this.a.right().isPresent()) {
                a = ServerUtils.getPlayer(((PartyStorage)this.a.right().get()).uuid).orElse(null);
            }
            if (this.b.left().isPresent()) {
                b = (Entity)this.b.left().get();
            } else if (this.b.right().isPresent()) {
                b = ServerUtils.getPlayer(((PartyStorage)this.b.right().get()).uuid).orElse(null);
            }
            if (a != null && b != null) {
                if (this.level != null) {
                    this.aPosition.teleport(a, (World)this.level.getLevel());
                    this.bPosition.teleport(b, (World)this.level.getLevel());
                } else {
                    this.aPosition.teleport(a);
                    this.bPosition.teleport(b);
                }
            }
        }
        return this;
    }

    public TeamSelectionRegistry.Builder battle() {
        if (this.a == null || this.b == null) {
            throw new IllegalStateException("Null participants for Atlantis battle!");
        }
        this.battleBuilderCreated = true;
        TeamSelectionRegistry.Builder builder = TeamSelectionRegistry.builder();
        this.a.left().ifPresent(xva$0 -> builder.members(new Entity[]{xva$0}));
        this.a.right().ifPresent(xva$0 -> builder.members(new PartyStorage[]{xva$0}));
        this.b.left().ifPresent(xva$0 -> builder.members(new Entity[]{xva$0}));
        this.b.right().ifPresent(xva$0 -> builder.members(new PartyStorage[]{xva$0}));
        return builder.battleStartConsumer(this::onBattleStart);
    }

    protected void forwardBattleStartEvent(BattleStartedEvent.Post event) {
        if (!this.battleBuilderCreated) {
            this.onBattleStart(event.getBattleController());
        }
    }

    protected Optional<Pair<A, B>> checkBattle(BattleController battle) {
        if (battle.participants.size() != 2) {
            return Optional.empty();
        }
        BattleParticipant a = null;
        BattleParticipant b = null;
        for (BattleParticipant bp : battle.participants) {
            if (a == null && this.aType.isInstance(bp) && this.aTest.test(bp)) {
                a = bp;
                continue;
            }
            if (b != null || !this.bType.isInstance(bp) || !this.bTest.test(bp)) continue;
            b = bp;
        }
        if (a != null && b != null && !a.getAllies().contains(b)) {
            return Optional.of(Pair.of(a, b));
        }
        return Optional.empty();
    }

    protected void onBattleStart(BattleController battle) {
        this.checkBattle(battle).ifPresent(participants -> {
            this.teleport();
            BattleParticipant a = (BattleParticipant)participants.getA();
            BattleParticipant b = (BattleParticipant)participants.getB();
            Ticket.Start<BattleParticipant, BattleParticipant> ticket = new Ticket.Start<BattleParticipant, BattleParticipant>(a, b, battle.getTeam(a), battle.getTeam(b), battle);
            for (BattleListener<BattleParticipant, BattleParticipant> battleListener : this.listeners) {
                battleListener.onBattleStart(ticket);
            }
        });
    }

    protected void onBattleEnd(BattleEndEvent event, UUID uuid, List<UUID> toDeregister) {
        BattleController battle = event.getBattleController();
        this.checkBattle(battle).ifPresent(participants -> {
            BattleParticipant a = (BattleParticipant)participants.getA();
            BattleParticipant b = (BattleParticipant)participants.getB();
            Ticket.End<BattleParticipant, BattleParticipant> ticket = new Ticket.End<BattleParticipant, BattleParticipant>(a, b, battle.getTeam(a), battle.getTeam(b), battle, event);
            for (BattleListener<BattleParticipant, BattleParticipant> battleListener : this.listeners) {
                battleListener.onBattleEnd(ticket);
            }
            toDeregister.add(uuid);
        });
    }

    public static class Ticket<A extends BattleParticipant, B extends BattleParticipant> {
        private final A a;
        private final B b;
        private final List<BattleParticipant> aTeam;
        private final List<BattleParticipant> bTeam;
        private final BattleController battle;

        protected Ticket(A a, B b, List<BattleParticipant> aTeam, List<BattleParticipant> bTeam, BattleController battle) {
            this.a = a;
            this.b = b;
            this.aTeam = aTeam;
            this.bTeam = bTeam;
            this.battle = battle;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }

        public List<BattleParticipant> getATeam() {
            return this.aTeam;
        }

        public List<BattleParticipant> getBTeam() {
            return this.bTeam;
        }

        public BattleController getBattle() {
            return this.battle;
        }

        public static class End<A extends BattleParticipant, B extends BattleParticipant>
        extends Ticket<A, B> {
            private final Map<BattleParticipant, BattleResults> results;
            private final boolean abnormal;
            private final BattleEndCause cause;

            protected End(A a, B b, List<BattleParticipant> aTeam, List<BattleParticipant> bTeam, BattleController battle, BattleEndEvent event) {
                super(a, b, aTeam, bTeam, battle);
                this.abnormal = event.isAbnormal();
                this.cause = event.getCause();
                this.results = event.getResults();
            }

            public void execute(Consumer<A> aWins, Consumer<B> bWins, Consumer<A> aLoses, Consumer<B> bLoses, Consumer<A> aDraws, Consumer<B> bDraws) {
                Object a = this.getA();
                Object b = this.getB();
                switch (this.getAResults()) {
                    case VICTORY: {
                        aWins.accept(a);
                        break;
                    }
                    case DRAW: {
                        aDraws.accept(a);
                        break;
                    }
                    default: {
                        aLoses.accept(a);
                    }
                }
                switch (this.getBResults()) {
                    case VICTORY: {
                        bWins.accept(b);
                        break;
                    }
                    case DRAW: {
                        bDraws.accept(b);
                        break;
                    }
                    default: {
                        bLoses.accept(b);
                    }
                }
            }

            public BattleResults getAResults() {
                return this.results.get(this.getA());
            }

            public BattleResults getBResults() {
                return this.results.get(this.getB());
            }

            public Map<BattleParticipant, BattleResults> getResults() {
                return this.results;
            }

            public boolean isAbnormal() {
                return this.abnormal;
            }

            public BattleEndCause getCause() {
                return this.cause;
            }
        }

        public static class Start<A extends BattleParticipant, B extends BattleParticipant>
        extends Ticket<A, B> {
            protected Start(A a, B b, List<BattleParticipant> aTeam, List<BattleParticipant> bTeam, BattleController battle) {
                super(a, b, aTeam, bTeam, battle);
            }
        }
    }
}

