/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.pixelmon.battle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEndEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleStartedEvent;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import de.waterdu.atlantis.pixelmon.battle.Battle;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

public class AtlantisBattles {
    private static final Map<UUID, Battle<?, ?>> BATTLES = Maps.newConcurrentMap();

    private AtlantisBattles() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static <A extends BattleParticipant, B extends BattleParticipant> Battle<A, B> register(Class<A> aType, Class<B> bType, Predicate<A> aTest, Predicate<B> bTest) {
        return AtlantisBattles.register(aType, bType, aTest, bTest, null);
    }

    public static <A extends BattleParticipant, B extends BattleParticipant> Battle<A, B> register(Class<A> aType, Class<B> bType, Predicate<A> aTest, Predicate<B> bTest, AtomicReference<UUID> keyReference) {
        UUID key = UUID.randomUUID();
        Battle<A, B> battle = new Battle<A, B>(aType, bType, aTest, bTest);
        BATTLES.put(key, battle);
        if (keyReference != null) {
            keyReference.set(key);
        }
        return battle;
    }

    public static boolean deregister(UUID uuid) {
        return BATTLES.remove(uuid) != null;
    }

    public static <A extends BattleParticipant, B extends BattleParticipant> Optional<Battle<A, B>> get(UUID uuid) {
        return Optional.ofNullable(BATTLES.getOrDefault(uuid, null));
    }

    public static void onBattleStart(BattleStartedEvent.Post event) {
        for (Battle<?, ?> battle : BATTLES.values()) {
            battle.forwardBattleStartEvent(event);
        }
    }

    public static void onBattleEnd(BattleEndEvent event) {
        ArrayList toDeregister = Lists.newArrayList();
        for (Map.Entry<UUID, Battle<?, ?>> battle : BATTLES.entrySet()) {
            battle.getValue().onBattleEnd(event, battle.getKey(), toDeregister);
        }
        for (UUID uuid : toDeregister) {
            AtlantisBattles.deregister(uuid);
        }
    }
}

