/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.occasion;

import de.waterdu.atlantis.occasion.Occasion;
import de.waterdu.atlantis.occasion.OccasionManager;
import de.waterdu.atlantis.occasion.OccasionRecovery;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.java.Pair;
import de.waterdu.atlantis.util.level.LevelPosition;
import java.util.Optional;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class OccasionListener {
    public OccasionListener() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        boolean recover;
        PlayerReference reference = PlayerReference.get(event.getPlayer());
        Pair<Integer, LevelPosition> recovery = OccasionRecovery.pop(reference);
        Optional<Occasion> occasion = OccasionManager.getFor(reference);
        boolean bl = recover = recovery != null;
        if (recover && occasion.isPresent() && occasion.get().currentMoment.get() == recovery.getA().intValue()) {
            recover = false;
            occasion.get().teleportToStart(reference);
        }
        if (recover) {
            recovery.getB().teleport(reference);
        } else {
            OccasionManager.handleEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        OccasionManager.handleEvent((Event)event);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            OccasionManager.tick();
        }
    }
}

