/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.occasion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.waterdu.atlantis.occasion.Moment;
import de.waterdu.atlantis.occasion.OccasionManager;
import de.waterdu.atlantis.occasion.OccasionRecovery;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.java.EventHandler;
import de.waterdu.atlantis.util.java.Pair;
import de.waterdu.atlantis.util.java.interfaces.EventConsumer;
import de.waterdu.atlantis.util.level.LazyLevel;
import de.waterdu.atlantis.util.level.LevelPosition;
import de.waterdu.atlantis.util.level.Position;
import de.waterdu.atlantis.util.server.ServerUtils;
import de.waterdu.atlantis.util.text.MessageUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;

public class Occasion
extends EventHandler<Occasion> {
    public static final Occasion VOID = new Occasion(Util.field_240973_b_);
    protected final UUID uuid;
    protected final AtomicBoolean repeats;
    protected final AtomicLong tick;
    protected final List<PlayerReference> members;
    protected final Set<PlayerReference> memberSet;
    protected final List<Optional<Moment>> moments;
    protected final Map<UUID, Pair<Integer, Optional<Moment>>> momentMap;
    protected final AtomicInteger currentMoment;
    protected final Map<PlayerReference, Optional<LevelPosition>> specificRecoveryPositions;
    protected final AtomicReference<LevelPosition> recoveryPosition;
    protected final AtomicReference<Consumer<Occasion>> onComplete;
    protected final AtomicReference<BiConsumer<Long, Occasion>> onTick;
    protected final AtomicReference<BiConsumer<PlayerReference, Occasion>> onPlayerAdded;
    protected final AtomicReference<BiConsumer<PlayerReference, Occasion>> onPlayerRemoved;
    protected final AtomicReference<BiConsumer<PlayerReference, Occasion>> onPlayerChanged;

    private Occasion() {
        this(UUID.randomUUID());
    }

    private Occasion(UUID uuid) {
        this.uuid = uuid;
        this.repeats = new AtomicBoolean(false);
        this.tick = new AtomicLong(0L);
        this.members = Lists.newCopyOnWriteArrayList();
        this.memberSet = Sets.newHashSet();
        this.moments = Lists.newArrayList();
        this.momentMap = Maps.newHashMap();
        this.currentMoment = new AtomicInteger(0);
        this.specificRecoveryPositions = Maps.newHashMap();
        this.recoveryPosition = new AtomicReference<LevelPosition>(ServerUtils.getSpawnPoint());
        this.onComplete = new AtomicReference<Consumer<Occasion>>(occasion -> {});
        this.onTick = new AtomicReference<BiConsumer<Long, Occasion>>((tick, occasion) -> {});
        this.onPlayerAdded = new AtomicReference<BiConsumer<PlayerReference, Occasion>>((player, occasion) -> {});
        this.onPlayerRemoved = new AtomicReference<BiConsumer<PlayerReference, Occasion>>((player, occasion) -> {});
        this.onPlayerChanged = new AtomicReference<BiConsumer<PlayerReference, Occasion>>((player, occasion) -> {});
    }

    private Occasion init() {
        this.currentMoment().ifPresent(moment -> moment.onStart.get().accept((Moment)moment));
        return this;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public boolean repeats() {
        return this.repeats.get();
    }

    public void reset() {
        this.removeAllMembers();
        if (this.repeats()) {
            this.resetTick();
            this.currentMoment.set(0);
            this.specificRecoveryPositions.clear();
            for (Optional<Moment> moment : this.moments) {
                moment.ifPresent(Moment::reset);
            }
        }
    }

    public boolean active() {
        return !this.completed();
    }

    public boolean completed() {
        return this.currentMoment.get() >= this.moments.size();
    }

    public int addMembers(Object ... members) {
        AtomicInteger added = new AtomicInteger(0);
        for (Object member : members) {
            PlayerReference.getSafely(member).ifPresent(reference -> {
                if (!this.memberSet.contains(reference)) {
                    this.members.add((PlayerReference)reference);
                    this.memberSet.add((PlayerReference)reference);
                    this.onPlayerAdded.get().accept((PlayerReference)reference, this);
                    this.onPlayerChanged.get().accept((PlayerReference)reference, this);
                    this.currentMoment().ifPresent(moment -> {
                        moment.onPlayerAdded.get().accept((PlayerReference)reference, (Moment)moment);
                        moment.onPlayerChanged.get().accept((PlayerReference)reference, (Moment)moment);
                    });
                    added.getAndIncrement();
                }
            });
        }
        return added.get();
    }

    public boolean isMember(Object reference) {
        return PlayerReference.getSafely(reference).map(this.memberSet::contains).orElse(false);
    }

    @Override
    public boolean playerValid(PlayerEntity player) {
        return this.isMember(player);
    }

    public Moment addMoment(int index, Moment moment) {
        Optional<Moment> wrappedMoment = Optional.of(moment);
        this.moments.add(index, wrappedMoment);
        this.momentMap.put(moment.uuid(), Pair.of(index, wrappedMoment));
        return moment;
    }

    protected List<PlayerReference> membersDirect() {
        return this.members;
    }

    public void forEachMember(Consumer<PlayerReference> forEach) {
        for (PlayerReference reference : this.members) {
            forEach.accept(reference);
        }
    }

    public void forEachMember(Consumer<ServerPlayerEntity> forEach, Consumer<PlayerReference> orElse) {
        for (PlayerReference reference : this.members) {
            Optional<ServerPlayerEntity> player = reference.entity();
            if (player.isPresent()) {
                forEach.accept(player.get());
                continue;
            }
            if (orElse == null) continue;
            orElse.accept(reference);
        }
    }

    public <T> void send(T message) {
        MessageUtils.send(message, this.members);
    }

    public Optional<Moment> currentMoment() {
        return this.completed() ? Optional.empty() : this.moments.get(this.currentMomentOrdinal());
    }

    public int currentMomentOrdinal() {
        return this.currentMoment.get();
    }

    public Optional<Moment> moment(UUID uuid) {
        if (!this.momentMap.containsKey(uuid)) {
            return Optional.empty();
        }
        return this.momentMap.get(uuid).getB();
    }

    public Optional<Moment> moment(int ordinal) {
        if (ordinal < 0 || ordinal >= this.moments.size()) {
            return Optional.empty();
        }
        return this.moments.get(ordinal);
    }

    public int momentOrdinal(Moment moment) {
        if (!this.momentMap.containsKey(moment.uuid())) {
            return -1;
        }
        return this.momentMap.get(moment.uuid()).getA();
    }

    public boolean incrementMoment() {
        this.currentMoment().ifPresent(moment -> {
            moment.onEnd.get().accept((Moment)moment);
            moment.updateBossBar(ServerBossInfo::func_201360_b);
            this.forEachMember(member -> moment.updateIndividualBossBar((PlayerReference)member, ServerBossInfo::func_201360_b));
        });
        this.currentMoment.getAndIncrement();
        this.currentMoment().ifPresent(moment -> moment.onStart.get().accept((Moment)moment));
        boolean complete = this.completed();
        if (complete) {
            this.onComplete.get().accept(this);
            this.reset();
        }
        return complete;
    }

    public boolean gotoMoment(int index) {
        if (index < 0 || index >= this.momentCount()) {
            return false;
        }
        this.currentMoment().ifPresent(moment -> {
            moment.onEnd.get().accept((Moment)moment);
            moment.updateBossBar(ServerBossInfo::func_201360_b);
            this.forEachMember(member -> moment.updateIndividualBossBar((PlayerReference)member, ServerBossInfo::func_201360_b));
        });
        this.currentMoment.set(index);
        this.currentMoment().ifPresent(moment -> moment.onStart.get().accept((Moment)moment));
        return true;
    }

    public void complete() {
        this.currentMoment().ifPresent(moment -> {
            moment.onEnd.get().accept((Moment)moment);
            moment.updateBossBar(ServerBossInfo::func_201360_b);
            this.forEachMember(member -> moment.updateIndividualBossBar((PlayerReference)member, ServerBossInfo::func_201360_b));
        });
        this.currentMoment.set(this.momentCount());
        this.onComplete.get().accept(this);
        this.reset();
    }

    public boolean removeMember(PlayerReference reference) {
        boolean changed = this.members.remove(reference);
        if (changed) {
            this.memberSet.remove(reference);
            OccasionManager.removePlayer(reference);
            LevelPosition recovery = this.recoveryPosition(reference);
            OccasionRecovery.add(reference, -1, recovery);
            recovery.teleport(reference);
            this.onPlayerRemoved.get().accept(reference, this);
            this.onPlayerChanged.get().accept(reference, this);
            this.currentMoment().ifPresent(moment -> {
                moment.onPlayerRemoved.get().accept(reference, (Moment)moment);
                moment.onPlayerChanged.get().accept(reference, (Moment)moment);
                reference.entity().ifPresent(entity -> {
                    moment.updateBossBar(bar -> bar.func_186761_b(entity));
                    moment.updateIndividualBossBar(reference, bar -> bar.func_186761_b(entity));
                });
            });
        }
        return changed;
    }

    public void removeAllMembers() {
        for (PlayerReference reference : this.members) {
            this.memberSet.remove(reference);
            OccasionManager.removePlayer(reference);
            LevelPosition recovery = this.recoveryPosition(reference);
            OccasionRecovery.add(reference, -1, recovery);
            recovery.teleport(reference);
            this.onPlayerRemoved.get().accept(reference, this);
            this.onPlayerChanged.get().accept(reference, this);
            this.currentMoment().ifPresent(moment -> {
                moment.onPlayerRemoved.get().accept(reference, (Moment)moment);
                moment.onPlayerChanged.get().accept(reference, (Moment)moment);
                reference.entity().ifPresent(entity -> {
                    moment.updateBossBar(bar -> bar.func_186761_b(entity));
                    moment.updateIndividualBossBar(reference, bar -> bar.func_186761_b(entity));
                });
            });
            this.members.remove(reference);
        }
    }

    public int memberCount() {
        return this.memberSet.size();
    }

    public int momentCount() {
        return this.moments.size();
    }

    public void teleportToStart(PlayerReference reference) {
        this.currentMoment().map(moment -> moment.startPosition.get()).ifPresent(position -> position.teleport(reference));
    }

    public void teleportAllToStart() {
        this.currentMoment().map(moment -> moment.startPosition.get()).ifPresent(position -> {
            for (PlayerReference reference : this.membersDirect()) {
                position.teleport(reference);
            }
        });
    }

    public LevelPosition recoveryPosition(PlayerReference reference) {
        return this.specificRecoveryPositions.getOrDefault(reference, Optional.empty()).orElse(this.recoveryPosition.get());
    }

    public void setSpecificRecoveryPosition(PlayerReference reference, LevelPosition position) {
        this.specificRecoveryPositions.put(reference, Optional.of(position));
    }

    public void teleportToRecovery(PlayerReference reference) {
        this.recoveryPosition(reference).teleport(reference);
    }

    @Override
    public <E extends Event> void handleEvent(E event) {
        super.handleEvent(event);
        this.currentMoment().ifPresent(moment -> moment.handleEvent(event));
    }

    public void resetTick() {
        this.tick.set(0L);
    }

    public long currentTick() {
        return this.tick.get();
    }

    protected boolean tick() {
        if (!this.completed()) {
            this.tick.incrementAndGet();
            this.currentMoment().ifPresent(Moment::tick);
            this.onTick.get().accept(this.currentTick(), this);
            return false;
        }
        if (this.repeats()) {
            this.reset();
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Occasion)) {
            return false;
        }
        return this.uuid.equals(((Occasion)obj).uuid);
    }

    public String toString() {
        return "Occasion(" + this.uuid + ")";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Occasion occasion = new Occasion();

        private Builder() {
            this.defaultLoginLogoutHandlers();
        }

        public Moment.Builder newMoment() {
            return Moment.builder(this);
        }

        public Builder repeats() {
            this.occasion.repeats.set(true);
            return this;
        }

        public Builder single() {
            this.occasion.repeats.set(false);
            return this;
        }

        public Builder recoveryPosition(LazyLevel level, Position position) {
            return this.recoveryPosition(new LevelPosition(level, position));
        }

        public Builder recoveryPosition(LevelPosition position) {
            this.occasion.recoveryPosition.set(position);
            return this;
        }

        public <E extends Event> Builder eventHandler(Class<E> event, EventConsumer<E, Occasion> handler) {
            this.occasion.addEventHandler(event, handler);
            OccasionManager.registerEventHandlers(event);
            return this;
        }

        public <E extends Event> Builder clearEventHandlers(Class<E> event) {
            this.occasion.clearEventHandlers(event);
            return this;
        }

        public Builder defaultLoginLogoutHandlers() {
            return this.eventHandler(PlayerEvent.PlayerLoggedInEvent.class, (event, handler) -> handler.currentMoment().ifPresent(moment -> moment.logouts.put(PlayerReference.get(event.getPlayer()), -1L))).eventHandler(PlayerEvent.PlayerLoggedOutEvent.class, (event, handler) -> handler.currentMoment().ifPresent(moment -> moment.logouts.put(PlayerReference.get(event.getPlayer()), System.currentTimeMillis())));
        }

        public Builder noLoginLogoutHandlers() {
            return this.clearEventHandlers(PlayerEvent.PlayerLoggedInEvent.class).clearEventHandlers(PlayerEvent.PlayerLoggedOutEvent.class);
        }

        public Builder onComplete(Consumer<Occasion> onComplete) {
            this.occasion.onComplete.set(onComplete);
            return this;
        }

        public Builder onTick(BiConsumer<Long, Occasion> onTick) {
            this.occasion.onTick.set(onTick);
            return this;
        }

        public Builder onPlayerAdded(BiConsumer<PlayerReference, Occasion> onPlayerAdded) {
            this.occasion.onPlayerAdded.set(onPlayerAdded);
            return this;
        }

        public Builder onPlayerRemoved(BiConsumer<PlayerReference, Occasion> onPlayerRemoved) {
            this.occasion.onPlayerRemoved.set(onPlayerRemoved);
            return this;
        }

        public Builder onPlayerChanged(BiConsumer<PlayerReference, Occasion> onPlayerChanged) {
            this.occasion.onPlayerChanged.set(onPlayerChanged);
            return this;
        }

        public Occasion build() {
            return OccasionManager.add(this.occasion).init();
        }
    }
}

