/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.occasion;

import com.google.common.collect.Maps;
import de.waterdu.atlantis.occasion.Occasion;
import de.waterdu.atlantis.occasion.OccasionManager;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.java.EventHandler;
import de.waterdu.atlantis.util.java.interfaces.EventConsumer;
import de.waterdu.atlantis.util.level.LazyLevel;
import de.waterdu.atlantis.util.level.LevelPosition;
import de.waterdu.atlantis.util.level.Position;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.eventbus.api.Event;

public class Moment
extends EventHandler<Moment> {
    public static final Moment VOID = new Moment(Occasion.VOID);
    protected final Occasion occasion;
    protected final UUID uuid;
    protected final AtomicLong tick;
    protected final AtomicLong duration;
    protected final AtomicLong timeout;
    protected final Map<PlayerReference, Long> logouts;
    protected final AtomicReference<LevelPosition> startPosition;
    protected final AtomicReference<ServerBossInfo> header;
    protected final Map<PlayerReference, ServerBossInfo> individualHeaders;
    protected final AtomicReference<Consumer<Moment>> onStart;
    protected final AtomicReference<Consumer<Moment>> onEnd;
    protected final AtomicReference<BiConsumer<Long, Moment>> onTick;
    protected final AtomicReference<BiConsumer<PlayerReference, Moment>> onPlayerAdded;
    protected final AtomicReference<BiConsumer<PlayerReference, Moment>> onPlayerRemoved;
    protected final AtomicReference<BiConsumer<PlayerReference, Moment>> onPlayerChanged;

    private Moment(Occasion occasion) {
        this.occasion = occasion;
        this.uuid = UUID.randomUUID();
        this.tick = new AtomicLong(0L);
        this.duration = new AtomicLong(100L);
        this.timeout = new AtomicLong(0L);
        this.logouts = Maps.newHashMap();
        this.startPosition = new AtomicReference();
        this.header = new AtomicReference();
        this.individualHeaders = Maps.newHashMap();
        this.onStart = new AtomicReference<Consumer<Moment>>(moment -> {});
        this.onEnd = new AtomicReference<Consumer<Moment>>(moment -> {});
        this.onTick = new AtomicReference<BiConsumer<Long, Moment>>((tick, moment) -> {});
        this.onPlayerAdded = new AtomicReference<BiConsumer<PlayerReference, Moment>>((player, moment) -> {});
        this.onPlayerRemoved = new AtomicReference<BiConsumer<PlayerReference, Moment>>((player, moment) -> {});
        this.onPlayerChanged = new AtomicReference<BiConsumer<PlayerReference, Moment>>((player, moment) -> {});
    }

    public static Moment create(Occasion occasion) {
        return new Moment(occasion);
    }

    public Occasion occasion() {
        return this.occasion;
    }

    @Override
    public boolean playerValid(PlayerEntity player) {
        return this.occasion().isMember(player);
    }

    public UUID uuid() {
        return this.uuid;
    }

    public int ordinal() {
        return this.occasion().momentOrdinal(this);
    }

    public long duration() {
        return this.duration.get();
    }

    public void reset() {
        this.resetTick();
        this.logouts.clear();
        ServerBossInfo header = this.header.get();
        if (header != null) {
            header.func_201360_b();
        }
        this.header.set(null);
    }

    public void updateBossBar(Consumer<ServerBossInfo> consumer) {
        if (this.header.get() == null) {
            this.header.set(new ServerBossInfo((ITextComponent)new StringTextComponent(""), BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS));
            this.occasion().forEachMember(player -> player.entity().ifPresent(entity -> this.header.get().func_186760_a(entity)));
        }
        consumer.accept(this.header.get());
    }

    public void updateIndividualBossBar(PlayerReference reference, Consumer<ServerBossInfo> consumer) {
        consumer.accept(this.individualHeaders.computeIfAbsent(reference, key -> {
            ServerBossInfo sbi = new ServerBossInfo((ITextComponent)new StringTextComponent(""), BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS);
            reference.entity().ifPresent(arg_0 -> ((ServerBossInfo)sbi).func_186760_a(arg_0));
            return sbi;
        }));
    }

    public void resetTick() {
        this.tick.set(0L);
    }

    public long currentTick() {
        return this.tick.get();
    }

    public boolean exceededDuration() {
        return this.currentTick() >= this.duration();
    }

    protected void tick() {
        this.tick.incrementAndGet();
        long timeout = System.currentTimeMillis() - this.timeout.get();
        for (PlayerReference reference : this.occasion().membersDirect()) {
            long logout = this.logouts.getOrDefault(reference, -1L);
            if (logout <= 0L || logout >= timeout) continue;
            this.occasion().removeMember(reference);
            this.logouts.put(reference, -1L);
        }
        this.onTick.get().accept(this.currentTick(), this);
    }

    protected static Builder builder(Occasion.Builder occasion) {
        return new Builder(occasion);
    }

    public static class Builder {
        private final Occasion.Builder parent;
        private final Moment moment;

        private Builder(Occasion.Builder parent) {
            this.parent = parent;
            this.moment = Moment.create(this.parent.build());
        }

        public Builder duration(long duration) {
            this.moment.duration.set(duration);
            return this;
        }

        public Builder timeout(long timeout) {
            this.moment.timeout.set(timeout);
            return this;
        }

        public Builder startPosition(LazyLevel level, Position position) {
            return this.startPosition(new LevelPosition(level, position));
        }

        public Builder startPosition(LevelPosition position) {
            this.moment.startPosition.set(position);
            return this;
        }

        public <E extends Event> Builder eventHandler(Class<E> event, EventConsumer<E, Moment> handler) {
            this.moment.addEventHandler(event, handler);
            OccasionManager.registerEventHandlers(event);
            return this;
        }

        public Builder onStart(Consumer<Moment> onStart) {
            this.moment.onStart.set(onStart);
            return this;
        }

        public Builder onEnd(Consumer<Moment> onEnd) {
            this.moment.onEnd.set(onEnd);
            return this;
        }

        public Builder onTick(BiConsumer<Long, Moment> onTick) {
            this.moment.onTick.set(onTick);
            return this;
        }

        public Builder onPlayerAdded(BiConsumer<PlayerReference, Moment> onPlayerAdded) {
            this.moment.onPlayerAdded.set(onPlayerAdded);
            return this;
        }

        public Builder onPlayerRemoved(BiConsumer<PlayerReference, Moment> onPlayerRemoved) {
            this.moment.onPlayerRemoved.set(onPlayerRemoved);
            return this;
        }

        public Builder onPlayerChanged(BiConsumer<PlayerReference, Moment> onPlayerChanged) {
            this.moment.onPlayerChanged.set(onPlayerChanged);
            return this;
        }

        public Occasion.Builder build() {
            return this.build(this.moment.occasion().momentCount());
        }

        public Occasion.Builder build(int index) {
            this.moment.occasion().addMoment(index, this.moment);
            return this.parent;
        }
    }
}

