/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.network;

import de.waterdu.atlantis.network.PacketInterceptWrapper;
import de.waterdu.atlantis.util.entity.PlayerReference;
import java.util.function.Consumer;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDirection;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public class PacketInterceptEvent
extends Event {
    private final NetworkManager network;
    private final PlayerReference reference;
    private IPacket<?> packet;
    private boolean packetChanged = false;

    public PacketInterceptEvent(NetworkManager network, PlayerReference reference, IPacket<?> packet) {
        this.network = network;
        this.reference = reference;
        this.packet = packet;
    }

    public NetworkManager getNetwork() {
        return this.network;
    }

    public PlayerReference getReference() {
        return this.reference;
    }

    public PacketDirection getDirection() {
        return this.getNetwork().getDirection();
    }

    public boolean isClientbound() {
        return this.getDirection() == PacketDirection.CLIENTBOUND;
    }

    public boolean isServerbound() {
        return this.getDirection() == PacketDirection.SERVERBOUND;
    }

    public <T extends IPacket<?>> void castPacket(Class<T> type, Consumer<T> ifIs) {
        if (type.isInstance(this.getPacket())) {
            ifIs.accept(this.getPacket());
        }
    }

    public IPacket<?> getPacket() {
        return this.packet;
    }

    public void setPacket(IPacket<?> packet) {
        this.packet = new PacketInterceptWrapper(packet);
        this.packetChanged = true;
    }

    public boolean isPacketChanged() {
        return this.packetChanged;
    }
}

