/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.meta;

import de.waterdu.atlantis.ui.api.Button;
import de.waterdu.atlantis.ui.api.ClickData;
import de.waterdu.atlantis.ui.api.Decorations;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.ui.api.PageOptions;
import de.waterdu.atlantis.ui.internal.Buttons;
import de.waterdu.atlantis.util.entity.PlayerReference;
import java.util.Set;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class PageEvent
extends Event {
    private final PlayerReference player;
    private final Page page;

    private PageEvent(PlayerReference player, Page page) {
        this.player = player;
        this.page = page;
    }

    public PlayerReference getPlayer() {
        return this.player;
    }

    public Page getPage() {
        return this.page;
    }

    @Cancelable
    public static class Press
    extends PageEvent {
        private final Button button;
        private final ClickData clickData;

        public Press(PlayerReference player, Page page, Button button, ClickData clickData) {
            super(player, page);
            this.button = button;
            this.clickData = clickData;
        }

        public Button getButton() {
            return this.button;
        }

        public ClickData getClickData() {
            return this.clickData;
        }
    }

    @Cancelable
    public static class Destruct
    extends PageEvent {
        public Destruct(PlayerReference player, Page page) {
            super(player, page);
        }
    }

    @Cancelable
    public static class Decorate
    extends PageEvent {
        private final Decorations instance;
        private Set<Button> decorations;

        public Decorate(PlayerReference player, Page page, Decorations instance, Set<Button> decorations) {
            super(player, page);
            this.instance = instance;
            this.decorations = decorations;
        }

        public Decorations getInstance() {
            return this.instance;
        }

        public Set<Button> getDecorations() {
            return this.decorations;
        }

        public void addDecoration(Button button) {
            this.decorations.add(button);
        }

        public void setDecorations(Set<Button> decorations) {
            this.decorations = decorations;
        }
    }

    @Cancelable
    public static class Construct
    extends PageEvent {
        private Buttons buttons;
        private PageOptions options;

        public Construct(PlayerReference player, Page page, Buttons buttons, PageOptions options) {
            super(player, page);
            this.buttons = buttons;
            this.options = options;
        }

        public Buttons getButtons() {
            return this.buttons;
        }

        public void setButtons(Buttons buttons) {
            this.buttons = buttons;
        }

        public void addButton(Button button) {
            this.buttons.setButton(button.getIndex(), button.getPage(), button);
        }

        public PageOptions getOptions() {
            return this.options;
        }

        public void setOptions(PageOptions options) {
            this.options = options;
        }
    }
}

