/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.meta;

import de.waterdu.atlantis.file.ClassHolder;
import de.waterdu.atlantis.file.Config;
import de.waterdu.atlantis.file.datatypes.Configuration;
import de.waterdu.atlantis.file.storage.Storage;
import net.minecraftforge.eventbus.api.Event;

public abstract class ConfigEvent<T extends Configuration>
extends Event {
    private final Config<T> config;

    private ConfigEvent(Config<T> config) {
        this.config = config;
    }

    public Config<T> getConfig() {
        return this.config;
    }

    public static class Delete<T extends Configuration>
    extends ConfigEvent<T> {
        private final T object;

        public Delete(Config<T> config, T object) {
            super(config);
            this.object = object;
        }

        public T getObject() {
            return this.object;
        }
    }

    public static class Write<T extends Configuration>
    extends ConfigEvent<T> {
        private final T object;

        public Write(Config<T> config, T object) {
            super(config);
            this.object = object;
        }

        public T getObject() {
            return this.object;
        }
    }

    public static class Read<T extends Configuration>
    extends ConfigEvent<T> {
        private final T object;

        public Read(Config<T> config, T object) {
            super(config);
            this.object = object;
        }

        public T getObject() {
            return this.object;
        }
    }

    public static class Register<T extends Configuration>
    extends ConfigEvent<T> {
        private final String modID;
        private String path;
        private final ClassHolder<T> classes;
        private final T instance;
        private final Storage storage;

        public Register(Config<T> config, String path) {
            super(config);
            this.modID = config.getOwner();
            this.path = path;
            this.classes = config.getClasses();
            this.instance = config.get();
            this.storage = config.getStorage();
        }

        public String getModID() {
            return this.modID;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public ClassHolder<T> getClasses() {
            return this.classes;
        }

        public T getInstance() {
            return this.instance;
        }

        public Storage getStorage() {
            return this.storage;
        }
    }
}

