/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file.typeadapters;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import de.waterdu.atlantis.util.java.CompactJsonArrayList;
import de.waterdu.atlantis.util.java.JsonUtils;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class NumberListTypeAdapter<T extends Number>
implements JsonSerializer<List<T>>,
JsonDeserializer<List<T>> {
    protected static final Set<Class<?>> CARDINALS = Sets.newHashSet((Object[])new Class[]{Integer.class, Short.class, Byte.class, Long.class, BigInteger.class, AtomicInteger.class, AtomicLong.class});
    public static final NumberListTypeAdapter<Integer> INTEGER = new NumberListTypeAdapter<Integer>(Integer.class, Integer::parseInt, Long::intValue, String::valueOf);
    public static final NumberListTypeAdapter<Long> LONG = new NumberListTypeAdapter<Long>(Long.class, Long::parseLong, ___ -> ___, String::valueOf);
    public static final NumberListTypeAdapter<Short> SHORT = new NumberListTypeAdapter<Short>(Short.class, Short::parseShort, Long::shortValue, String::valueOf);
    public static final NumberListTypeAdapter<Byte> BYTE = new NumberListTypeAdapter<Byte>(Byte.class, Byte::parseByte, Long::byteValue, String::valueOf);
    public static final NumberListTypeAdapter<BigInteger> BIG_INTEGER = new NumberListTypeAdapter<BigInteger>(BigInteger.class, s -> BigInteger.valueOf(Long.parseLong(s)), BigInteger::valueOf, String::valueOf);
    public static final NumberListTypeAdapter<AtomicInteger> ATOMIC_INTEGER = new NumberListTypeAdapter<AtomicInteger>(AtomicInteger.class, s -> new AtomicInteger(Integer.parseInt(s)), l -> new AtomicInteger(l.intValue()), a -> String.valueOf(a.get()));
    public static final NumberListTypeAdapter<AtomicLong> ATOMIC_LONG = new NumberListTypeAdapter<AtomicLong>(AtomicLong.class, s -> new AtomicLong(Long.parseLong(s)), AtomicLong::new, a -> String.valueOf(a.get()));
    private final Class<T> type;
    private final Function<String, T> decoder;
    private final Function<Long, T> converter;
    private final Function<T, String> encoder;
    private final boolean cardinal;
    private final TypeToken<?> typeToken;

    public NumberListTypeAdapter(Class<T> type, Function<String, T> decoder, Function<Long, T> converter, Function<T, String> encoder) {
        this.type = type;
        this.decoder = decoder;
        this.converter = converter;
        this.encoder = encoder;
        this.cardinal = CARDINALS.contains(type);
        this.typeToken = TypeToken.getParameterized(List.class, (Type[])new Type[]{type});
    }

    public TypeToken<?> getTypeToken() {
        return this.typeToken;
    }

    public Type getType() {
        return this.getTypeToken().getType();
    }

    public List<T> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonArray()) {
            return JsonUtils.deserializeList(json.getAsJsonArray(), element -> (Number)context.deserialize(element, this.type));
        }
        if (json.isJsonPrimitive()) {
            String value = json.getAsString();
            String[] array = value.split(",");
            CompactJsonArrayList<T> values = new CompactJsonArrayList<T>(array.length);
            for (String s : array) {
                try {
                    if (this.cardinal && s.contains("-")) {
                        String[] r = s.split("-");
                        for (long i = ((Number)this.decoder.apply(r[0])).longValue(); i <= ((Number)this.decoder.apply(r[1])).longValue(); ++i) {
                            values.add(this.converter.apply(i));
                        }
                        continue;
                    }
                    values.add(this.decoder.apply(s));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return values;
        }
        return Lists.newArrayList();
    }

    public JsonElement serialize(List<T> src, Type typeOfSrc, JsonSerializationContext context) {
        if (src instanceof CompactJsonArrayList) {
            src.sort(null);
            StringBuilder builder = new StringBuilder();
            long check = 0L;
            boolean range = false;
            for (Number i : src) {
                if (builder.length() == 0) {
                    check = i.longValue();
                    builder.append(this.encoder.apply(i));
                    continue;
                }
                if (this.cardinal && i.longValue() == check + 1L) {
                    range = true;
                    check = i.longValue();
                    continue;
                }
                if (range) {
                    builder.append("-").append(check);
                    range = false;
                }
                builder.append(",").append(this.encoder.apply(i));
            }
            if (range) {
                builder.append("-").append(check);
            }
            return new JsonPrimitive(builder.toString());
        }
        return JsonUtils.serializeList(src, JsonPrimitive::new);
    }
}

