/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file.storage;

import com.google.gson.Gson;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.file.AtlantisConfigProxy;
import de.waterdu.atlantis.file.ClassHolder;
import de.waterdu.atlantis.file.Config;
import de.waterdu.atlantis.file.datatypes.Configuration;
import de.waterdu.atlantis.file.datatypes.PlayerData;
import de.waterdu.atlantis.util.server.ServerUtils;
import java.io.File;
import java.io.InvalidClassException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;

public interface Storage {
    public <T extends Configuration> void init(Config<T> var1, String var2, String var3, String var4, Gson var5, T var6, ClassHolder<T> var7) throws InvalidClassException, NoSuchFieldException, SQLException;

    public <T extends Configuration> void destruct(Config<T> var1);

    public <T extends Configuration> CompletableFuture<Boolean> write(Config<T> var1);

    public <T extends Configuration> CompletableFuture<Boolean> writeSpecific(Config<T> var1, T var2) throws InterruptedException;

    public <T extends Configuration> CompletableFuture<Boolean> read(Config<T> var1, boolean var2);

    public <T extends Configuration> CompletableFuture<Boolean> readAll(Config<T> var1, File var2, Set<String> var3);

    public <T extends Configuration> CompletableFuture<T> readFromUUID(Config<T> var1, UUID var2);

    public <T extends Configuration> CompletableFuture<T> readFromName(Config<T> var1, String var2);

    public <T extends Configuration> CompletableFuture<T> delete(Config<T> var1, T var2);

    public <T extends Configuration> CompletableFuture<T> deleteFromUUID(Config<T> var1, UUID var2);

    public <T extends Configuration> CompletableFuture<T> deleteFromName(Config<T> var1, String var2);

    default public <T extends Configuration> CompletableFuture<T> readFromPlayer(Config<T> config, PlayerEntity player) {
        return this.readFromUUID(config, player.func_110124_au());
    }

    default public <T extends Configuration> CompletableFuture<T> deleteFromPlayer(Config<T> config, PlayerEntity player) {
        return this.deleteFromUUID(config, player.func_110124_au());
    }

    default public <T extends Configuration> void onPlayerJoin(Config<T> config, ServerPlayerEntity player) {
        if (Settings.getSettings().getPlayerDataInvalidation().passes(config)) {
            config.invalidate((PlayerEntity)player);
        }
        Optional clazzOpt = config.getClasses().getPlayerDataClass();
        clazzOpt.ifPresent(clazz -> AtlantisConfigProxy.of(config.getOwner()).getFor(clazz, player.func_110124_au()).whenComplete((data, err) -> {
            if (data == null) {
                config.getClasses().getPlayerDataConstructor().ifPresent(constructor -> {
                    try {
                        PlayerData newData = (PlayerData)constructor.newInstance(player);
                        AtlantisConfigProxy.of(config.getOwner()).put(clazz, newData);
                        config.getClasses().invokeLoginCallback(config, newData, player);
                        newData.save();
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        AtlantisLogger.warn("No valid ServerPlayerEntity constructor for data " + config.getName(), new Object[0]);
                    }
                });
            } else {
                config.getClasses().invokeLoginCallback(config, (PlayerData)data, player);
            }
        }));
    }

    default public <T extends Configuration> void onPlayerLeave(Config<T> config, ServerPlayerEntity player) {
        Optional clazzOpt = config.getClasses().getPlayerDataClass();
        clazzOpt.ifPresent(clazz -> AtlantisConfigProxy.of(config.getOwner()).getFor(clazz, player.func_110124_au()).whenComplete((data, err) -> {
            if (data != null) {
                config.getClasses().invokeLogoutCallback(config, (PlayerData)data, player);
                if (config.markSaved(data.getUUID())) {
                    try {
                        this.writeSpecific(config, data).whenComplete((result, err2) -> {
                            if (Settings.getSettings().getPlayerDataInvalidation().passes(config)) {
                                config.invalidate(data);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        AtlantisLogger.error("Failed to save instance of " + config.getName() + " called " + data.getUniqueName() + " with UUID " + data.getUUID() + "!", new Object[0]);
                    }
                } else if (Settings.getSettings().getPlayerDataInvalidation().passes(config)) {
                    config.invalidate(data);
                }
            }
        }));
    }

    default public boolean isServerAlive() {
        MinecraftServer server = ServerUtils.getServer();
        return server == null || server.func_71278_l() && !server.func_71241_aa();
    }
}

