/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file.storage;

import com.google.gson.Gson;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.file.AonCommenter;
import de.waterdu.atlantis.file.AtlantisConfig;
import de.waterdu.atlantis.file.ClassHolder;
import de.waterdu.atlantis.file.Config;
import de.waterdu.atlantis.file.datatypes.Configuration;
import de.waterdu.atlantis.file.datatypes.NamedData;
import de.waterdu.atlantis.file.storage.Storage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;

public class Flatfile
implements Storage {
    private static final File ERROR_BIN = new File(AtlantisConfig.getDir("atlantis") + File.separator + "bin");
    private File file;
    private File jsonFile = null;
    private Config<? extends Configuration> config;

    @Override
    public <T extends Configuration> void init(Config<T> config, String modID, String key, String path, Gson gson, T configuration, ClassHolder<T> classes) {
        this.config = config;
        if (path.contains(".")) {
            this.file = new File(AtlantisConfig.getDir(modID), path);
            if (config.isAON()) {
                this.jsonFile = new File(AtlantisConfig.getDir(modID), path.split("\\.")[0] + ".json");
            }
        } else {
            this.file = new File(AtlantisConfig.getDir(modID) + File.separator + path);
            if (this.file.mkdir()) {
                AtlantisLogger.info("Creating new directory for {}.", config.getName());
            }
        }
    }

    @Override
    public <T extends Configuration> void destruct(Config<T> config) {
    }

    @Override
    public <T extends Configuration> CompletableFuture<Boolean> write(Config<T> config) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!this.isServerAlive()) {
            result.complete(false);
            return result;
        }
        if (config.getConfigurationContainer().isData()) {
            long delay = Settings.getSettings().getDataSaveDelay();
            for (Configuration out : config.getUUIDDataMap().values()) {
                if (out == null) continue;
                config.getProcessCount().incrementAndGet();
                Atlantis.THREAD_POOL.schedule(() -> {
                    try {
                        this.writeSpecific(config, out);
                    }
                    catch (InterruptedException e) {
                        AtlantisLogger.error("Failed to save instance of {} called {} with UUID {}!", config.getName(), out.getUniqueName(), out.getUUID());
                    }
                    if (config.getProcessCount().decrementAndGet() == 0) {
                        result.complete(true);
                        AtlantisLogger.info("Successfully saved {}.", config.getName());
                    }
                }, delay);
                delay += Settings.getSettings().getDataSaveDelay();
            }
        } else {
            Atlantis.THREAD_POOL.submit(() -> {
                try {
                    File file = this.file;
                    if (file.createNewFile()) {
                        AtlantisLogger.info("Creating new file for {}.", config.getName());
                        if (this.config.isAON() && this.jsonFile.exists()) {
                            file = this.jsonFile;
                        }
                    }
                    String json = AonCommenter.comment(config, config.getGson().toJson(config.getConfigurationContainer().get()), config.getClasses().getConfigurationClass());
                    try (FileOutputStream fs = new FileOutputStream(file);
                         OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fs, StandardCharsets.UTF_8);
                         BufferedWriter bw = new BufferedWriter(ow);){
                        bw.write(json);
                    }
                    if (this.config.isAON() && this.jsonFile.exists() && this.jsonFile.delete()) {
                        AtlantisLogger.info("Deleted old JSON file of {}.", config.getName());
                    }
                    AtlantisLogger.info("Successfully saved {}.", config.getName());
                    config.remapLang();
                    result.complete(true);
                }
                catch (Exception e) {
                    AtlantisLogger.error("Failed to save {}!", config.getName());
                    e.printStackTrace();
                    result.complete(false);
                }
            });
        }
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<Boolean> writeSpecific(Config<T> config, T data) throws InterruptedException {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!this.isServerAlive()) {
            result.complete(false);
            return result;
        }
        Atlantis.THREAD_POOL.submit(() -> {
            block46: {
                try {
                    File temp;
                    File output = this.resolveFile(config, data);
                    if (!output.getParentFile().exists()) {
                        output.getParentFile().mkdirs();
                    }
                    if (!(temp = new File(output.getPath() + ".temp")).createNewFile()) {
                        AtlantisLogger.debug("Temp file already exists called {} for file {}, delaying save attempt.", config.getName(), data.getUniqueName());
                        Files.deleteIfExists(temp.toPath());
                        Atlantis.THREAD_POOL.schedule(() -> {
                            try {
                                this.writeSpecific(config, data);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }, Settings.getSettings().getDuplicateSaveDelay(), TimeUnit.MILLISECONDS);
                        return;
                    }
                    if (output.createNewFile()) {
                        AtlantisLogger.info("Creating new instance of {} for file {}.", config.getName(), data.getUniqueName());
                    }
                    if (temp.exists()) {
                        String json = config.getGson().toJson((Object)data);
                        try (FileOutputStream fs = new FileOutputStream(temp);
                             OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fs, StandardCharsets.UTF_8);
                             BufferedWriter bw = new BufferedWriter(ow);){
                            bw.write(json);
                        }
                        if (temp.exists()) {
                            if (output.exists()) {
                                output.delete();
                            }
                            temp.renameTo(output);
                            result.complete(true);
                        } else {
                            Atlantis.THREAD_POOL.schedule(() -> {
                                try {
                                    this.writeSpecific(config, data);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }, Settings.getSettings().getDuplicateSaveDelay(), TimeUnit.MILLISECONDS);
                            result.complete(false);
                        }
                        break block46;
                    }
                    Atlantis.THREAD_POOL.schedule(() -> {
                        try {
                            this.writeSpecific(config, data);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }, Settings.getSettings().getDuplicateSaveDelay(), TimeUnit.MILLISECONDS);
                    result.complete(false);
                }
                catch (Exception e) {
                    AtlantisLogger.error("Failed to save instance of {} for file {}.", config.getName(), data.getUniqueName());
                    e.printStackTrace();
                    result.complete(false);
                }
            }
        });
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<Boolean> read(Config<T> config, boolean skipNulls) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!this.isServerAlive()) {
            result.complete(false);
            return result;
        }
        if (config.getConfigurationContainer().isData()) {
            if (!config.getConfigurationContainer().isPlayerData()) {
                config.getProcessCount().incrementAndGet();
            }
            HashSet<String> filenames = new HashSet<String>(config.getFilenameDataMap().keySet());
            config.clearAll();
            Atlantis.THREAD_POOL.submit(() -> this.readAll(config, this.file, filenames).whenComplete((r, err) -> {
                this.cleanFolder(config, this.file);
                AtlantisLogger.info("Successfully read " + config.getName() + ".", new Object[0]);
                if (!config.getConfigurationContainer().isPlayerData()) {
                    config.getProcessCount().decrementAndGet();
                }
                result.complete(true);
            }));
        } else {
            Atlantis.THREAD_POOL.submit(() -> {
                boolean written = false;
                File file = this.file;
                try {
                    if (file.createNewFile()) {
                        AtlantisLogger.info("Creating new file for {}.", config.getName());
                        if (this.config.isAON() && this.jsonFile.exists()) {
                            file = this.jsonFile;
                        }
                    }
                    try (FileInputStream fs = new FileInputStream(file);
                         InputStreamReader ir = new InputStreamReader((InputStream)fs, StandardCharsets.UTF_8);
                         BufferedReader br = new BufferedReader(ir);){
                        String json = AonCommenter.uncomment(config, IOUtils.toString((Reader)br), config.getClasses().getConfigurationClass());
                        Configuration configuration = (Configuration)config.getGson().fromJson(json, config.getClasses().getConfigurationClass());
                        if (configuration != null || !skipNulls) {
                            config.getConfigurationContainer().set(config, configuration);
                            written = true;
                        }
                    }
                    AtlantisLogger.info("Successfully read {}.", config.getName());
                    config.remapLang();
                    result.complete(written);
                }
                catch (Exception e) {
                    AtlantisLogger.error("Failed to read {}!", config.getName());
                    e.printStackTrace();
                    this.markAsError(config, file);
                    result.complete(false);
                }
            });
        }
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<Boolean> readAll(Config<T> config, File dir, Set<String> names) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!this.isServerAlive()) {
            result.complete(false);
            return result;
        }
        File[] dirs = dir.listFiles();
        if (dirs != null) {
            for (File file : dirs) {
                if (file == null) continue;
                if (file.isFile() && !file.getName().endsWith(".invalid")) {
                    try {
                        if (!this.isServerAlive()) continue;
                        try (FileInputStream fs = new FileInputStream(file);
                             InputStreamReader ir = new InputStreamReader((InputStream)fs, StandardCharsets.UTF_8);
                             BufferedReader br = new BufferedReader(ir);){
                            Configuration in = (Configuration)config.getGson().fromJson((Reader)br, config.getClasses().getConfigurationClass());
                            config.putUnsafe(in, false);
                            if (names.isEmpty() || names.contains(in.getUniqueName() + config.getDataFileExtension())) continue;
                            this.writeSpecific(config, in);
                        }
                    }
                    catch (Exception e) {
                        AtlantisLogger.error("Failed to read {} for file {}!", config.getName(), file.getName());
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.readAll(config, file, names);
            }
        }
        result.complete(true);
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<T> readFromUUID(Config<T> config, UUID uuid) {
        CompletableFuture<Configuration> result = new CompletableFuture<Configuration>();
        if (!this.isServerAlive()) {
            result.complete(null);
            return result;
        }
        if (config.getConfigurationContainer().isData()) {
            File file = new File(this.file, uuid.toString() + config.getDataFileExtension());
            if (file.exists() && !file.getName().endsWith(".invalid")) {
                try (FileInputStream fs = new FileInputStream(file);
                     InputStreamReader ir = new InputStreamReader((InputStream)fs, StandardCharsets.UTF_8);
                     BufferedReader br = new BufferedReader(ir);){
                    Configuration in = (Configuration)config.getGson().fromJson((Reader)br, config.getClasses().getConfigurationClass());
                    config.putUnsafe(in, false);
                    result.complete(in);
                }
                catch (Exception e) {
                    AtlantisLogger.error("Failed to read {} for file {}!", config.getName(), file.getName());
                    this.markAsError(config, file);
                    e.printStackTrace();
                    result.complete(null);
                }
            } else {
                result.complete(null);
            }
        } else {
            result.complete(null);
        }
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<T> readFromName(Config<T> config, String name) {
        CompletableFuture<Configuration> result = new CompletableFuture<Configuration>();
        if (!this.isServerAlive()) {
            result.complete(null);
            return result;
        }
        if (config.getConfigurationContainer().isNamedData()) {
            File file = new File(this.file, name + config.getDataFileExtension());
            if (file.exists() && !file.getName().endsWith(".invalid")) {
                try (FileInputStream fs = new FileInputStream(file);
                     InputStreamReader ir = new InputStreamReader((InputStream)fs, StandardCharsets.UTF_8);
                     BufferedReader br = new BufferedReader(ir);){
                    Configuration in = (Configuration)config.getGson().fromJson((Reader)br, config.getClasses().getConfigurationClass());
                    config.putUnsafe(in, false);
                    result.complete(in);
                }
                catch (Exception e) {
                    AtlantisLogger.error("Failed to read {} for file {}!", config.getName(), file.getName());
                    e.printStackTrace();
                    result.complete(null);
                }
            } else {
                result.complete(null);
            }
        } else {
            result.complete(null);
        }
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<T> delete(Config<T> config, T data) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        if (!this.isServerAlive()) {
            result.complete(null);
            return result;
        }
        Atlantis.THREAD_POOL.submit(() -> {
            try {
                Configuration removed = (Configuration)config.getUUIDDataMap().remove(data.getUUID());
                config.getFilenameDataMap().remove(data.getUniqueName() + config.getDataFileExtension());
                if (data instanceof NamedData) {
                    NamedData namedData = (NamedData)data;
                    config.getNameDataMap().remove(namedData.getName());
                }
                this.deleteFile(config, this.resolveFile(config, data));
                result.complete(removed);
            }
            catch (Exception e) {
                AtlantisLogger.error("Failed to delete {} for file {}!", config.getName(), this.file.getName());
                e.printStackTrace();
                result.complete(null);
            }
        });
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<T> deleteFromUUID(Config<T> config, UUID uuid) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        if (!this.isServerAlive()) {
            result.complete(null);
            return result;
        }
        CompletableFuture<T> data = config.get(uuid);
        if (data != null && data.isDone()) {
            try {
                return this.delete(config, (Configuration)data.get());
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        result.complete(null);
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<T> deleteFromName(Config<T> config, String name) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        if (!this.isServerAlive()) {
            result.complete(null);
            return result;
        }
        T data = config.get(name);
        if (data != null) {
            return this.delete(config, data);
        }
        result.complete(null);
        return result;
    }

    public <T extends Configuration> Config<T> getConfig() {
        return this.config;
    }

    private <T extends Configuration> File resolveFile(Config<T> config, Configuration data) {
        String directory = data.getDirectory();
        if (directory.isEmpty()) {
            return new File(this.file, data.getUniqueName() + config.getDataFileExtension());
        }
        File file = this.file;
        for (String subdir : directory.split("/")) {
            if (!(file = new File(file, subdir)).mkdir()) continue;
            AtlantisLogger.info("Creating new directory {} for {}.", subdir, config.getName());
        }
        return new File(file, data.getUniqueName() + config.getDataFileExtension());
    }

    private <T extends Configuration> void cleanFolder(Config<T> config, File file) {
        if (!this.isServerAlive()) {
            return;
        }
        boolean useBin = Settings.getSettings().isUseErrorBin();
        long delay = Settings.getSettings().getDataSaveDelay();
        File[] dir = file.listFiles();
        if (dir != null) {
            for (File f : dir) {
                if (f.isFile() && !f.getName().endsWith(".invalid")) {
                    if (config.getFilenameDataMap().containsKey(f.getName())) continue;
                    Atlantis.THREAD_POOL.schedule(() -> {
                        if (useBin ? this.moveToBin(config, f) : this.markAsError(config, f)) {
                            AtlantisLogger.debug("Deleted instance of {} {}.", config.getName(), f.getName());
                        } else {
                            AtlantisLogger.error("Failed to delete instance of {} {}!", config.getName(), f.getName());
                        }
                    }, delay);
                    delay += Settings.getSettings().getDataSaveDelay();
                    continue;
                }
                if (!f.isDirectory()) continue;
                this.cleanFolder(config, f);
            }
        }
    }

    private <T extends Configuration> void deleteFile(Config<T> config, File file) {
        if (!this.isServerAlive()) {
            return;
        }
        if (file.isFile()) {
            Atlantis.THREAD_POOL.submit(() -> {
                if (this.moveToBin(config, file)) {
                    AtlantisLogger.debug("Deleted instance of {} {}.", config.getName(), file.getName());
                } else {
                    AtlantisLogger.error("Failed to delete instance of {} {}!", config.getName(), file.getName());
                }
            });
        }
    }

    private <T extends Configuration> boolean markAsError(Config<T> config, File file) {
        int i = 1;
        File parent = file.getParentFile();
        File dest = new File(parent, file.getName() + ".invalid");
        while (dest.exists()) {
            dest = new File(parent, file.getName() + " (" + i++ + ").invalid");
        }
        return file.renameTo(dest);
    }

    private <T extends Configuration> boolean moveToBin(Config<T> config, File file) {
        if (!ERROR_BIN.exists()) {
            ERROR_BIN.mkdirs();
        }
        int i = 1;
        File dest = new File(ERROR_BIN, file.getName() + "_" + config.getOwner() + "_" + config.getKey() + ".backup");
        while (dest.exists()) {
            dest = new File(ERROR_BIN, file.getName() + "_" + config.getOwner() + "_" + config.getKey() + "(" + i++ + ").backup");
        }
        return file.renameTo(dest);
    }
}

