/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.file.ClassHolder;
import de.waterdu.atlantis.file.Config;
import de.waterdu.atlantis.file.DatabaseEncoders;
import de.waterdu.atlantis.file.DatabaseSerializable;
import de.waterdu.atlantis.file.FieldHolder;
import de.waterdu.atlantis.file.datatypes.Configuration;
import de.waterdu.atlantis.file.datatypes.Data;
import de.waterdu.atlantis.file.datatypes.NamedData;
import de.waterdu.atlantis.file.storage.Storage;
import de.waterdu.atlantis.util.text.IncompleteString;
import de.waterdu.atlantis.util.text.TextUtils;
import java.io.File;
import java.io.InvalidClassException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class Database
implements Storage {
    private final HikariConfig config;
    private HikariDataSource hikari;
    private Schema schema;
    private final Queries queries = new Queries();

    public Database(String poolName, String ip, int port, String username, String password, int maxPoolSize, String ... properties) {
        this(poolName, ip, port, username, password, 5, maxPoolSize, 10000, 600000, 600000, properties);
    }

    public Database(String poolName, String ip, int port, String username, String password, int minIdle, int maxPoolSize, int connectionTimeout, int idleTimeout, int leakDetection, String ... properties) {
        this("jdbc:mysql://" + username + ":" + password + "@" + ip + ":" + port + "/", poolName, minIdle, maxPoolSize, connectionTimeout, idleTimeout, leakDetection, TextUtils.join(properties, "serverName=" + ip, "port=" + port, "user=" + username, "password=" + password));
    }

    public Database(String jdbc, String poolName, int maxPoolSize, String ... properties) {
        this(jdbc, poolName, 5, maxPoolSize, 10000, 600000, 600000, properties);
    }

    public Database(String jdbc, String poolName, int minIdle, int maxPoolSize, int connectionTimeout, int idleTimeout, int leakDetection, String ... properties) {
        this.config = new HikariConfig();
        this.config.setMaximumPoolSize(Math.max(1, maxPoolSize));
        this.config.setMinimumIdle(minIdle);
        this.config.setPoolName(poolName);
        this.config.setJdbcUrl(jdbc);
        for (Map.Entry<String, String> property : Settings.getSettings().getHikariProperties().entrySet()) {
            this.config.addDataSourceProperty(property.getKey(), property.getValue());
        }
        for (String property : properties) {
            String[] kv = property.split("=");
            if (kv.length != 2) continue;
            this.config.addDataSourceProperty(kv[0], kv[1]);
        }
        this.config.setConnectionTimeout(connectionTimeout);
        this.config.setIdleTimeout(idleTimeout);
        this.config.setLeakDetectionThreshold(leakDetection);
        this.config.setConnectionTestQuery("SELECT 1");
    }

    @Override
    public <T extends Configuration> void init(Config<T> config, String modID, String key, String path, Gson gson, T configuration, ClassHolder<T> classes) throws InvalidClassException, SQLException, NoSuchFieldException {
        Class<T> clazz = classes.getConfigurationClass();
        String originalModID = modID;
        modID = Settings.getSettings().getDatabaseName(modID);
        if (!(configuration instanceof Data)) {
            throw new InvalidClassException("Only data configuration types can be written to database");
        }
        try {
            clazz.getDeclaredField("uuid");
        }
        catch (NoSuchFieldException e1) {
            try {
                clazz.getField("uuid");
            }
            catch (NoSuchFieldException e2) {
                throw new NoSuchFieldException("Database data requires a uuid field");
            }
        }
        try {
            clazz.getDeclaredField("name");
        }
        catch (NoSuchFieldException e) {
            try {
                clazz.getField("name");
            }
            catch (NoSuchFieldException e2) {
                throw new NoSuchFieldException("Database data requires a name field");
            }
        }
        this.config.addDataSourceProperty("databaseName", modID);
        this.hikari = new HikariDataSource(this.config);
        try (Connection connection = this.getConnection();
             Statement stmt = this.createStatement(connection);){
            stmt.execute(this.hikari.getConnectionTestQuery());
        }
        this.schema = new Schema(originalModID, path.toLowerCase(), clazz);
        this.queries.init(modID, this.schema);
        Atlantis.THREAD_POOL.submit(() -> {
            try (Connection connection = this.getConnection();){
                Throwable throwable;
                Statement stmt;
                try {
                    stmt = this.createStatement(connection);
                    throwable = null;
                    try {
                        stmt.execute(this.queries.prepare(this.queries.CREATE_DATABASE, new String[0]));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stmt != null) {
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    AtlantisLogger.debug("Database probably present already, skipping {}.", config.getName());
                    AtlantisLogger.debug(e.getMessage(), new Object[0]);
                }
                try {
                    stmt = this.createStatement(connection);
                    throwable = null;
                    try {
                        stmt.execute(this.queries.prepare(this.queries.CREATE_TABLE, new String[0]));
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (stmt != null) {
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    AtlantisLogger.debug("Table probably present already, skipping {}.", config.getName());
                    AtlantisLogger.debug(e.getMessage(), new Object[0]);
                }
            }
            catch (SQLException e) {
                AtlantisLogger.error("SQL error when establishing connection, skipping {}.", config.getName());
                e.printStackTrace();
            }
        });
    }

    @Override
    public <T extends Configuration> void destruct(Config<T> config) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            this.hikari.close();
        }
    }

    @Override
    public <T extends Configuration> CompletableFuture<Boolean> write(Config<T> config) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!this.isServerAlive()) {
            result.complete(false);
            return result;
        }
        if (config.getConfigurationContainer().isData()) {
            config.getProcessCount().incrementAndGet();
            Atlantis.THREAD_POOL.submit(() -> {
                for (Configuration out : config.getUUIDDataMap().values()) {
                    if (out == null) continue;
                    this.writeSpecific(config, out);
                }
                config.getProcessCount().decrementAndGet();
                result.complete(true);
            });
        } else {
            result.complete(false);
        }
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<Boolean> writeSpecific(Config<T> config, T data) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!this.isServerAlive()) {
            result.complete(false);
            return result;
        }
        Atlantis.THREAD_POOL.submit(() -> {
            String query = this.queries.prepare(this.queries.INSERT_ELEMENT, "", config, data, this.schema);
            try (Connection connection = this.getConnection();
                 Statement stmt = this.createStatement(connection);){
                result.complete(stmt.execute(query));
            }
            catch (SQLException e) {
                AtlantisLogger.error("SQL error in writeSpecific: " + config.getName(), new Object[0]);
                e.printStackTrace();
                result.complete(false);
            }
        });
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<Boolean> read(Config<T> config, boolean skipNulls) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!this.isServerAlive()) {
            result.complete(false);
            return result;
        }
        if (config.getConfigurationContainer().isData()) {
            config.clearAll();
            this.readAll(config, null, null);
            result.complete(true);
        } else {
            result.complete(false);
        }
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<Boolean> readAll(Config<T> config, File dir, Set<String> names) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!this.isServerAlive()) {
            result.complete(false);
            return result;
        }
        config.getProcessCount().incrementAndGet();
        Atlantis.THREAD_POOL.submit(() -> {
            String query = this.queries.prepare(this.queries.SELECT_ALL, new String[0]);
            try (Connection connection = this.getConnection();
                 Statement stmt = this.createStatement(connection);){
                try (ResultSet rs = stmt.executeQuery(query);){
                    if (rs.first()) {
                        do {
                            try {
                                Configuration data = (Configuration)config.getClasses().getConfigurationClass().newInstance();
                                for (Schema.Element element : this.schema.elements) {
                                    Object value = element.decoder.decode(config, element.field, element.decoder.extract(rs, element.name));
                                    element.field.getField().set(data, value);
                                }
                                config.putUnsafe(data, false);
                            }
                            catch (IllegalAccessException | InstantiationException e) {
                                AtlantisLogger.error("Failed to instantiate object with zero-args constructor: " + config.getName(), new Object[0]);
                                e.printStackTrace();
                            }
                        } while (rs.next());
                    }
                }
                AtlantisLogger.info("Successfully read " + config.getName() + ".", new Object[0]);
                result.complete(true);
            }
            catch (SQLException e) {
                AtlantisLogger.error("SQL error in readAll: " + config.getName(), new Object[0]);
                e.printStackTrace();
                result.complete(false);
            }
            config.getProcessCount().decrementAndGet();
        });
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<T> readFromUUID(Config<T> config, UUID uuid) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        if (!this.isServerAlive()) {
            result.complete(null);
            return result;
        }
        config.getProcessCount().incrementAndGet();
        Atlantis.THREAD_POOL.submit(() -> {
            String query = this.queries.prepare(this.queries.SELECT_ELEMENT_UUID, uuid.toString());
            try (Connection connection = this.getConnection();
                 Statement stmt = this.createStatement(connection);){
                try (ResultSet rs = stmt.executeQuery(query);){
                    if (rs.first()) {
                        do {
                            try {
                                Configuration data = (Configuration)config.getClasses().getConfigurationClass().newInstance();
                                for (Schema.Element element : this.schema.elements) {
                                    try {
                                        Object value = element.decoder.decode(config, element.field, element.decoder.extract(rs, element.name));
                                        element.field.getField().set(data, value);
                                    }
                                    catch (Exception e) {
                                        AtlantisLogger.error("Failed to decode field of type " + element.field.getType().getTypeName() + ", field name " + element.field + ", data type " + config.getName(), new Object[0]);
                                    }
                                }
                                config.putUnsafe(data, false);
                                result.complete(data);
                                AtlantisLogger.info("Successfully read specific " + config.getName() + " for UUID " + uuid + ".", new Object[0]);
                            }
                            catch (IllegalAccessException | InstantiationException e) {
                                AtlantisLogger.error("Failed to instantiate object with zero-args constructor: " + config.getName(), new Object[0]);
                                e.printStackTrace();
                            }
                        } while (rs.next());
                    }
                }
                if (!result.isDone()) {
                    AtlantisLogger.debug("Failed to read specific " + config.getName() + " for UUID " + uuid + ".", new Object[0]);
                    result.complete(null);
                }
            }
            catch (SQLException e) {
                AtlantisLogger.error("SQL error in readAll: " + config.getName(), new Object[0]);
                e.printStackTrace();
                result.complete(null);
            }
            config.getProcessCount().decrementAndGet();
        });
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<T> readFromName(Config<T> config, String name) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        if (!this.isServerAlive()) {
            result.complete(null);
            return result;
        }
        config.getProcessCount().incrementAndGet();
        Atlantis.THREAD_POOL.submit(() -> {
            String query = this.queries.prepare(this.queries.SELECT_ELEMENT_NAME, name);
            try (Connection connection = this.getConnection();
                 Statement stmt = this.createStatement(connection);){
                try (ResultSet rs = stmt.executeQuery(query);){
                    if (rs.first()) {
                        do {
                            try {
                                Configuration data = (Configuration)config.getClasses().getConfigurationClass().newInstance();
                                for (Schema.Element element : this.schema.elements) {
                                    Object value = element.decoder.decode(config, element.field, element.decoder.extract(rs, element.name));
                                    element.field.getField().set(data, value);
                                }
                                config.putUnsafe(data, false);
                                result.complete(data);
                                AtlantisLogger.info("Successfully read specific " + config.getName() + " for name " + name + ".", new Object[0]);
                            }
                            catch (IllegalAccessException | InstantiationException e) {
                                AtlantisLogger.error("Failed to instantiate object with zero-args constructor: " + config.getName(), new Object[0]);
                                e.printStackTrace();
                            }
                        } while (rs.next());
                    }
                }
                if (!result.isDone()) {
                    AtlantisLogger.debug("Failed to read specific " + config.getName() + " for name " + name + ".", new Object[0]);
                    result.complete(null);
                }
            }
            catch (SQLException e) {
                AtlantisLogger.error("SQL error in readAll: " + config.getName(), new Object[0]);
                e.printStackTrace();
                result.complete(null);
            }
            config.getProcessCount().decrementAndGet();
        });
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<T> delete(Config<T> config, T data) {
        return this.deleteFromUUID(config, data.getUUID());
    }

    @Override
    public <T extends Configuration> CompletableFuture<T> deleteFromUUID(Config<T> config, UUID uuid) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        if (!this.isServerAlive()) {
            result.complete(null);
            return result;
        }
        Atlantis.THREAD_POOL.submit(() -> {
            String query = this.queries.prepare(this.queries.DELETE_ELEMENT_UUID, uuid.toString());
            try (Connection connection = this.getConnection();
                 Statement stmt = this.createStatement(connection);){
                if (stmt.execute(query)) {
                    Configuration removed = (Configuration)config.getUUIDDataMap().remove(uuid);
                    if (removed != null) {
                        config.getFilenameDataMap().remove(removed.getUniqueName());
                        if (removed instanceof NamedData) {
                            NamedData namedData = (NamedData)removed;
                            config.getNameDataMap().remove(namedData.getName());
                        }
                    }
                    result.complete(removed);
                }
            }
            catch (SQLException e) {
                AtlantisLogger.error("SQL error in deleteFromUUID: " + config.getName(), new Object[0]);
                e.printStackTrace();
                result.complete(null);
            }
        });
        return result;
    }

    @Override
    public <T extends Configuration> CompletableFuture<T> deleteFromName(Config<T> config, String name) {
        T data = config.get(name);
        if (data == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.delete(config, data);
    }

    public Connection getConnection() throws SQLException {
        return this.hikari.getConnection();
    }

    public Statement createStatement(Connection connection) throws SQLException {
        return connection.createStatement(1004, 1007);
    }

    public Queries getQueries() {
        return this.queries;
    }

    public static class Keywords {
        public static String PRIMARY_KEY = "PRIMARY KEY";
        public static String UNIQUE_KEY = "UNIQUE";
        public static String NOT_NULL = "NOT NULL";
        public static String AUTO_INCREMENT = "AUTO_INCREMENT";

        private Keywords() {
        }
    }

    public static class Queries {
        public IncompleteString CREATE_DATABASE = IncompleteString.of("CREATE DATABASE IF NOT EXISTS %d");
        public IncompleteString CREATE_TABLE = IncompleteString.of("CREATE TABLE IF NOT EXISTS %d.%t (%c)");
        public IncompleteString INSERT_ELEMENT = IncompleteString.builder().string("INSERT INTO %d.%t (%n) VALUES (%v) ON DUPLICATE KEY UPDATE %u").build();
        public IncompleteString UPDATE_ELEMENT_UUID = IncompleteString.builder().string("UPDATE %d.%t SET %u WHERE uuid = '").placeholder().string("'").build();
        public IncompleteString SELECT_ELEMENT_UUID = IncompleteString.builder().string("SELECT * FROM %d.%t WHERE uuid = '").placeholder().string("'").build();
        public IncompleteString DELETE_ELEMENT_UUID = IncompleteString.builder().string("DELETE FROM %d.%t WHERE uuid = '").placeholder().string("'").build();
        public IncompleteString UPDATE_ELEMENT_NAME = IncompleteString.builder().string("UPDATE %d.%t SET %u WHERE name = '").placeholder().string("'").build();
        public IncompleteString SELECT_ELEMENT_NAME = IncompleteString.builder().string("SELECT * FROM %d.%t WHERE name = '").placeholder().string("'").build();
        public IncompleteString DELETE_ELEMENT_NAME = IncompleteString.builder().string("DELETE FROM %d.%t WHERE name = '").placeholder().string("'").build();
        public IncompleteString SELECT_ALL = IncompleteString.of("SELECT * FROM %d.%t");

        public void init(String database, Schema schema) {
            IncompleteString.Builder create = IncompleteString.builder();
            IncompleteString.Builder update = IncompleteString.builder();
            IncompleteString.Builder names = IncompleteString.builder();
            IncompleteString.Builder values = IncompleteString.builder();
            for (Schema.Element element : schema.elements) {
                if (!create.isEmpty()) {
                    create.append(", ");
                }
                create.append(element.name).append(" ").append(element.type);
                if (element.notNull) {
                    create.append(" ").append(Keywords.NOT_NULL);
                }
                if (element.autoIncrement) {
                    create.append(" ").append(Keywords.AUTO_INCREMENT);
                }
                if (element.primaryKey) {
                    create.append(" ").append(Keywords.PRIMARY_KEY);
                } else if (element.uniqueKey) {
                    create.append(" ").append(Keywords.UNIQUE_KEY);
                }
                if (element.autoIncrement) continue;
                if (!element.primaryKey) {
                    if (!update.isEmpty()) {
                        update.append(", ");
                    }
                    update.append(element.name).append(" = ").append(element.surround).placeholder().append(element.surround);
                }
                if (!names.isEmpty()) {
                    names.append(", ");
                }
                names.append(element.name);
                if (!values.isEmpty()) {
                    values.append(", ");
                }
                values.append(element.surround).placeholder().append(element.surround);
            }
            try {
                IncompleteString createBuilt = create.build();
                IncompleteString updateBuilt = update.build();
                IncompleteString namesBuilt = names.build();
                IncompleteString valuesBuilt = values.build();
                for (Field field : this.getClass().getDeclaredFields()) {
                    IncompleteString value = (IncompleteString)field.get(this);
                    field.set(this, value.replace((CharSequence)"%d", database).replace((CharSequence)"%t", schema.table).replace("%c", createBuilt).replace("%u", updateBuilt).replace("%n", namesBuilt).replace("%v", valuesBuilt));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        public String prepare(IncompleteString query, String ... args) {
            return query.complete(args);
        }

        public <T extends Configuration> String prepare(IncompleteString query, String key, Config<T> config, Object data, Schema schema) {
            String[] args = new String[schema.elements.size() + (key.isEmpty() ? schema.elements.size() - 1 : 1) - schema.autoIncrementElements];
            int i = 0;
            for (Schema.Element element : schema.elements) {
                if (element.autoIncrement) continue;
                try {
                    args[i] = element.encoder.encode(config, element.field, element.field.getField().get(data));
                    if (element.surround.equalsIgnoreCase("'")) {
                        args[i] = args[i].replace("'", "''");
                    }
                }
                catch (IllegalAccessException e) {
                    AtlantisLogger.error("Failed to get field when preparing query: " + config.getName(), new Object[0]);
                }
                ++i;
            }
            if (!key.isEmpty()) {
                args[i] = key;
            } else {
                for (Schema.Element element : schema.elements) {
                    if (element.primaryKey || element.autoIncrement) continue;
                    try {
                        args[i] = element.encoder.encode(config, element.field, element.field.getField().get(data));
                        if (element.surround.equalsIgnoreCase("'")) {
                            args[i] = args[i].replace("'", "''");
                        }
                    }
                    catch (IllegalAccessException e) {
                        AtlantisLogger.error("Failed to get field when preparing query: " + config.getName(), new Object[0]);
                    }
                    ++i;
                }
            }
            return query.complete(args);
        }
    }

    protected static class Schema {
        private final String table;
        private final Class<?> type;
        private final List<Element> elements;
        private final int autoIncrementElements;

        public Schema(String originalModID, String table, Class<?> type) {
            Element element;
            DatabaseSerializable annotation;
            int autoIncrementElements = 0;
            this.table = (Settings.getSettings().isModIDPrefixOnTableNames() ? originalModID + "_" : "") + table;
            this.type = type;
            this.elements = Lists.newArrayList();
            HashSet parsedFields = Sets.newHashSet();
            for (Field field : type.getDeclaredFields()) {
                if (!field.isAnnotationPresent(DatabaseSerializable.class)) continue;
                field.setAccessible(true);
                annotation = field.getAnnotation(DatabaseSerializable.class);
                if (annotation == null || parsedFields.contains(field)) continue;
                parsedFields.add(field);
                element = new Element(field, annotation);
                this.elements.add(element);
                if (!element.autoIncrement) continue;
                ++autoIncrementElements;
            }
            for (Field field : type.getFields()) {
                if (!field.isAnnotationPresent(DatabaseSerializable.class)) continue;
                field.setAccessible(true);
                annotation = field.getAnnotation(DatabaseSerializable.class);
                if (annotation == null || parsedFields.contains(field)) continue;
                parsedFields.add(field);
                element = new Element(field, annotation);
                this.elements.add(element);
                if (!element.autoIncrement) continue;
                ++autoIncrementElements;
            }
            this.autoIncrementElements = autoIncrementElements;
        }

        protected static class Element {
            private final FieldHolder field;
            private final String name;
            private final String type;
            private final String surround;
            private final DatabaseEncoders.Encoder<?> encoder;
            private final DatabaseEncoders.Decoder<?> decoder;
            private final boolean primaryKey;
            private final boolean autoIncrement;
            private final boolean uniqueKey;
            private final boolean notNull;

            public Element(Field field, DatabaseSerializable annotation) {
                this.field = FieldHolder.of(field);
                this.name = field.getName().toLowerCase();
                this.type = annotation.type().toUpperCase();
                this.surround = annotation.quoteMark();
                this.encoder = DatabaseEncoders.getEncoder(annotation.encoder()).orElseThrow(() -> new NullPointerException("Invalid encoder " + annotation.encoder()));
                this.decoder = DatabaseEncoders.getDecoder(annotation.encoder()).orElseThrow(() -> new NullPointerException("Invalid decoder " + annotation.encoder()));
                this.primaryKey = annotation.primaryKey();
                this.autoIncrement = annotation.autoIncrement();
                this.uniqueKey = this.primaryKey || annotation.uniqueKey();
                this.notNull = annotation.notNull();
            }
        }
    }
}

