/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file.auto;

import de.waterdu.atlantis.file.auto.AtlantisConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"de.waterdu.atlantis.file.auto.AtlantisConfig"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class AtlantisConfigValidator
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elements = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        Messager messager = this.processingEnv.getMessager();
        ArrayList<TypeMirror> interfaces = new ArrayList<TypeMirror>();
        interfaces.add(elements.getTypeElement("de.waterdu.atlantis.file.datatypes.Configuration").asType());
        TypeMirror dataType = elements.getTypeElement("de.waterdu.atlantis.file.datatypes.Data").asType();
        interfaces.add(dataType);
        interfaces.add(elements.getTypeElement("de.waterdu.atlantis.file.datatypes.NamedData").asType());
        interfaces.add(elements.getTypeElement("de.waterdu.atlantis.file.datatypes.PlayerData").asType());
        block0: for (Element element : roundEnv.getElementsAnnotatedWith(AtlantisConfig.class)) {
            TypeMirror type = element.asType();
            for (TypeMirror tm : interfaces) {
                if (!types.isAssignable(type, tm) || types.isAssignable(type, dataType) && !this.checkForHCEQTSMethods(elements, element, messager)) continue;
                continue block0;
            }
            messager.printMessage(Diagnostic.Kind.ERROR, "invalid AtlantisConfig implementation, must implement one of Configuration, Data, NamedData, PlayerData", element);
        }
        return true;
    }

    private boolean checkForHCEQTSMethods(Elements elements, Element element, Messager messager) {
        boolean hashCode = false;
        boolean equals = false;
        boolean toString = false;
        for (Element element2 : elements.getAllMembers((TypeElement)element)) {
            if (element2.getKind() != ElementKind.METHOD || element2.getEnclosingElement().getSimpleName().contentEquals("Object")) continue;
            if (element2.getSimpleName().contentEquals("hashCode")) {
                hashCode = true;
                continue;
            }
            if (element2.getSimpleName().contentEquals("equals")) {
                equals = true;
                continue;
            }
            if (!element2.getSimpleName().contentEquals("toString")) continue;
            toString = true;
        }
        if (hashCode && equals && toString) {
            return true;
        }
        String missing = "";
        if (!hashCode) {
            missing = missing + "hashCode";
        }
        if (!equals) {
            if (!missing.isEmpty()) {
                missing = missing + ", ";
            }
            missing = missing + "equals";
        }
        if (!toString) {
            if (!missing.isEmpty()) {
                missing = missing + ", ";
            }
            missing = missing + "toString";
        }
        messager.printMessage(Diagnostic.Kind.ERROR, "invalid " + element.getSimpleName() + " implementation, must override " + missing, element);
        return false;
    }

    private boolean containsType(List<TypeMirror> types, TypeMirror type) {
        for (TypeMirror other : types) {
            if (!this.processingEnv.getTypeUtils().isSameType(type, other)) continue;
            return true;
        }
        return false;
    }
}

