/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file;

import de.waterdu.atlantis.file.AllowedTypes;
import de.waterdu.atlantis.file.DatabaseSerializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"de.waterdu.atlantis.file.DatabaseSerializable", "de.waterdu.atlantis.file.AllowedTypes"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class DatabaseSerializableValidator
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager messager = this.processingEnv.getMessager();
        block2: for (Element element : roundEnv.getElementsAnnotatedWith(DatabaseSerializable.class)) {
            DatabaseSerializable annotation = element.getAnnotation(DatabaseSerializable.class);
            String type = annotation.type();
            String javaType = element.asType().toString();
            List<TypeMirror> allowedTypes = this.getAllowedTypes(element, type);
            if (allowedTypes == null) continue;
            try {
                if (allowedTypes.isEmpty()) continue;
                for (TypeMirror clazz : allowedTypes) {
                    if (!clazz.toString().equalsIgnoreCase(javaType)) continue;
                    continue block2;
                }
                messager.printMessage(Diagnostic.Kind.ERROR, "Unsupported SQL type " + type + " for JVM type " + javaType, element);
            }
            catch (NullPointerException nullPointerException) {}
        }
        return true;
    }

    private List<TypeMirror> getAllowedTypes(Element self, String type) {
        for (Element element : this.processingEnv.getElementUtils().getPackageOf(self.getAnnotationMirrors().get(0).getAnnotationType().asElement()).getEnclosedElements()) {
            if (!element.getSimpleName().contentEquals("DatabaseEncoders")) continue;
            for (Element element2 : element.getEnclosedElements()) {
                if (!element2.getSimpleName().contentEquals("Defaults")) continue;
                for (Element element3 : element2.getEnclosedElements()) {
                    if (!element3.getSimpleName().contentEquals(type.toUpperCase(Locale.ROOT))) continue;
                    return this.getClassArrayValueFromAnnotation(element3, AllowedTypes.class, "value");
                }
            }
        }
        return null;
    }

    private List<TypeMirror> getClassArrayValueFromAnnotation(Element element, Class<? extends Annotation> annotation, String paramName) {
        Elements elements = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        ArrayList<TypeMirror> values = new ArrayList<TypeMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!types.isSameType(annotationMirror.getAnnotationType(), elements.getTypeElement(annotation.getCanonicalName()).asType())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!paramName.equals(entry.getKey().getSimpleName().toString())) continue;
                List classesTypes = (List)entry.getValue().getValue();
                for (AnnotationValue next : classesTypes) {
                    values.add((TypeMirror)next.getValue());
                }
            }
        }
        return values;
    }
}

