/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file;

import com.google.common.collect.Maps;
import de.waterdu.atlantis.file.Config;
import de.waterdu.atlantis.file.FieldHolder;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.java.interfaces.SQLBiFunction;
import de.waterdu.atlantis.util.java.interfaces.TriFunction;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class DatabaseEncoders {
    private static final Map<String, Encoder<?>> ENCODERS = Maps.newHashMap();
    private static final Map<String, Decoder<?>> DECODERS = Maps.newHashMap();

    private DatabaseEncoders() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static void register(String name, Encoder<?> encoder, Decoder<?> decoder) {
        ENCODERS.put(name.toLowerCase(), encoder);
        DECODERS.put(name.toLowerCase(), decoder);
    }

    public static void register(Encoder<?> encoder, Decoder<?> decoder, String ... names) {
        for (String name : names) {
            DatabaseEncoders.register(name, encoder, decoder);
        }
    }

    public static Optional<Encoder<?>> getEncoder(String name) {
        return Optional.of(ENCODERS.get(name.toLowerCase()));
    }

    public static Optional<Decoder<?>> getDecoder(String name) {
        return Optional.of(DECODERS.get(name.toLowerCase()));
    }

    static {
        DatabaseEncoders.register("json", new Encoder<Object>((config, field, data) -> config.getGson().toJson(data)), new Decoder<String>(ResultSet::getString, (config, field, data) -> config.getGson().fromJson(data, field.getType())));
        DatabaseEncoders.register(new Encoder(), new Decoder<byte[]>(ResultSet::getBytes, (config, field, data) -> Base64.getEncoder().encodeToString((byte[])data)), "tinyblob", "blob", "mediumblob", "longblob");
        DatabaseEncoders.register(new Encoder(), new Decoder<String>(ResultSet::getString), "string", "tinytext", "text", "mediumtext", "longtext", "varchar");
        DatabaseEncoders.register(new Encoder(), new Decoder<Integer>(ResultSet::getInt), "int", "integer");
        DatabaseEncoders.register("float", new Encoder(), new Decoder<Float>(ResultSet::getFloat));
        DatabaseEncoders.register("short", new Encoder(), new Decoder<Short>(ResultSet::getShort));
        DatabaseEncoders.register("double", new Encoder(), new Decoder<Double>(ResultSet::getDouble));
        DatabaseEncoders.register("long", new Encoder(), new Decoder<Long>(ResultSet::getLong));
        DatabaseEncoders.register("bigint", new Encoder(), new Decoder<Long>(ResultSet::getLong, (config, field, data) -> BigInteger.valueOf(data)));
        DatabaseEncoders.register("byte", new Encoder(), new Decoder<Byte>(ResultSet::getByte));
        DatabaseEncoders.register("uuid", new Encoder(), new Decoder<String>(ResultSet::getString, (config, field, data) -> UUID.fromString(data)));
        DatabaseEncoders.register(new Encoder<Object>((config, field, data) -> (Boolean)data != false ? "1" : "0"), new Decoder<Boolean>(ResultSet::getBoolean, (config, field, data) -> data), "bool", "boolean");
    }

    public static class Decoder<T> {
        private final SQLBiFunction<ResultSet, String, T> extractor;
        private final TriFunction<Config<?>, FieldHolder, T, ?> decoder;

        public Decoder(SQLBiFunction<ResultSet, String, T> extractor) {
            this(extractor, (config, field, data) -> data);
        }

        public Decoder(SQLBiFunction<ResultSet, String, T> extractor, TriFunction<Config<?>, FieldHolder, T, ?> decoder) {
            this.extractor = extractor;
            this.decoder = decoder;
        }

        public T extract(ResultSet rs, String column) throws SQLException {
            return this.extractor.apply(rs, column);
        }

        public Object decode(Config<?> config, FieldHolder field, Object data) {
            return this.decoder.apply(config, field, data);
        }
    }

    public static class Encoder<T> {
        private final TriFunction<Config<?>, FieldHolder, T, String> encoder;

        public Encoder() {
            this((config, field, data) -> String.valueOf(data));
        }

        public Encoder(TriFunction<Config<?>, FieldHolder, T, String> encoder) {
            this.encoder = encoder;
        }

        public String encode(Config<?> config, FieldHolder field, Object data) {
            return this.encoder.apply(config, field, data);
        }
    }

    public static class QuoteMarks {
        public static final String NONE = "";
        public static final String SINGLE = "'";
        public static final String DOUBLE = "\"";
        public static final String BACKTICK = "`";

        private QuoteMarks() {
            ExceptionUtils.throwCannotInstantiateClassException();
        }
    }

    public static class Defaults {
        public static final String JSON = "json";
        public static final String STRING = "string";
        public static final String INT = "int";
        public static final String INTEGER = "integer";
        public static final String FLOAT = "float";
        public static final String SHORT = "short";
        public static final String DOUBLE = "double";
        public static final String LONG = "long";
        public static final String BIGINT = "bigint";
        public static final String BYTE = "byte";
        public static final String UUID = "uuid";
        public static final String BOOL = "bool";
        public static final String BOOLEAN = "boolean";
        public static final String TINYTEXT = "tinytext";
        public static final String TEXT = "text";
        public static final String MEDIUMTEXT = "mediumtext";
        public static final String LONGTEXT = "longtext";
        public static final String TINYBLOB = "tinyblob";
        public static final String BLOB = "blob";
        public static final String MEDIUMBLOB = "mediumblob";
        public static final String LONGBLOB = "longblob";
        public static final String VARCHAR = "varchar";
        public static final String VARCHAR_UUID = "varchar(36)";
        public static final String VARCHAR_USERNAME = "varchar(30)";
        public static final String VARCHAR_MAX = "varchar(65535)";

        private Defaults() {
            ExceptionUtils.throwCannotInstantiateClassException();
        }

        public static String varchar(int len) {
            return "varchar(" + len + ")";
        }
    }
}

