/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.file.AtlantisConfig;
import de.waterdu.atlantis.file.ClassHolder;
import de.waterdu.atlantis.file.ConfigurationContainer;
import de.waterdu.atlantis.file.auto.LoadOrder;
import de.waterdu.atlantis.file.datatypes.Configuration;
import de.waterdu.atlantis.file.datatypes.Data;
import de.waterdu.atlantis.file.datatypes.NamedData;
import de.waterdu.atlantis.file.datatypes.PlayerData;
import de.waterdu.atlantis.file.storage.Storage;
import de.waterdu.atlantis.meta.ConfigEvent;
import de.waterdu.atlantis.playerdata.UUIDNameCache;
import de.waterdu.atlantis.util.text.Text;
import de.waterdu.atlantis.util.text.TextUtils;
import java.io.InvalidClassException;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;

public class Config<T extends Configuration> {
    private final AtlantisConfig parent;
    private final ClassHolder<T> classes;
    private final Gson gson;
    private final Storage storage;
    private final String owner;
    private final String key;
    private final ConfigurationContainer<T> cc = new ConfigurationContainer();
    private final Set<T> dataSet = Sets.newLinkedHashSet();
    private final Map<UUID, T> uuidDataMap = Maps.newConcurrentMap();
    private final Map<String, T> nameDataMap = Maps.newConcurrentMap();
    private final Map<String, T> filenameDataMap = Maps.newConcurrentMap();
    private final boolean forceLoad;
    private final boolean lang;
    private final Map<String, Text> langMap = Maps.newHashMap();
    private final boolean aon;
    private final LoadOrder order;
    private final AtomicInteger processCount = new AtomicInteger(0);
    private final List<Consumer<Collection<T>>> scheduledTasks = Lists.newArrayList();
    private final Set<UUID> filesToSave = Sets.newConcurrentHashSet();
    private final List<Function<T, Boolean>> putListeners = Lists.newArrayList();

    public Config(AtlantisConfig parent, String modID, String key, Gson gson, T configuration, Class<T> clazz, Storage storage, boolean forceLoad, boolean lang, boolean aon, LoadOrder order) {
        this.parent = parent;
        this.owner = modID;
        this.gson = gson;
        this.key = key;
        this.cc.set(this, configuration);
        this.classes = new ClassHolder<T>(this.owner, clazz);
        this.forceLoad = forceLoad;
        this.lang = lang;
        this.storage = storage;
        this.aon = aon;
        this.order = order;
    }

    protected void init(String path) throws SQLException, InvalidClassException, NoSuchFieldException {
        this.storage.init(this, this.owner, this.key, path, this.gson, this.cc.get(), this.classes);
    }

    public ConfigurationContainer<T> getConfigurationContainer() {
        return this.cc;
    }

    public Map<UUID, T> getUUIDDataMap() {
        return this.uuidDataMap;
    }

    public Map<String, T> getFilenameDataMap() {
        return this.filenameDataMap;
    }

    public String getDataFileExtension() {
        return this.aon ? ".aon" : ".json";
    }

    public boolean isAON() {
        return this.aon;
    }

    public LoadOrder getOrder() {
        return this.order;
    }

    public Map<String, T> getNameDataMap() {
        return this.nameDataMap;
    }

    public AtomicInteger getProcessCount() {
        return this.processCount;
    }

    public String getKey() {
        return this.key;
    }

    public AtlantisConfig getParent() {
        return this.parent;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.owner + ":" + this.key;
    }

    public Gson getGson() {
        return this.gson;
    }

    public String getFilename(Data data) {
        return data.getUniqueName() + ".json";
    }

    public Storage getStorage() {
        return this.storage;
    }

    public boolean isData() {
        return this.cc.isData();
    }

    public boolean isPlayerData() {
        return this.cc.isPlayerData();
    }

    public boolean isBusy() {
        return this.processCount.get() > 0;
    }

    public void runTask(Runnable task) {
        Consumer<Collection> consumer = all -> task.run();
        if (this.isBusy()) {
            if (this.scheduledTasks.isEmpty()) {
                this.scheduledTasks.add(consumer);
                Atlantis.THREAD_POOL.repeatUntilComplete(() -> {
                    if (this.isBusy()) {
                        return false;
                    }
                    Set<T> all = this.getAll();
                    for (Consumer<Collection<Set<T>>> consumer : this.scheduledTasks) {
                        consumer.accept(all);
                    }
                    this.scheduledTasks.clear();
                    return true;
                }, Settings.getSettings().getScheduledTaskDelay());
            } else {
                this.scheduledTasks.add(consumer);
            }
        } else {
            task.run();
        }
    }

    private void addScheduledTask(Consumer<Collection<T>> consumer) {
        this.scheduledTasks.add(consumer);
    }

    public void addPutListener(Function<T, Boolean> listener) {
        this.putListeners.add(listener);
    }

    public boolean onPut(T data) {
        boolean result = false;
        for (Function<T, Boolean> putListener : this.putListeners) {
            result |= putListener.apply(data).booleanValue();
        }
        return result;
    }

    public void runTask(Consumer<Collection<T>> task) {
        if (this.isBusy()) {
            if (this.scheduledTasks.isEmpty()) {
                this.addScheduledTask(task);
                Atlantis.THREAD_POOL.repeatUntilComplete(() -> {
                    if (this.isBusy()) {
                        return false;
                    }
                    Set<T> all = this.getAll();
                    for (Consumer<Collection<Set<T>>> consumer : this.scheduledTasks) {
                        consumer.accept(all);
                    }
                    this.scheduledTasks.clear();
                    return true;
                }, Settings.getSettings().getScheduledTaskDelay());
            } else {
                this.addScheduledTask(task);
            }
        } else {
            task.accept(this.getAll());
        }
    }

    public void clearAll() {
        this.dataSet.clear();
        this.uuidDataMap.clear();
        this.nameDataMap.clear();
        this.filenameDataMap.clear();
    }

    public T get() {
        return this.cc.get();
    }

    public ClassHolder<T> getClasses() {
        return this.classes;
    }

    public CompletableFuture<T> get(UUID uuid) {
        if (uuid == null) {
            return CompletableFuture.completedFuture(null);
        }
        Configuration data = (Configuration)this.uuidDataMap.get(uuid);
        if (data == null && this.cc.isPlayerData()) {
            return this.readPlayerData(uuid);
        }
        return CompletableFuture.completedFuture(data);
    }

    public T getNow(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        Configuration data = (Configuration)this.uuidDataMap.get(uuid);
        if (data == null && this.cc.isPlayerData()) {
            return (T)((Configuration)this.readPlayerData(uuid).join());
        }
        return (T)data;
    }

    public Set<T> getAll() {
        return this.dataSet;
    }

    public T get(String name) {
        return (T)((Configuration)this.nameDataMap.get(name));
    }

    public T get(PlayerEntity player) {
        return (T)((Configuration)this.uuidDataMap.get(player.func_110124_au()));
    }

    public void putUnsafe(T data, boolean force) {
        Data cast = (Data)data;
        UUID uuid = AtlantisConfig.copyUUID(cast.getUUID());
        if (!(!force && this.uuidDataMap.containsKey(uuid) || this.onPut(data))) {
            this.dataSet.add(data);
            this.uuidDataMap.put(uuid, data);
            this.filenameDataMap.put(this.getFilename(cast), data);
            if (data instanceof NamedData) {
                PlayerData playerData;
                NamedData namedData = (NamedData)data;
                this.nameDataMap.put(namedData.getName(), data);
                if (data instanceof PlayerData && !(playerData = (PlayerData)data).getUUID().equals(Util.field_240973_b_) && !playerData.getUniqueName().isEmpty()) {
                    UUIDNameCache.add(playerData.getUniqueName(), playerData.getUUID());
                }
            }
        }
    }

    public void invalidate(T data) {
        if (data != null) {
            Data cast = (Data)data;
            UUID uuid = AtlantisConfig.copyUUID(cast.getUUID());
            this.dataSet.remove(data);
            this.uuidDataMap.remove(uuid);
            this.filenameDataMap.remove(this.getFilename(cast));
            if (data instanceof NamedData) {
                this.nameDataMap.remove(((NamedData)data).getName());
            }
        }
    }

    public void invalidate(PlayerEntity player) {
        if (player != null) {
            UUID uuid = AtlantisConfig.copyUUID(player.func_110124_au());
            this.dataSet.remove(this.uuidDataMap.remove(uuid));
            this.filenameDataMap.remove(uuid + ".json");
            this.nameDataMap.remove(player.func_200200_C_().getString());
        }
    }

    public void updateName(T data, String oldName, String oldFilename) {
        if (data instanceof NamedData) {
            NamedData namedData = (NamedData)data;
            this.nameDataMap.remove(oldName);
            this.nameDataMap.put(namedData.getName(), data);
            this.filenameDataMap.remove(oldFilename);
            this.filenameDataMap.put(this.getFilename(namedData), data);
        }
    }

    public boolean put(T data) {
        if (data.getClass().equals(this.classes.getDataClass().orElse(null))) {
            this.putUnsafe(data, true);
            return true;
        }
        return false;
    }

    public CompletableFuture<T> remove(UUID uuid) {
        return this.storage.deleteFromUUID(this, uuid).whenComplete((data, err) -> {
            Atlantis.EVENT_BUS.post(new ConfigEvent.Delete<Configuration>((Config<Configuration>)this, (Configuration)data));
            this.invalidate(data);
        });
    }

    public CompletableFuture<T> remove(PlayerEntity player) {
        return this.storage.deleteFromPlayer(this, player).whenComplete((data, err) -> {
            Atlantis.EVENT_BUS.post(new ConfigEvent.Delete<Configuration>((Config<Configuration>)this, (Configuration)data));
            this.invalidate(data);
        });
    }

    public CompletableFuture<T> remove(String name) {
        return this.storage.deleteFromName(this, name).whenComplete((data, err) -> {
            Atlantis.EVENT_BUS.post(new ConfigEvent.Delete<Configuration>((Config<Configuration>)this, (Configuration)data));
            this.invalidate(data);
        });
    }

    public CompletableFuture<Boolean> read() {
        return this.read(false);
    }

    public CompletableFuture<Boolean> read(boolean skipNulls) {
        return this.storage.read(this, skipNulls).whenComplete((data, err) -> Atlantis.EVENT_BUS.post(new ConfigEvent.Read<T>(this, this.cc.get())));
    }

    public CompletableFuture<T> readPlayerData(UUID uuid) {
        return this.storage.readFromUUID(this, uuid).whenComplete((data, err) -> Atlantis.EVENT_BUS.post(new ConfigEvent.Read<Configuration>((Config<Configuration>)this, (Configuration)data)));
    }

    public CompletableFuture<T> readPlayerData(PlayerEntity player) {
        return this.storage.readFromPlayer(this, player).whenComplete((data, err) -> Atlantis.EVENT_BUS.post(new ConfigEvent.Read<Configuration>((Config<Configuration>)this, (Configuration)data)));
    }

    public CompletableFuture<T> readNamedData(String name) {
        return this.storage.readFromName(this, name).whenComplete((data, err) -> Atlantis.EVENT_BUS.post(new ConfigEvent.Read<Configuration>((Config<Configuration>)this, (Configuration)data)));
    }

    public CompletableFuture<Boolean> write() {
        return this.write(null);
    }

    public CompletableFuture<Boolean> write(T specific) {
        return this.write(specific, false);
    }

    public CompletableFuture<Boolean> write(T specific, boolean immediate) {
        if (specific == null) {
            return this.storage.write(this).whenComplete((b, err) -> Atlantis.EVENT_BUS.post(new ConfigEvent.Write<T>(this, this.cc.get())));
        }
        if (specific.getClass().equals(this.classes.getConfigurationClass())) {
            try {
                if (this.isPlayerData() && !immediate) {
                    this.filesToSave.add(specific.getUUID());
                    return CompletableFuture.completedFuture(true);
                }
                return this.storage.writeSpecific(this, specific).whenComplete((b, err) -> Atlantis.EVENT_BUS.post(new ConfigEvent.Write<Configuration>((Config<Configuration>)this, (Configuration)specific)));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return CompletableFuture.completedFuture(false);
    }

    public boolean shouldForceLoad() {
        return this.forceLoad;
    }

    public boolean isLang() {
        return this.lang;
    }

    public void remapLang() {
        if (this.lang) {
            this.langMap.clear();
            for (Field field : this.cc.get().getClass().getDeclaredFields()) {
                if (field.getType() != String.class) continue;
                try {
                    this.langMap.put(field.getName().toLowerCase(), Text.of((String)field.get(this.cc.get())));
                }
                catch (Exception e) {
                    AtlantisLogger.error("Failed to map lang on " + this.owner + ":" + this.classes.getSimpleName() + ".", new Object[0]);
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean markSaved(UUID uuid) {
        return this.filesToSave.remove(uuid);
    }

    public Text format(String key, Object ... args) {
        return TextUtils.format(this.langMap.get(key.toLowerCase()), args);
    }

    protected void destruct() {
        this.storage.destruct(this);
    }

    public void asyncSave() {
        HashSet<UUID> uuids = new HashSet<UUID>(this.filesToSave);
        this.filesToSave.clear();
        this.getClasses().getPlayerDataClass().ifPresent(clazz -> {
            long delay = Settings.getSettings().getDataSaveDelay() * 2L;
            for (UUID uuid : uuids) {
                Atlantis.THREAD_POOL.schedule(() -> {
                    CompletableFuture future = AtlantisConfig.getFor(this.getOwner(), clazz, uuid);
                    future.whenComplete((data, err) -> {
                        if (data != null) {
                            try {
                                this.storage.writeSpecific(this, data);
                            }
                            catch (InterruptedException e) {
                                AtlantisLogger.error("Failed to save instance of {} called {} with UUID {}!", this.getName(), data.getUniqueName(), data.getUUID());
                            }
                        }
                    });
                }, delay);
                delay += Settings.getSettings().getDataSaveDelay();
            }
        });
    }
}

