/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file;

import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.file.Config;
import de.waterdu.atlantis.file.datatypes.Configuration;
import de.waterdu.atlantis.file.datatypes.Data;
import de.waterdu.atlantis.file.datatypes.NamedData;
import de.waterdu.atlantis.file.datatypes.PlayerData;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;

public class ClassHolder<T extends Configuration> {
    private final Class<T> configuration;
    private final Class<? extends Configuration> data;
    private final Class<? extends Configuration> namedData;
    private final Class<? extends Configuration> playerData;
    private final Constructor<? extends PlayerData> playerDataConstructor;
    private final Method playerDataOnLoginCallback;
    private final Method playerDataOnLogoutCallback;
    private final String simpleName;
    private final String canonicalName;

    public ClassHolder(String owner, Class<T> clazz) {
        Method playerDataOnLogoutCallback;
        Method playerDataOnLoginCallback;
        Constructor<T> playerDataConstructor;
        this.simpleName = clazz.getSimpleName();
        this.canonicalName = clazz.getCanonicalName();
        this.configuration = Configuration.class.isAssignableFrom(clazz) ? clazz : null;
        this.data = Data.class.isAssignableFrom(clazz) ? clazz : null;
        this.namedData = NamedData.class.isAssignableFrom(clazz) ? clazz : null;
        if (PlayerData.class.isAssignableFrom(clazz)) {
            this.playerData = clazz;
            try {
                playerDataConstructor = clazz.getConstructor(ServerPlayerEntity.class);
            }
            catch (NoSuchMethodException e) {
                AtlantisLogger.warn("No valid ServerPlayerEntity constructor for data class " + owner + ":" + this.simpleName, new Object[0]);
                playerDataConstructor = null;
            }
            try {
                playerDataOnLoginCallback = clazz.getMethod("onLogin", ServerPlayerEntity.class);
            }
            catch (NoSuchMethodException e) {
                AtlantisLogger.warn("No valid ServerPlayerEntity onLogin method for data class " + owner + ":" + this.simpleName, new Object[0]);
                playerDataOnLoginCallback = null;
            }
            try {
                playerDataOnLogoutCallback = clazz.getMethod("onLogout", ServerPlayerEntity.class);
            }
            catch (NoSuchMethodException e) {
                AtlantisLogger.warn("No valid ServerPlayerEntity onLogout method for data class " + owner + ":" + this.simpleName, new Object[0]);
                playerDataOnLogoutCallback = null;
            }
        } else {
            this.playerData = null;
            playerDataConstructor = null;
            playerDataOnLoginCallback = null;
            playerDataOnLogoutCallback = null;
        }
        this.playerDataConstructor = playerDataConstructor;
        this.playerDataOnLoginCallback = playerDataOnLoginCallback;
        this.playerDataOnLogoutCallback = playerDataOnLogoutCallback;
    }

    public Class<T> getConfigurationClass() {
        return this.configuration;
    }

    public <V extends Configuration> Optional<Class<V>> getDataClass() {
        return Optional.ofNullable(this.data);
    }

    public <V extends Configuration> Optional<Class<V>> getNamedDataClass() {
        return Optional.ofNullable(this.namedData);
    }

    public <V extends Configuration> Optional<Class<V>> getPlayerDataClass() {
        return Optional.ofNullable(this.playerData);
    }

    public <V extends Configuration> Optional<Constructor<V>> getPlayerDataConstructor() {
        return Optional.ofNullable(this.playerDataConstructor);
    }

    public Optional<Method> getPlayerDataOnLoginCallback() {
        return Optional.ofNullable(this.playerDataOnLoginCallback);
    }

    public Optional<Method> getPlayerDataOnLogoutCallback() {
        return Optional.ofNullable(this.playerDataOnLogoutCallback);
    }

    public void invokeLoginCallback(Config<T> config, PlayerData data, ServerPlayerEntity player) {
        if (this.playerDataOnLoginCallback != null) {
            try {
                this.playerDataOnLoginCallback.invoke((Object)data, player);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                AtlantisLogger.log(Settings.getSettings().getMissingCallbacksSeverity(), "No valid void onLogin(ServerPlayerEntity) callback in data " + config.getName(), new Object[0]);
            }
        }
    }

    public void invokeLogoutCallback(Config<T> config, PlayerData data, ServerPlayerEntity player) {
        if (this.playerDataOnLogoutCallback != null) {
            try {
                this.playerDataOnLogoutCallback.invoke((Object)data, player);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                AtlantisLogger.log(Settings.getSettings().getMissingCallbacksSeverity(), "No valid void onLogout(ServerPlayerEntity) callback in data " + config.getName(), new Object[0]);
            }
        }
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }
}

